/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.DisabledUserException;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.login.recovery.PasswordRecoveryServiceImpl;
import org.exoplatform.web.security.security.RemindPasswordTokenService;
import org.gatein.wci.security.Credentials;

public class PasswordRecoveryHandler
extends WebRequestHandler {
    protected static Log log = ExoLogger.getLogger(PasswordRecoveryHandler.class);
    public static final String NAME = "forgot-password";
    public static final QualifiedName TOKEN = QualifiedName.create((String)"gtn", (String)"token");
    public static final QualifiedName LANG = QualifiedName.create((String)"gtn", (String)"lang");
    public static final QualifiedName INIT_URL = QualifiedName.create((String)"gtn", (String)"initURL");
    public static final String REQ_PARAM_ACTION = "action";
    private static final ThreadLocal<Locale> currentLocale = new ThreadLocal();
    private static final String LOCALE_COOKIE = "LOCALE";
    private static final String LOCALE_SESSION_ATTR = "org.gatein.LOCALE";

    public String getHandlerName() {
        return NAME;
    }

    public boolean execute(ControllerContext context) throws Exception {
        HttpServletRequest req = context.getRequest();
        HttpServletResponse res = context.getResponse();
        PortalContainer container = PortalContainer.getCurrentInstance((ServletContext)req.getServletContext());
        ServletContext servletContext = container.getPortalContext();
        Pattern customPasswordPattern = Pattern.compile(PropertyManager.getProperty((String)"gatein.validators.passwordpolicy.regexp"));
        int customPasswordMaxlength = Integer.parseInt(PropertyManager.getProperty((String)"gatein.validators.passwordpolicy.length.max"));
        int customPasswordMinlength = Integer.parseInt(PropertyManager.getProperty((String)"gatein.validators.passwordpolicy.length.min"));
        Locale requestLocale = null;
        String lang = context.getParameter(LANG);
        Locale locale = lang != null && lang.length() > 0 ? (requestLocale = I18N.parseTagIdentifier((String)lang)) : this.calculateLocale(context);
        currentLocale.set(locale);
        req.setAttribute("request_locale", (Object)locale);
        PasswordRecoveryServiceImpl service = this.getService(PasswordRecoveryServiceImpl.class);
        ResourceBundleService bundleService = this.getService(ResourceBundleService.class);
        RemindPasswordTokenService remindPasswordTokenService = this.getService(RemindPasswordTokenService.class);
        OrganizationService orgService = this.getService(OrganizationService.class);
        ResourceBundle bundle = bundleService.getResourceBundle(bundleService.getSharedResourceBundleNames(), locale);
        String token = context.getParameter(TOKEN);
        String initURL = this.escapeXssCharacters(context.getParameter(INIT_URL));
        String requestAction = req.getParameter(REQ_PARAM_ACTION);
        if (token != null && !token.isEmpty()) {
            String tokenId = context.getParameter(TOKEN);
            Credentials credentials = service.verifyToken(tokenId, NAME);
            if (credentials == null) {
                return this.dispatch("/WEB-INF/jsp/forgotpassword/token_expired.jsp", servletContext, req, res);
            }
            String username = credentials.getUsername();
            if ("resetPassword".equalsIgnoreCase(requestAction)) {
                String reqUser = req.getParameter("username");
                String password = req.getParameter("password");
                String confirmPass = req.getParameter("password2");
                ArrayList<String> errors = new ArrayList<String>();
                String success = "";
                if (reqUser == null || !reqUser.equals(username)) {
                    String message = bundle.getString("gatein.forgotPassword.usernameChanged");
                    message = message.replace("{0}", username);
                    errors.add(message);
                } else {
                    if (password == null || !customPasswordPattern.matcher(password).matches() || customPasswordMaxlength < password.length() || customPasswordMinlength > password.length()) {
                        String passwordpolicyProperty = PropertyManager.getProperty((String)"gatein.validators.passwordpolicy.format.message");
                        errors.add(passwordpolicyProperty != null ? passwordpolicyProperty : bundle.getString("onboarding.login.passwordCondition"));
                    }
                    if (!password.equals(confirmPass)) {
                        errors.add(bundle.getString("gatein.forgotPassword.confirmPasswordNotMatch"));
                    }
                }
                if (errors.isEmpty()) {
                    if (service.changePass(tokenId, NAME, username, password)) {
                        String currentPortalContainerName = PortalContainer.getCurrentPortalContainerName();
                        res.sendRedirect("/" + currentPortalContainerName + "/login");
                        return true;
                    }
                    errors.add(bundle.getString("gatein.forgotPassword.resetPasswordFailure"));
                }
                req.setAttribute("password", (Object)password);
                req.setAttribute("password2", (Object)confirmPass);
                req.setAttribute("errors", errors);
                req.setAttribute("success", (Object)success);
            }
            req.setAttribute("tokenId", (Object)tokenId);
            req.setAttribute("username", (Object)this.escapeXssCharacters(username));
            return this.dispatch("/WEB-INF/jsp/forgotpassword/reset_password.jsp", servletContext, req, res);
        }
        if ("send".equalsIgnoreCase(requestAction)) {
            String user = req.getParameter("username");
            if (user != null && !user.trim().isEmpty()) {
                User u;
                try {
                    u = this.findUser(orgService, user);
                    if (u == null) {
                        req.setAttribute("success", (Object)bundle.getString("gatein.forgotPassword.userNotExist"));
                    }
                }
                catch (DisabledUserException e) {
                    req.setAttribute("success", (Object)bundle.getString("gatein.forgotPassword.userDisabled"));
                    u = null;
                }
                catch (Exception ex) {
                    req.setAttribute("error", (Object)bundle.getString("gatein.forgotPassword.loadUserError"));
                    u = null;
                }
                if (u != null) {
                    if (service.sendRecoverPasswordEmail(u, PasswordRecoveryHandler.getCurrentLocale(), req)) {
                        req.setAttribute("success", (Object)bundle.getString("gatein.forgotPassword.emailSendSuccessful"));
                        user = "";
                    } else {
                        req.setAttribute("error", (Object)bundle.getString("gatein.forgotPassword.emailSendFailure"));
                    }
                }
                req.setAttribute("username", (Object)this.escapeXssCharacters(user));
            } else {
                req.setAttribute("error", (Object)bundle.getString("gatein.forgotPassword.emptyUserOrEmail"));
            }
        }
        if (initURL != null) {
            req.setAttribute("initURL", (Object)initURL);
        }
        return this.dispatch("/WEB-INF/jsp/forgotpassword/forgot_password.jsp", servletContext, req, res);
    }

    protected boolean dispatch(String path, ServletContext context, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        RequestDispatcher dispatcher = context.getRequestDispatcher(path);
        if (dispatcher != null) {
            dispatcher.forward((ServletRequest)req, (ServletResponse)res);
            return true;
        }
        return false;
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }

    private <T> T getService(Class<T> clazz) {
        return (T)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(clazz);
    }

    public static Locale getCurrentLocale() {
        return currentLocale.get();
    }

    private Locale calculateLocale(ControllerContext context) {
        Locale locale;
        LocalePolicy localePolicy = this.getService(LocalePolicy.class);
        HttpServletRequest request = (HttpServletRequest)HttpServletRequest.class.cast(context.getRequest());
        LocaleContextInfo localeCtx = LocaleContextInfoUtils.buildLocaleContextInfo((HttpServletRequest)request);
        Set supportedLocales = LocaleContextInfoUtils.getSupportedLocales();
        boolean supported = supportedLocales.contains(locale = localePolicy.determineLocale(localeCtx));
        if (!supported && !"".equals(locale.getCountry())) {
            locale = new Locale(locale.getLanguage());
            supported = supportedLocales.contains(locale);
        }
        if (!supported) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Unsupported locale returned by LocalePolicy: " + localePolicy + ". Falling back to 'en'."));
            }
            locale = Locale.ENGLISH;
        }
        return locale;
    }

    private User findUser(OrganizationService orgService, String usernameOrEmail) throws Exception {
        if (usernameOrEmail == null || usernameOrEmail.isEmpty()) {
            return null;
        }
        User user = null;
        UserHandler uHandler = orgService.getUserHandler();
        user = uHandler.findUserByName(usernameOrEmail, UserStatus.ANY);
        if (user == null && usernameOrEmail.contains("@")) {
            Query query = new Query();
            query.setEmail(usernameOrEmail);
            ListAccess list = uHandler.findUsersByQuery(query, UserStatus.ANY);
            if (list != null && list.getSize() > 0) {
                user = ((User[])list.load(0, 1))[0];
            }
        }
        if (user != null && !user.isEnabled()) {
            throw new DisabledUserException(user.getUserName());
        }
        return user;
    }

    public String escapeXssCharacters(String message) {
        message = message == null ? null : message.replace("&", "&amp").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#x27;").replace("/", "&#x2F;");
        return message;
    }
}

