/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import org.apache.sis.internal.jaxb.TypeRegistration;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.TransformVersion;
import org.apache.sis.xml.TransformedEvent;

abstract class Transformer {
    private static final char TARGET_PREFIX = '*';
    private static final char RENAME_SEPARATOR = '/';
    private static final char EXTENDS = ':';
    static final char NO_NAMESPACE = '!';
    final TransformVersion version;
    private final List<QName> outerElements;
    private Map<String, String> outerElementProperties;
    final List<Attribute> renamedAttributes;
    private final Map<String, String> namespaces;

    Transformer(TransformVersion transformVersion) {
        this.version = transformVersion;
        this.namespaces = new HashMap<String, String>();
        this.outerElements = new ArrayList<QName>();
        this.renamedAttributes = new ArrayList<Attribute>();
        this.outerElementProperties = Collections.emptyMap();
    }

    static String removeTrailingSlash(String string) {
        int n = string.length() - 1;
        if (string.charAt(n) == '/') {
            string = string.substring(0, n);
        }
        return string;
    }

    static boolean isNamespace(String string) {
        return string.length() > 4 && string.charAt(4) == ':';
    }

    static Map<String, Map<String, String>> load(boolean bl, String string3, Set<String> set, int n) {
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>(n);
        LinkedHashSet linkedHashSet = new LinkedHashSet(8);
        linkedHashSet.add(Transformer.class);
        TypeRegistration.getRenameFileLoader(bl, linkedHashSet);
        for (Class clazz : linkedHashSet) {
            try (LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(clazz.getResourceAsStream(string3), "UTF-8"));){
                String string4;
                Map<String, String> map2 = null;
                String string5 = null;
                block13: while ((string4 = lineNumberReader.readLine()) != null) {
                    char c;
                    int n2 = string4.length();
                    int n3 = CharSequences.skipLeadingWhitespaces((CharSequence)string4, (int)0, (int)n2);
                    if (n3 >= n2 || (c = string4.charAt(n3)) == '#') continue;
                    if (c == '*') {
                        set.add(CharSequences.trimWhitespaces((CharSequence)string4, (int)(n3 + 1), (int)string4.length()).toString());
                        continue;
                    }
                    String string6 = string4.substring(n3).trim();
                    switch (n3) {
                        case 0: {
                            if (!Transformer.isNamespace(string6)) break;
                            string5 = string6.intern();
                            map2 = null;
                            continue block13;
                        }
                        case 1: {
                            Object object;
                            int n4;
                            if (string5 == null) break;
                            int n5 = string6.indexOf(33);
                            if (n5 >= 0) {
                                string6 = CharSequences.trimWhitespaces((CharSequence)string6, (int)0, (int)n5).toString();
                            }
                            if ((n4 = string6.indexOf(58)) >= 0) {
                                String string7 = CharSequences.trimWhitespaces((CharSequence)string6, (int)(n4 + 1), (int)string6.length()).toString();
                                string6 = CharSequences.trimWhitespaces((CharSequence)string6, (int)0, (int)n4).toString();
                                object = string2 -> {
                                    HashMap hashMap = (HashMap)hashMap.get(string7);
                                    if (hashMap != null) {
                                        hashMap = new HashMap(hashMap);
                                        hashMap.remove(string7);
                                        return hashMap;
                                    }
                                    throw new NoSuchElementException(string7);
                                };
                            } else {
                                object = string -> new HashMap();
                            }
                            string6 = string6.intern();
                            map2 = hashMap.computeIfAbsent(string6, (Function<String, Map<String, String>>)object);
                            if (n5 >= 0 || map2.put(string6, string5) == null) continue block13;
                            break;
                        }
                        case 2: {
                            Object object;
                            if (map2 == null || string5 == null) break;
                            int n5 = string6.indexOf(47);
                            if (n5 >= 0) {
                                object = string6.substring(0, n5).trim().intern();
                                if (map2.put((String)object, string6 = string6.substring(n5 + 1).trim().intern()) != null) {
                                    break;
                                }
                            } else {
                                string6 = string6.intern();
                            }
                            if (map2.put(string6, string5) == null) continue block13;
                            break;
                        }
                    }
                    throw new InvalidPropertiesFormatException(Errors.format((short)33, (Object)string3, (Object)lineNumberReader.getLineNumber()));
                }
            }
            catch (IOException iOException) {
                throw new ExceptionInInitializerError(iOException);
            }
        }
        hashMap.replaceAll((string, map) -> CollectionsExt.compact((Map)map));
        return hashMap;
    }

    final void notify(Namespace namespace) {
        this.namespaces.put(namespace.getPrefix(), namespace.getNamespaceURI());
    }

    final List<Attribute> attributes() {
        List<Attribute> list;
        switch (this.renamedAttributes.size()) {
            case 0: {
                list = Collections.emptyList();
                break;
            }
            case 1: {
                list = Collections.singletonList(this.renamedAttributes.remove(0));
                break;
            }
            default: {
                list = Arrays.asList(this.renamedAttributes.toArray(new Attribute[this.renamedAttributes.size()]));
                this.renamedAttributes.clear();
            }
        }
        return list;
    }

    final Attribute convert(Attribute attribute) throws XMLStreamException {
        QName qName = attribute.getName();
        if ("type".equals(qName.getLocalPart()) && "http://www.w3.org/2001/XMLSchema-instance".equals(qName.getNamespaceURI())) {
            String string;
            String string2;
            int n;
            String string3 = attribute.getValue();
            if (string3 != null && (n = string3.indexOf(58)) >= 0 && (string2 = this.namespaces.get(string = string3.substring(0, n).trim())) != null) {
                String string4 = string3.substring(n + 1).trim();
                QName qName2 = new QName(string2, string4, string);
                Map<String, String> map = this.outerElementProperties;
                this.outerElementProperties = this.renamingMap(string2).getOrDefault(string4, Collections.emptyMap());
                boolean bl = qName2 != (qName2 = this.convert(qName2));
                this.outerElementProperties = map;
                if (bl) {
                    string = qName2.getPrefix();
                    string4 = qName2.getLocalPart();
                    string2 = qName2.getNamespaceURI();
                    TransformedEvent.Type type = new TransformedEvent.Type(attribute, qName, string + ':' + string4);
                    if (!string2.equals(this.namespaces.get(string))) {
                        type.namespace = new TransformedEvent.NS(attribute, string, string2);
                    }
                    return type;
                }
            }
        } else {
            QName qName3 = this.convert(qName);
            if (qName3 != qName) {
                attribute = new TransformedEvent.Attr(attribute, qName3);
            }
        }
        return attribute;
    }

    private static boolean isTypeElement(String string) {
        if (string.length() < 4) {
            return false;
        }
        char c = string.charAt(0);
        return c >= 'A' && c <= 'Z';
    }

    final void open(QName qName) {
        String string = qName.getLocalPart();
        if (Transformer.isTypeElement(string)) {
            this.outerElements.add(qName);
            this.outerElementProperties = this.renamingMap(qName.getNamespaceURI()).getOrDefault(string, Collections.emptyMap());
        }
    }

    final void close(QName qName) {
        if (Transformer.isTypeElement(qName.getLocalPart())) {
            this.outerElementProperties = null;
            int n = this.outerElements.size();
            while (--n >= 0) {
                String string;
                String string2;
                if (!qName.equals(this.outerElements.get(n))) continue;
                this.outerElements.remove(n);
                if (--n >= 0) {
                    QName qName2 = this.outerElements.get(n);
                    string2 = qName2.getNamespaceURI();
                    string = qName2.getLocalPart();
                } else {
                    string2 = "";
                    string = null;
                }
                this.outerElementProperties = this.renamingMap(string2).getOrDefault(string, Collections.emptyMap());
                break;
            }
        }
    }

    public void close() throws XMLStreamException {
        this.outerElementProperties = null;
        this.outerElements.clear();
    }

    final QName convert(QName qName) throws XMLStreamException {
        String string = qName.getLocalPart();
        String string2 = this.outerElementProperties.get(string);
        if (string2 != null && !Transformer.isNamespace(string2)) {
            string = string2;
            string2 = this.outerElementProperties.get(string);
        }
        String string3 = qName.getNamespaceURI();
        if (string2 == null) {
            string2 = this.relocate(string3);
        }
        if (!string2.equals(string3) || !string.equals(qName.getLocalPart())) {
            qName = new QName(string2, string, this.prefixReplacement(qName.getPrefix(), string2));
        }
        return qName;
    }

    abstract Map<String, Map<String, String>> renamingMap(String var1);

    abstract String relocate(String var1);

    abstract String prefixReplacement(String var1, String var2) throws XMLStreamException;
}

