/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.resources;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.iso.AbstractInternationalString;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.KeyConstants;

public abstract class ResourceInternationalString
extends AbstractInternationalString
implements Serializable {
    private static final long serialVersionUID = -3910920973710535739L;
    private transient short key;
    private final boolean hasArguments;
    private final Object arguments;

    protected ResourceInternationalString(short s) {
        this.key = s;
        this.hasArguments = false;
        this.arguments = null;
    }

    protected ResourceInternationalString(short s, Object object) {
        this.key = s;
        this.hasArguments = true;
        this.arguments = object;
    }

    protected abstract KeyConstants getKeyConstants();

    protected abstract IndexedResourceBundle getBundle(Locale var1);

    public final LogRecord toLogRecord(Level level) {
        LogRecord logRecord = new LogRecord(level, this.getKeyConstants().getKeyName(this.key));
        IndexedResourceBundle indexedResourceBundle = this.getBundle(null);
        logRecord.setResourceBundleName(indexedResourceBundle.getClass().getName());
        logRecord.setResourceBundle(indexedResourceBundle);
        if (this.hasArguments) {
            logRecord.setParameters(indexedResourceBundle.toArray(this.arguments));
        }
        return logRecord;
    }

    @Override
    public final String toString(Locale locale) throws MissingResourceException {
        IndexedResourceBundle indexedResourceBundle = this.getBundle(locale);
        return this.hasArguments ? indexedResourceBundle.getString(this.key, this.arguments) : indexedResourceBundle.getString(this.key);
    }

    public final boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        ResourceInternationalString resourceInternationalString = (ResourceInternationalString)object;
        return this.key == resourceInternationalString.key && this.hasArguments == resourceInternationalString.hasArguments && Objects.deepEquals(this.arguments, resourceInternationalString.arguments);
    }

    public final int hashCode() {
        return this.getClass().hashCode() ^ this.key + 31 * Utilities.deepHashCode(this.arguments) ^ 0x695BD3C5;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeUTF(this.getKeyConstants().getKeyName(this.key));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.key = this.getKeyConstants().getKeyValue(objectInputStream.readUTF());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw (InvalidObjectException)new InvalidObjectException(reflectiveOperationException.toString()).initCause(reflectiveOperationException);
        }
    }
}

