/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.query;

import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.internal.storage.query.FeatureSubset;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.Query;
import org.apache.sis.util.ArgumentChecks;

public class SimpleQuery
extends Query {
    private static final long UNLIMITED = -1L;
    private long skip;
    private long limit = -1L;

    public void setOffset(long l) {
        ArgumentChecks.ensurePositive((String)"skip", (long)l);
        this.skip = l;
    }

    public long getOffset() {
        return this.skip;
    }

    public void setLimit(long l) {
        if (l != -1L) {
            ArgumentChecks.ensurePositive((String)"limit", (long)l);
        }
        this.limit = l;
    }

    public long getLimit() {
        return this.limit;
    }

    public FeatureSet execute(FeatureSet featureSet) {
        ArgumentChecks.ensureNonNull((String)"source", (Object)featureSet);
        return new FeatureSubset(featureSet, this);
    }

    final DefaultFeatureType expectedType(DefaultFeatureType defaultFeatureType) {
        return defaultFeatureType;
    }

    public int hashCode() {
        return Long.hashCode(this.limit ^ this.skip);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            SimpleQuery simpleQuery = (SimpleQuery)object;
            return this.skip == simpleQuery.skip && this.limit == simpleQuery.limit;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("SELECT ");
        stringBuilder.append('*');
        if (this.limit != -1L) {
            stringBuilder.append(" LIMIT ").append(this.limit);
        }
        if (this.skip != 0L) {
            stringBuilder.append(" OFFSET ").append(this.skip);
        }
        return stringBuilder.toString();
    }
}

