/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.groovyscript;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import java.io.Reader;
import java.io.StringReader;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletConfig;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.groovyscript.BaseScript;
import org.exoplatform.groovyscript.GroovyCompilationException;
import org.exoplatform.groovyscript.GroovyScript;
import org.exoplatform.groovyscript.GroovyText;
import org.exoplatform.groovyscript.LineBreakItem;
import org.exoplatform.groovyscript.Position;
import org.exoplatform.groovyscript.SectionItem;
import org.exoplatform.groovyscript.SectionType;
import org.exoplatform.groovyscript.TemplateCompilationException;
import org.exoplatform.groovyscript.TemplateParser;
import org.exoplatform.groovyscript.TemplateSection;
import org.exoplatform.groovyscript.TextItem;
import org.gatein.common.classloader.DelegatingClassLoader;

public class GroovyScriptBuilder {
    private final String templateId;
    private final String templateName;
    private final String templateText;
    private SectionType currentType = null;
    private StringBuilder accumulatedText = new StringBuilder();
    private Script script = new Script();

    public GroovyScriptBuilder(String templateId, String templateName, String templateText) {
        this.templateId = templateId;
        this.templateName = templateName;
        this.templateText = templateText;
    }

    private void begin(SectionType sectionType, Position pos) {
        if (sectionType == null) {
            throw new NullPointerException();
        }
        if (pos == null) {
            throw new NullPointerException();
        }
        if (this.currentType != null) {
            throw new IllegalStateException();
        }
        this.currentType = sectionType;
        switch (this.currentType) {
            case STRING: {
                break;
            }
            case SCRIPTLET: {
                break;
            }
            case EXPR: {
                this.script.appendGroovy(";out.print(\"${");
            }
        }
    }

    private void append(SectionItem item) {
        if (item instanceof TextItem) {
            TextItem textItem = (TextItem)item;
            String text = textItem.getData();
            switch (this.currentType) {
                case STRING: {
                    this.accumulatedText.append(text);
                    break;
                }
                case SCRIPTLET: {
                    this.script.appendGroovy(text);
                    this.script.positionTable.put(this.script.lineNumber, textItem);
                    break;
                }
                case EXPR: {
                    this.script.appendGroovy(text);
                    this.script.positionTable.put(this.script.lineNumber, textItem);
                }
            }
        } else if (item instanceof LineBreakItem) {
            switch (this.currentType) {
                case STRING: {
                    this.accumulatedText.append("\n");
                    break;
                }
                case SCRIPTLET: 
                case EXPR: {
                    this.script.appendGroovy("\n");
                    ++this.script.lineNumber;
                }
            }
        } else {
            throw new AssertionError();
        }
    }

    private void end() {
        if (this.currentType == null) {
            throw new IllegalStateException();
        }
        switch (this.currentType) {
            case STRING: {
                if (this.accumulatedText.length() <= 0) break;
                this.script.appendText(this.accumulatedText.toString());
                this.accumulatedText.setLength(0);
                break;
            }
            case SCRIPTLET: {
                this.script.appendGroovy("\n");
                ++this.script.lineNumber;
                break;
            }
            case EXPR: {
                this.script.appendGroovy("}\");\n");
                ++this.script.lineNumber;
            }
        }
        this.currentType = null;
    }

    public GroovyScript build() throws TemplateCompilationException {
        Class scriptClass;
        List<TemplateSection> sections = new TemplateParser().parse(this.templateText);
        for (TemplateSection section : sections) {
            this.begin(section.getType(), section.getItems().get(0).getPosition());
            for (SectionItem item : section.getItems()) {
                this.append(item);
            }
            this.end();
        }
        String groovyText = this.script.toString();
        CompilerConfiguration config = new CompilerConfiguration();
        config.setScriptBaseClass(BaseScript.class.getName());
        StringReader in = new StringReader(groovyText);
        GroovyCodeSource gcs = new GroovyCodeSource((Reader)in, this.templateName, "/groovy/shell");
        GroovyClassLoader loader = new GroovyClassLoader(this.prepareClassLoader(), config);
        try {
            scriptClass = loader.parseClass(gcs, false);
        }
        catch (CompilationFailedException e) {
            throw new GroovyCompilationException(e, this.templateText, groovyText);
        }
        catch (ClassFormatError e) {
            throw new GroovyCompilationException(e, this.templateText, groovyText);
        }
        return new GroovyScript(this.templateId, this.script.toString(), scriptClass, Collections.unmodifiableMap(new HashMap<Integer, TextItem>(this.script.positionTable)));
    }

    private ClassLoader prepareClassLoader() {
        ClassLoader tccl = (ClassLoader)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return new DelegatingClassLoader(new ClassLoader[]{tccl, GroovyClassLoader.class.getClassLoader(), PortletConfig.class.getClassLoader()});
    }

    private static class TextContant {
        private final String name;
        private final String text;

        private TextContant(String name, String text) {
            this.name = name;
            this.text = text;
        }

        public String getDeclaration() {
            StringBuilder builder = new StringBuilder("");
            for (int i = 0; i < this.text.length(); ++i) {
                char c = this.text.charAt(i);
                if (c == '\n') {
                    builder.append("\\n");
                    continue;
                }
                if (c == '\"') {
                    builder.append("\\\"");
                    continue;
                }
                builder.append(c);
            }
            return "public static final " + GroovyText.class.getName() + " " + this.name + " = new " + GroovyText.class.getName() + "(\"" + builder + "\");";
        }
    }

    private static class Script {
        private StringBuilder out = new StringBuilder();
        private List<TextContant> textMethods = new ArrayList<TextContant>();
        private int methodCount = 0;
        private Map<Integer, TextItem> positionTable = new HashMap<Integer, TextItem>();
        private int lineNumber = 1;

        private Script() {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.out.toString());
            builder.append("\n");
            builder.append("public class Constants\n");
            builder.append("{\n");
            for (TextContant method : this.textMethods) {
                builder.append(method.getDeclaration()).append("\n");
            }
            builder.append("}\n");
            return builder.toString();
        }

        public void appendText(String text) {
            TextContant m = new TextContant("s" + this.methodCount++, text);
            this.out.append("out.print(Constants.").append(m.name).append(");\n");
            this.textMethods.add(m);
            ++this.lineNumber;
        }

        public void appendGroovy(String s) {
            this.out.append(s);
        }
    }
}

