/*
 * Decompiled with CFR 0.152.
 */
package org.suigeneris.jrcs.rcs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.suigeneris.jrcs.diff.Diff;
import org.suigeneris.jrcs.diff.DiffException;
import org.suigeneris.jrcs.diff.DifferentiationFailedException;
import org.suigeneris.jrcs.diff.PatchFailedException;
import org.suigeneris.jrcs.rcs.HeadAlreadySetException;
import org.suigeneris.jrcs.rcs.InvalidBranchVersionNumberException;
import org.suigeneris.jrcs.rcs.InvalidFileFormatException;
import org.suigeneris.jrcs.rcs.InvalidTrunkVersionNumberException;
import org.suigeneris.jrcs.rcs.InvalidVersionNumberException;
import org.suigeneris.jrcs.rcs.Version;
import org.suigeneris.jrcs.rcs.impl.BranchNode;
import org.suigeneris.jrcs.rcs.impl.Lines;
import org.suigeneris.jrcs.rcs.impl.Node;
import org.suigeneris.jrcs.rcs.impl.NodeNotFoundException;
import org.suigeneris.jrcs.rcs.impl.Path;
import org.suigeneris.jrcs.rcs.impl.Phrases;
import org.suigeneris.jrcs.rcs.impl.TrunkNode;
import org.suigeneris.jrcs.rcs.parse.ArchiveParser;
import org.suigeneris.jrcs.rcs.parse.FastCharStream;
import org.suigeneris.jrcs.rcs.parse.ParseException;
import org.suigeneris.jrcs.rcs.text.KeywordFormatter;
import org.suigeneris.jrcs.util.ToString;

public class Archive
extends ToString {
    public static final String EXP_KeywordAndValue = "kv";
    public static final String EXP_KeywordValueAndLocker = "kvl";
    public static final String EXP_KeywordOnly = "k";
    public static final String EXP_PreserveOriginal = "o";
    public static final String EXP_Binary = "b";
    public static final String EXP_ValueOnly = "v";
    public static final char RCS_NEWLINE_CHAR = '\n';
    public static final String RCS_NEWLINE = Character.toString('\n');
    protected TrunkNode head;
    protected Version branch;
    protected Map nodes = new TreeMap();
    protected Set users = new TreeSet();
    protected Set locked = new TreeSet();
    protected Map symbols = new TreeMap();
    protected Phrases phrases = new Phrases();
    protected String desc = new String();
    protected boolean strictLocking = true;
    protected String expand;
    protected String comment = "# ";
    protected String filename = "__unknown__,v";

    public Archive(Object[] text, String desc) {
        this(text, desc, new Version(1, 1));
    }

    public Archive(Object[] text, String desc, String vernum) {
        this(text, desc, new Version(vernum));
    }

    public Archive(Object[] text, String desc, Version vernum) {
        if (vernum.size() > 2) {
            throw new InvalidVersionNumberException(vernum + " must be a trunk version");
        }
        while (vernum.size() < 2) {
            vernum = vernum.newBranch(1);
        }
        this.head = (TrunkNode)this.newNode(vernum, null);
        this.head.setText(text);
        this.head.setLog(desc);
    }

    public Archive(String fname, Reader reader) throws ParseException {
        this.filename = fname;
        ArchiveParser.load(this, new FastCharStream(reader));
    }

    public Archive(String fname, InputStream input) throws ParseException {
        this(fname, new InputStreamReader(input));
    }

    public Archive(String path) throws ParseException, FileNotFoundException {
        this.filename = new File(path).getPath();
        ArchiveParser.load(this, this.filename);
    }

    public Archive(URL url) throws ParseException, IOException {
        this(url.getFile(), url.openStream());
    }

    Archive() {
    }

    public Version version(String vernum) throws InvalidVersionNumberException {
        if (vernum.length() > 0 && !Character.isDigit(vernum.charAt(0))) {
            return (Version)this.symbols.get(vernum);
        }
        return new Version(vernum);
    }

    public void setFileName(String path) {
        this.filename = path;
    }

    public void save(OutputStream output) throws IOException {
        output.write(this.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String path) throws IOException {
        FileOutputStream output = new FileOutputStream(path);
        try {
            this.save(output);
            this.filename = new File(path).getPath();
        }
        finally {
            ((OutputStream)output).close();
        }
    }

    protected void setHead(Version vernum) throws InvalidVersionNumberException {
        if (this.head != null) {
            throw new HeadAlreadySetException(this.head.getVersion());
        }
        this.head = new TrunkNode(vernum, null);
        this.nodes.put(vernum, this.head);
    }

    public void setBranch(String v) throws InvalidBranchVersionNumberException {
        if (v == null) {
            this.branch = null;
        } else {
            this.setBranch(this.version(v));
        }
    }

    public void setBranch(Version vernum) throws InvalidBranchVersionNumberException {
        if (!vernum.isBranch()) {
            throw new InvalidBranchVersionNumberException(vernum);
        }
        if (this.head == null || vernum.getBase(2).isGreaterThan(this.head.getVersion())) {
            throw new InvalidBranchVersionNumberException(vernum + "is greater than _head version " + this.head.getVersion());
        }
        this.branch = vernum;
    }

    public void addUser(String name) {
        this.users.add(name);
    }

    public boolean isValidSymbol(String sym) {
        return sym != null && sym.matches("[A-Za-z_-][A-Za-z0-9_-]*");
    }

    public void addSymbol(String sym, String vernum) {
        if (!this.isValidSymbol(sym)) {
            throw new IllegalArgumentException("invalid symbolic tag");
        }
        this.addSymbol(sym, new Version(vernum));
    }

    public void addSymbol(String sym, Version vernum) throws InvalidVersionNumberException {
        this.symbols.put(sym, vernum);
    }

    public Map getSymbols() {
        return this.symbols;
    }

    public void addLock(String user, Version vernum) throws InvalidVersionNumberException, NodeNotFoundException {
        this.addUser(user);
        Node node = this.newNode(vernum);
        node.setLocker(user);
        if (user == null) {
            this.locked.remove(node);
        } else {
            this.locked.add(node);
        }
    }

    public void setStrictLocking(boolean value) {
        this.strictLocking = value;
    }

    public void setExpand(String value) {
        this.expand = value;
    }

    public String getExpand() {
        return this.expand;
    }

    public boolean isBinary() {
        return EXP_Binary.equals(this.getExpand());
    }

    public void setComment(String value) {
        this.comment = value;
    }

    public void setDesc(String value) {
        this.desc = value;
    }

    public void addPhrase(String key, Collection values) {
        this.phrases.put(key, values);
    }

    protected Phrases getPhrases() {
        return this.phrases;
    }

    protected Node newNode(Version vernum) {
        return this.newNode(vernum, null);
    }

    protected Node newNode(Version vernum, Node prev) throws InvalidVersionNumberException, NodeNotFoundException {
        if (!vernum.isRevision()) {
            throw new InvalidVersionNumberException(vernum);
        }
        Node node = (Node)this.nodes.get(vernum);
        if (node == null) {
            node = Node.newNode(vernum, prev);
            this.nodes.put(vernum, node);
        }
        return node;
    }

    protected TrunkNode newTrunkNode(Version vernum) throws InvalidVersionNumberException, NodeNotFoundException {
        if (!vernum.isTrunk()) {
            throw new InvalidTrunkVersionNumberException(vernum);
        }
        return (TrunkNode)this.newNode(vernum);
    }

    protected BranchNode newBranchNode(Version vernum) throws InvalidVersionNumberException, NodeNotFoundException {
        if (!vernum.isBranch()) {
            throw new InvalidBranchVersionNumberException(vernum);
        }
        return (BranchNode)this.newNode(vernum);
    }

    protected Node getNode(Version vernum) throws InvalidVersionNumberException, NodeNotFoundException {
        if (!vernum.isRevision()) {
            throw new InvalidVersionNumberException(vernum);
        }
        Node node = (Node)this.nodes.get(vernum);
        if (node == null) {
            throw new NodeNotFoundException(vernum);
        }
        return node;
    }

    public Node findNode(Version vernum) {
        Path path = this.getRevisionPath(vernum);
        return path == null ? null : path.last();
    }

    public void toString(StringBuffer s) {
        this.toString(s, RCS_NEWLINE);
    }

    public String toString(String eol) {
        StringBuffer s = new StringBuffer();
        this.toString(s, eol);
        return s.toString();
    }

    public String toString(char eol) {
        return this.toString(Character.toString(eol));
    }

    public char[] toCharArray() {
        return this.toString(RCS_NEWLINE).toCharArray();
    }

    public byte[] toByteArray() {
        return this.toString(RCS_NEWLINE).getBytes();
    }

    protected Path getRevisionPath(Version vernum) {
        if (this.head == null) {
            return null;
        }
        try {
            Path path = this.head.pathTo(vernum, true);
            Node revisionFound = path.last();
            if (revisionFound == null) {
                return null;
            }
            if (revisionFound.getVersion().isLessThan(vernum)) {
                return null;
            }
            return path;
        }
        catch (NodeNotFoundException e) {
            return null;
        }
    }

    public Version getRevisionVersion(Version vernum) {
        Path path = this.getRevisionPath(vernum);
        return path == null ? null : path.last().getVersion();
    }

    public Version getRevisionVersion(String vernum) {
        return this.getRevisionVersion(this.version(vernum));
    }

    public Version getRevisionVersion() {
        if (this.branch != null) {
            return this.getRevisionVersion(this.branch);
        }
        if (this.head != null) {
            return this.head.getVersion();
        }
        return null;
    }

    public void toString(StringBuffer s, String EOL) {
        String EOI = ";" + EOL;
        String NLT = EOL + "\t";
        s.append("head");
        if (this.head != null) {
            s.append("\t");
            this.head.getVersion().toString(s);
        }
        s.append(EOI);
        if (this.branch != null) {
            s.append("branch\t");
            s.append(this.branch.toString());
            s.append(EOI);
        }
        s.append("access");
        Iterator<Object> i = this.users.iterator();
        while (i.hasNext()) {
            s.append(EOL);
            s.append("\t");
            s.append(i.next());
        }
        s.append(EOI);
        s.append("symbols");
        i = this.symbols.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = (Map.Entry)i.next();
            s.append(NLT);
            s.append(e.getKey().toString());
            s.append(":");
            s.append(e.getValue().toString());
        }
        s.append(EOI);
        s.append("locks");
        i = this.locked.iterator();
        while (i.hasNext()) {
            String locker = ((Node)i.next()).getLocker();
            s.append(NLT);
            s.append(locker);
        }
        if (this.strictLocking) {
            s.append("; strict");
        }
        s.append(EOI);
        if (this.comment != null) {
            s.append("comment\t");
            s.append(Archive.quoteString(this.comment));
            s.append(EOI);
        }
        if (this.expand != null) {
            s.append("expand\t");
            s.append(Archive.quoteString(this.expand));
            s.append(EOI);
        }
        if (this.phrases != null) {
            this.phrases.toString(s, EOL);
        }
        s.append(EOL);
        i = this.nodes.values().iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            if (n.getVersion().isGhost() || n.getText() == null) continue;
            n.toString(s, EOL);
        }
        s.append(EOL + EOL);
        s.append("desc");
        s.append(EOL);
        s.append(Archive.quoteString(this.desc));
        s.append(EOL);
        for (Node n = this.head; n != null; n = n.getRCSNext()) {
            n.toText(s, EOL);
        }
    }

    public static String quoteString(String s) {
        StringBuffer result = new StringBuffer(s.replaceAll("@", "@@"));
        result.insert(0, '@');
        result.append('@');
        return result.toString();
    }

    public static String unquoteString(String s) throws ParseException {
        return Archive.unquoteString(s, true);
    }

    public static String unquoteString(String s, boolean removeExtremes) throws ParseException {
        if (removeExtremes) {
            if (s.charAt(0) != '@' || s.charAt(s.length() - 1) != '@') {
                throw new ParseException("bad quoted string:" + s);
            }
            s = s.substring(1, s.length() - 1);
        }
        Pattern pat = Pattern.compile("@@");
        return pat.matcher(s).replaceAll("@");
    }

    public Object[] getRevision() throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        return this.getRevision(false);
    }

    public Object[] getRevision(boolean annotate) throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        if (this.branch != null) {
            return this.getRevision(this.branch);
        }
        if (this.head != null) {
            return this.getRevision(this.head.getVersion());
        }
        throw new IllegalStateException("no head node");
    }

    public Object[] getRevision(String vernum) throws InvalidFileFormatException, PatchFailedException, InvalidVersionNumberException, NodeNotFoundException {
        return this.getRevision(vernum, false);
    }

    public Object[] getRevision(String vernum, String expansion) throws InvalidFileFormatException, PatchFailedException, InvalidVersionNumberException, NodeNotFoundException {
        return this.getRevision(vernum, expansion, false);
    }

    public Object[] getRevision(String vernum, boolean annotate) throws InvalidVersionNumberException, NodeNotFoundException, InvalidFileFormatException, PatchFailedException {
        return this.getRevision(this.version(vernum), annotate);
    }

    public Object[] getRevision(String vernum, String expansion, boolean annotate) throws InvalidVersionNumberException, NodeNotFoundException, InvalidFileFormatException, PatchFailedException {
        return this.getRevision(this.version(vernum), expansion, annotate);
    }

    public Object[] getRevision(Version vernum) throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        return this.getRevision(vernum, false);
    }

    public Object[] getRevision(Version vernum, boolean annotate) throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        return this.getRevision(vernum, this.getExpand(), annotate);
    }

    public Object[] getRevision(Version vernum, String expansion, boolean annotate) throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        Path path = this.getRevisionPath(vernum);
        if (path == null) {
            throw new NodeNotFoundException(vernum);
        }
        if (EXP_Binary.equals(expansion)) {
            return path.last().mergedText();
        }
        Lines lines = new Lines();
        Node revisionFound = path.last();
        path.patch(lines, annotate);
        return this.doKeywords(lines.toArray(), revisionFound, expansion);
    }

    public Version addRevision(Object[] text, String log) throws InvalidFileFormatException, DiffException, InvalidVersionNumberException, NodeNotFoundException {
        if (this.branch != null) {
            return this.addRevision(text, this.branch, log);
        }
        return this.addRevision(text, this.head.getVersion().next(), log);
    }

    public Version addRevision(Object[] text, String vernum, String log) throws InvalidFileFormatException, DiffException, InvalidVersionNumberException, NodeNotFoundException {
        return this.addRevision(text, this.version(vernum), log);
    }

    public Version addRevision(Object[] text, Version vernum, String log) throws InvalidFileFormatException, DiffException, NodeNotFoundException, InvalidVersionNumberException {
        if (this.head == null) {
            throw new IllegalStateException("no head node");
        }
        Path path = this.head.pathTo(vernum, true);
        Node target = path.last();
        if (vernum.size() < target.getVersion().size()) {
            vernum = target.nextVersion();
        } else {
            if (!vernum.isGreaterThan(target.getVersion())) {
                throw new InvalidVersionNumberException(vernum + " revision must be higher than " + target.getVersion());
            }
            if (vernum.odd()) {
                vernum = vernum.last() == 0 ? target.newBranchVersion() : vernum.newBranch(1);
            } else if (vernum.last() == 0) {
                vernum = vernum.next();
            }
        }
        boolean headAdd = target == this.head && !vernum.isBranch();
        text = Archive.removeKeywords(text);
        String deltaText = null;
        if (!this.isBinary()) {
            if (headAdd) {
                deltaText = Diff.diff((Object[])text, (Object[])this.head.getText()).toRCSString(RCS_NEWLINE);
            } else {
                Object[] oldText = path.patch().toArray();
                deltaText = Diff.diff((Object[])oldText, (Object[])text).toRCSString(RCS_NEWLINE);
            }
            if (deltaText.length() == 0) {
                return null;
            }
        }
        Node newNode = null;
        if (headAdd) {
            newNode = this.newNode(vernum, this.head);
            newNode.setText(text);
            if (!this.isBinary()) {
                this.head.setText(deltaText);
            }
            this.head = (TrunkNode)newNode;
        } else {
            newNode = this.newNode(vernum);
            if (!this.isBinary()) {
                newNode.setText(deltaText);
            } else {
                newNode.setText(text);
            }
            if (vernum.size() > target.getVersion().size()) {
                target.addBranch((BranchNode)newNode);
            } else {
                target.setRCSNext(newNode);
            }
        }
        newNode.setLog(log);
        return newNode.getVersion();
    }

    public Object[] doKeywords(Object[] text, Node rev, String expansion) throws PatchFailedException {
        KeywordFormatter keywordFormatter;
        if (EXP_Binary.equals(expansion) || EXP_PreserveOriginal.equals(expansion)) {
            return text;
        }
        Object[] revisionInfo = new Object[]{this.filename, new File(this.filename).getName(), rev.getVersion().toString(), rev.getDate(), rev.getAuthor(), rev.getState(), rev.getLocker()};
        if (EXP_KeywordOnly.equals(expansion)) {
            keywordFormatter = KeywordFormatter.getKeywordOnlyFormatter();
        }
        if (EXP_ValueOnly.equals(expansion)) {
            keywordFormatter = KeywordFormatter.getValueOnlyFormatter();
        }
        KeywordFormatter formatter = KeywordFormatter.getKeywordAndValueFormatter();
        Object[] result = new Object[text.length];
        for (int i = 0; i < text.length; ++i) {
            result[i] = formatter.update(text[i].toString(), revisionInfo);
        }
        return result;
    }

    protected static Object[] removeKeywords(Object[] text) throws PatchFailedException {
        Object[] result = new Object[text.length];
        for (int i = 0; i < text.length; ++i) {
            result[i] = KeywordFormatter.getKeywordAndValueFormatter().reset(text[i].toString());
        }
        return result;
    }

    public Node[] changeLog() {
        return this.changeLog(this.head.version);
    }

    public Node[] changeLog(Version latest) {
        return this.changeLog(latest, this.head.root().version);
    }

    public Node[] changeLog(Version latest, Version earliest) {
        Node node;
        Node last = this.findNode(latest);
        if (last == null) {
            throw new NodeNotFoundException(latest.toString());
        }
        Node first = this.findNode(earliest);
        if (first == null) {
            throw new NodeNotFoundException(earliest.toString());
        }
        LinkedList<Node> result = new LinkedList<Node>();
        for (node = last; node != null; node = node.getParent()) {
            result.add(0, node);
            if (node == first) break;
        }
        if (node == null) {
            throw new NodeNotFoundException(earliest.toString());
        }
        return result.toArray(new Node[result.size()]);
    }

    public String getDesc() {
        return this.desc;
    }

    public String getLog(Version version) throws NodeNotFoundException {
        Node node = this.findNode(version);
        if (node == null) {
            throw new NodeNotFoundException("There's no version " + version);
        }
        return node.getLog();
    }

    public String getLog(String vernum) throws InvalidVersionNumberException, NodeNotFoundException {
        return this.getLog(this.version(vernum));
    }

    public void Remove() throws NodeNotFoundException, InvalidFileFormatException, PatchFailedException, DifferentiationFailedException {
        if (this.nodes.size() == 1) {
            throw new UnsupportedOperationException("attempt to delete all revisions");
        }
        Version v = this.getRevisionVersion();
        Node top = this.getNode(v);
        this.removeNode(top);
    }

    public void Remove(String vernum) throws NodeNotFoundException, InvalidFileFormatException, PatchFailedException, InvalidVersionNumberException, DifferentiationFailedException {
        this.Remove(this.version(vernum));
    }

    public void Remove(Version version) throws NodeNotFoundException, InvalidFileFormatException, PatchFailedException, DifferentiationFailedException {
        Node target = this.getNode(version);
        this.removeNode(target);
    }

    private void removeNode(Node node) throws NodeNotFoundException, InvalidFileFormatException, PatchFailedException, DifferentiationFailedException {
        if (this.nodes.size() == 1) {
            throw new UnsupportedOperationException("attempt to delete all revisions");
        }
        Node parent = node.getParent();
        Node child = node.getChild();
        if (node.version.isBranch() && child == null) {
            parent.removeBranch(node);
            parent.setRCSNext(null);
        } else if (this.head == node) {
            Object[] text = this.getRevision(parent.version, false);
            parent.setText(text);
            this.head = (TrunkNode)parent;
        } else {
            Object[] parentTxt = this.getRevision(parent.version);
            Object[] childTxt = this.getRevision(child.version);
            if (node.version.isTrunk()) {
                String deltaText = Diff.diff((Object[])childTxt, (Object[])parentTxt).toRCSString(RCS_NEWLINE);
                parent.setText(deltaText);
            } else {
                String deltaText = Diff.diff((Object[])parentTxt, (Object[])childTxt).toRCSString(RCS_NEWLINE);
                child.setText(deltaText);
                parent.removeBranch(node);
                parent.setRCSNext(child);
            }
        }
        this.nodes.remove(node.version);
    }
}

