/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login.onboarding;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Locale;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.rest.UserFieldValidator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.web.filter.Filter;
import org.exoplatform.web.login.onboarding.OnboardingUIParamsForRegister;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.exoplatform.web.register.RegistrationException;
import org.exoplatform.web.security.security.SecureRandomService;

public class OnboardingRegisterFilter
implements Filter {
    public static final String ON_BOARDING_EMAIL_SENT = "onBoardingEmailSent";
    private static final Log LOG = ExoLogger.getLogger(OnboardingRegisterFilter.class);
    public static final String REGISTRATION_ERROR_CODE = "REGISTRATION_ERROR";
    public static final String ONBOARDING_REGISTER_REQUEST_PARAM = "onboardingRegister";
    public static final String EMAIL_REQUEST_PARAM = "email";
    private static final UserFieldValidator EMAIL_VALIDATOR = new UserFieldValidator("email", false, false);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (request.getRemoteUser() != null || request.getParameter(ONBOARDING_REGISTER_REQUEST_PARAM) == null || request.getParameter("onboardingRegisterToken") == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (!((OnboardingUIParamsForRegister)ExoContainerContext.getService(OnboardingUIParamsForRegister.class)).isRegisterEnabled()) {
            LOG.warn((Object)"An hack tentative for user registration was detected");
            response.setStatus(401);
            return;
        }
        String email = request.getParameter(EMAIL_REQUEST_PARAM);
        try {
            this.validateToken(request);
            this.validateEmail(email, request.getLocale());
            User user = this.registerUser(email);
            boolean sent = this.sendOnboardingEmail(user, request);
            if (sent) {
                request.setAttribute(ON_BOARDING_EMAIL_SENT, (Object)true);
            }
        }
        catch (RegistrationException e) {
            request.setAttribute("errorCode", (Object)e.getMessage());
        }
        catch (Exception e) {
            LOG.warn("Error while sending onboarding mail to user {}", new Object[]{email, e});
            request.setAttribute("errorCode", (Object)REGISTRATION_ERROR_CODE);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void validateToken(HttpServletRequest request) throws RegistrationException {
        Object token = request.getSession(true).getAttribute("onboardingRegisterToken");
        String tokenSent = request.getParameter("onboardingRegisterToken");
        if (!StringUtils.equals((CharSequence)String.valueOf(token), (CharSequence)tokenSent)) {
            throw new RegistrationException(REGISTRATION_ERROR_CODE);
        }
        request.getSession(true).removeAttribute("onboardingRegisterToken");
    }

    private boolean sendOnboardingEmail(User user, HttpServletRequest request) {
        PasswordRecoveryService passwordRecoveryService = (PasswordRecoveryService)ExoContainerContext.getService(PasswordRecoveryService.class);
        StringBuilder url = this.getUrl(request);
        Locale locale = request.getLocale();
        return passwordRecoveryService.sendOnboardingEmail(user, locale, url);
    }

    private void validateEmail(String email, Locale locale) throws Exception {
        if (StringUtils.isBlank((CharSequence)email)) {
            throw new RegistrationException("EMAIL_MANDATORY");
        }
        String errorCode = EMAIL_VALIDATOR.validate(locale, email);
        if (StringUtils.isNotBlank((CharSequence)errorCode)) {
            throw new RegistrationException(errorCode);
        }
        OrganizationService organizationService = (OrganizationService)ExoContainerContext.getService(OrganizationService.class);
        int usersLength = 0;
        try {
            Query query = new Query();
            query.setEmail(email);
            ListAccess users = organizationService.getUserHandler().findUsersByQuery(query, UserStatus.ANY);
            usersLength = users == null ? 0 : users.getSize();
        }
        catch (RuntimeException e) {
            LOG.debug("Error retrieving users list with email {}. Thus, we will consider the email as already used", new Object[]{email, e});
            usersLength = 1;
        }
        if (usersLength > 0) {
            throw new RegistrationException("EMAIL_ALREADY_EXISTS");
        }
        User user = organizationService.getUserHandler().findUserByName(email);
        if (user != null) {
            throw new RegistrationException("USER_ALREADY_EXISTS");
        }
    }

    public User registerUser(String email) throws RegistrationException {
        OrganizationService organizationService = (OrganizationService)ExoContainerContext.getService(OrganizationService.class);
        SecureRandomService secureRandomService = (SecureRandomService)ExoContainerContext.getService(SecureRandomService.class);
        UserHandler userHandler = organizationService.getUserHandler();
        User user = userHandler.createUserInstance(email);
        try {
            user.setEmail(email);
            user.setFirstName(email);
            user.setLastName("");
            SecureRandom secureRandom = secureRandomService.getSecureRandom();
            user.setPassword(secureRandom.nextLong() + "-" + secureRandom.nextLong() + "-" + secureRandom.nextLong());
            userHandler.createUser(user, true);
            return user;
        }
        catch (RegistrationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn((Object)"Error regitering user", (Throwable)e);
            throw new RegistrationException(REGISTRATION_ERROR_CODE);
        }
    }

    private StringBuilder getUrl(HttpServletRequest request) {
        StringBuilder url = new StringBuilder();
        if (request != null) {
            url.append(request.getScheme()).append("://").append(request.getServerName());
            if (request.getServerPort() != 80 && request.getServerPort() != 443) {
                url.append(':').append(request.getServerPort());
            }
            url.append("/" + PortalContainer.getCurrentPortalContainerName());
        }
        return url;
    }
}

