/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.deparser;

import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.DeclareStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.DeclareStatement$TypeDefExpr;
import liquibase.repackaged.net.sf.jsqlparser.statement.DeclareType;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class DeclareStatementDeParser
extends AbstractDeParser<DeclareStatement> {
    private ExpressionVisitor expressionVisitor;

    public DeclareStatementDeParser(ExpressionVisitor expressionVisitor, StringBuilder stringBuilder) {
        super(stringBuilder);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(DeclareStatement declareStatement) {
        this.buffer.append("DECLARE ");
        if (declareStatement.getUserVariable() != null) {
            declareStatement.getUserVariable().accept(this.expressionVisitor);
        }
        if (declareStatement.getType() == DeclareType.AS) {
            this.buffer.append(" AS ");
            this.buffer.append(declareStatement.getTypeName());
            return;
        }
        if (declareStatement.getType() == DeclareType.TABLE) {
            this.buffer.append(" TABLE (");
            for (int i2 = 0; i2 < declareStatement.getColumnDefinitions().size(); ++i2) {
                if (i2 > 0) {
                    this.buffer.append(", ");
                }
                this.buffer.append(declareStatement.getColumnDefinitions().get(i2).toString());
            }
            this.buffer.append(")");
            return;
        }
        if (declareStatement.getTypeDefinitions() != null) {
            for (int i3 = 0; i3 < declareStatement.getTypeDefinitions().size(); ++i3) {
                if (i3 > 0) {
                    this.buffer.append(", ");
                }
                DeclareStatement$TypeDefExpr declareStatement$TypeDefExpr = declareStatement.getTypeDefinitions().get(i3);
                if (declareStatement$TypeDefExpr.userVariable != null) {
                    declareStatement$TypeDefExpr.userVariable.accept(this.expressionVisitor);
                    this.buffer.append(" ");
                }
                this.buffer.append(declareStatement$TypeDefExpr.colDataType.toString());
                if (declareStatement$TypeDefExpr.defaultExpr == null) continue;
                this.buffer.append(" = ");
                declareStatement$TypeDefExpr.defaultExpr.accept(this.expressionVisitor);
            }
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }
}

