/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import liquibase.Scope;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.resource.AbstractResourceAccessor;
import liquibase.resource.InputStreamList;
import liquibase.util.StreamUtil;

public class ClassLoaderResourceAccessor
extends AbstractResourceAccessor {
    private ClassLoader classLoader;
    protected List<FileSystem> rootPaths;
    protected SortedSet<String> description;

    public ClassLoaderResourceAccessor() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ClassLoaderResourceAccessor(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected void init() {
        if (this.rootPaths == null) {
            this.rootPaths = new ArrayList<FileSystem>();
            this.description = new TreeSet<String>();
            this.loadRootPaths(this.classLoader);
        }
    }

    protected void loadRootPaths(ClassLoader classLoader) {
        ClassLoader parent;
        URL[] urls;
        if (classLoader instanceof URLClassLoader && (urls = ((URLClassLoader)classLoader).getURLs()) != null) {
            for (URL url : urls) {
                try {
                    this.addDescription(url);
                    this.rootPaths.add(FileSystems.newFileSystem(Paths.get(url.toURI()), this.getClass().getClassLoader()));
                }
                catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
                }
                catch (ProviderNotFoundException e2) {
                    if (url.toExternalForm().startsWith("file:/")) continue;
                    Scope.getCurrentScope().getLog(this.getClass()).info("No filesystem provider for URL " + url.toExternalForm() + ". Will rely on classloader logic for listing files.");
                }
                catch (FileSystemNotFoundException fsnfe) {
                    if (url.toExternalForm().matches(".*!.*!.*")) continue;
                    Scope.getCurrentScope().getLog(this.getClass()).info("Configured classpath location " + url.toString() + " does not exist");
                }
                catch (Throwable e3) {
                    Scope.getCurrentScope().getLog(this.getClass()).warning("Cannot create filesystem for url " + url.toExternalForm() + ": " + e3.getMessage(), e3);
                }
            }
        }
        if ((parent = classLoader.getParent()) != null) {
            this.loadRootPaths(parent);
        }
    }

    private void addDescription(URL url) {
        try {
            this.description.add(Paths.get(url.toURI()).toString());
        }
        catch (Throwable e2) {
            this.description.add(url.toExternalForm());
        }
    }

    @Override
    public InputStreamList openStreams(String relativeTo, String streamPath) throws IOException {
        this.init();
        InputStreamList returnList = new InputStreamList();
        streamPath = this.getFinalPath(relativeTo, streamPath);
        HashSet<String> seenUrls = new HashSet<String>();
        Enumeration<URL> resources = this.classLoader.getResources(streamPath);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (!seenUrls.add(url.toExternalForm())) continue;
            try {
                returnList.add(url.toURI(), url.openStream());
            }
            catch (URISyntaxException e2) {
                Scope.getCurrentScope().getLog(this.getClass()).severe(e2.getMessage(), e2);
            }
        }
        return returnList;
    }

    protected String getFinalPath(String relativeTo, String streamPath) {
        streamPath = streamPath.replace("\\", "/");
        streamPath = streamPath.replaceFirst("^classpath\\*?:", "");
        if (relativeTo != null) {
            String lastPortion;
            relativeTo = relativeTo.replace("\\", "/");
            relativeTo = relativeTo.replaceFirst("^classpath\\*?:", "");
            if (!(relativeTo = relativeTo.replaceAll("//+", "/")).contains("/") && relativeTo.contains(".")) {
                relativeTo = "/";
            }
            if (!relativeTo.endsWith("/") && (lastPortion = relativeTo.replaceFirst(".+/", "")).contains(".")) {
                relativeTo = relativeTo.replaceFirst("/[^/]+?$", "");
            }
            streamPath = relativeTo + "/" + streamPath;
        }
        streamPath = streamPath.replaceAll("//+", "/");
        streamPath = streamPath.replaceFirst("^/", "");
        return DatabaseChangeLog.normalizePath(streamPath);
    }

    @Override
    public SortedSet<String> list(String relativeTo, String path, boolean recursive, boolean includeFiles, boolean includeDirectories) throws IOException {
        this.init();
        String finalPath = this.getFinalPath(relativeTo, path);
        SortedSet<String> returnList = this.listFromClassLoader(finalPath, recursive, includeFiles, includeDirectories);
        returnList.addAll(this.listFromRootPaths(finalPath, recursive, includeFiles, includeDirectories));
        return returnList;
    }

    protected SortedSet<String> listFromRootPaths(final String path, boolean recursive, final boolean includeFiles, final boolean includeDirectories) {
        final TreeSet<String> returnSet = new TreeSet<String>();
        SimpleFileVisitor<Path> fileVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (includeFiles && attrs.isRegularFile()) {
                    this.addToReturnList(file);
                }
                if (includeDirectories && attrs.isDirectory()) {
                    this.addToReturnList(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (includeDirectories) {
                    this.addToReturnList(dir);
                }
                return FileVisitResult.CONTINUE;
            }

            protected void addToReturnList(Path file) {
                if (!file.toString().equals(path)) {
                    returnSet.add(file.toString().replaceFirst("^/", "").replaceFirst("/$", "").replaceAll("//+", "/"));
                }
            }
        };
        for (FileSystem fileSystem : this.rootPaths) {
            int maxDepth = recursive ? Integer.MAX_VALUE : 1;
            try {
                Files.walkFileTree(fileSystem.getPath(path, new String[0]), Collections.singleton(FileVisitOption.FOLLOW_LINKS), maxDepth, (FileVisitor<? super Path>)fileVisitor);
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (IOException e2) {
                Scope.getCurrentScope().getLog(this.getClass()).warning("Cannot walk filesystem: " + e2.getMessage(), e2);
            }
        }
        return returnSet;
    }

    protected SortedSet<String> listFromClassLoader(String path, boolean recursive, boolean includeFiles, boolean includeDirectories) {
        Enumeration<URL> resources;
        TreeSet<String> returnSet = new TreeSet<String>();
        try {
            resources = this.classLoader.getResources(path);
        }
        catch (IOException e2) {
            Scope.getCurrentScope().getLog(this.getClass()).severe("Cannot list resources in path " + path + ": " + e2.getMessage(), e2);
            return returnSet;
        }
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            String urlExternalForm = url.toExternalForm();
            try {
                if (urlExternalForm.startsWith("jar:file:") && urlExternalForm.contains("!")) {
                    String jarPath = url.getPath();
                    jarPath = jarPath.substring(5, jarPath.indexOf("!"));
                    JarFile jar = new JarFile(URLDecoder.decode(jarPath, StandardCharsets.UTF_8.name()));
                    Object object = null;
                    try {
                        String comparePath = path;
                        if (comparePath.startsWith("/")) {
                            comparePath = "/" + comparePath;
                        }
                        Enumeration<JarEntry> entries = jar.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            String name = entry.getName();
                            if (!name.startsWith(comparePath) || comparePath.equals(name)) continue;
                            if (entry.isDirectory()) {
                                if (!includeDirectories || !recursive && name.substring(comparePath.length()).contains("/")) continue;
                                returnSet.add(name);
                                continue;
                            }
                            if (!includeFiles || !recursive && name.substring(comparePath.length()).contains("/")) continue;
                            returnSet.add(name);
                        }
                        continue;
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (jar == null) continue;
                        if (object != null) {
                            try {
                                jar.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            continue;
                        }
                        jar.close();
                        continue;
                    }
                }
                InputStream inputStream = url.openStream();
                String fileList = StreamUtil.readStreamAsString(inputStream);
                if (fileList.isEmpty()) continue;
                for (String childName : fileList.split("\n")) {
                    String childPath = (path + "/" + childName).replaceAll("//+", "/");
                    if (this.isDirectory(childPath)) {
                        if (includeDirectories) {
                            returnSet.add(childPath);
                        }
                        if (!recursive) continue;
                        returnSet.addAll(this.listFromClassLoader(childPath, recursive, includeFiles, includeDirectories));
                        continue;
                    }
                    if (!includeFiles) continue;
                    returnSet.add(childPath);
                }
            }
            catch (IOException e3) {
                Scope.getCurrentScope().getLog(this.getClass()).severe("Cannot list resources in " + urlExternalForm + ": " + e3.getMessage(), e3);
            }
        }
        return returnSet;
    }

    protected boolean isDirectory(String path) {
        try {
            Enumeration<URL> resources = this.classLoader.getResources(path);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                File file = new File(url.toURI());
                if (!file.exists() || !file.isDirectory()) continue;
                return true;
            }
        }
        catch (Exception resources) {
            // empty catch block
        }
        String lastPortion = path.replaceFirst(".*/", "");
        return !lastPortion.contains(".");
    }

    @Override
    public SortedSet<String> describeLocations() {
        this.init();
        return this.description;
    }
}

