/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.aspects;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.ServerContext;
import org.gatein.pc.portlet.PortletInvokerInterceptor;
import org.gatein.pc.portlet.container.PortletApplication;
import org.gatein.pc.portlet.container.PortletContainer;

public class ContextDispatcherInterceptor
extends PortletInvokerInterceptor {
    public static final String REQ_ATT_COMPONENT_INVOCATION = "org.jboss.portal.attribute.component_invocation";

    @Override
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        PortletContainer container = (PortletContainer)invocation.getAttribute("PORTLET_CONTAINER");
        PortletApplication portletApplication = container.getPortletApplication();
        ServerContext reqCtx = invocation.getServerContext();
        ServletContext targetCtx = portletApplication.getContext().getServletContext();
        try {
            CallableImpl callable = new CallableImpl(invocation);
            reqCtx.dispatch(targetCtx, invocation.getRequest(), invocation.getResponse(), (ServerContext.Callable)callable);
            return callable.response;
        }
        catch (Exception e) {
            ServletException se;
            if (e instanceof PortletInvokerException) {
                throw (PortletInvokerException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof ServletException && (se = (ServletException)e).getRootCause() != null && se.getRootCause() instanceof Exception) {
                e = (Exception)se.getRootCause();
            }
            throw new PortletInvokerException((Throwable)e);
        }
    }

    private class CallableImpl
    implements ServerContext.Callable {
        private final PortletInvocation invocation;
        private PortletInvocationResponse response;

        private CallableImpl(PortletInvocation invocation) {
            this.invocation = invocation;
        }

        public void call(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            HttpServletRequest oldReq = this.invocation.getRequest();
            HttpServletResponse oldResp = this.invocation.getResponse();
            try {
                this.invocation.setRequest(req);
                this.invocation.setResponse(resp);
                req.setAttribute(ContextDispatcherInterceptor.REQ_ATT_COMPONENT_INVOCATION, (Object)this.invocation);
                this.response = ContextDispatcherInterceptor.super.invoke(this.invocation);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            finally {
                req.setAttribute(ContextDispatcherInterceptor.REQ_ATT_COMPONENT_INVOCATION, null);
                this.invocation.setRequest(oldReq);
                this.invocation.setResponse(oldResp);
            }
        }
    }
}

