/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.branding;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.core.ThreadUnsafeLessCompiler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.portal.branding.Branding;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.branding.Logo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.picocontainer.Startable;

public class BrandingServiceImpl
implements BrandingService,
Startable {
    private static final Log LOG = ExoLogger.getExoLogger(BrandingServiceImpl.class);
    public static final String BRANDING_COMPANY_NAME_INIT_PARAM = "exo.branding.company.name";
    public static final String BRANDING_SITE_NAME_INIT_PARAM = "exo.branding.company.siteName";
    public static final String BRANDING_COMPANY_LINK_INIT_PARAM = "exo.branding.company.link";
    public static final String BRANDING_LOGO_INIT_PARAM = "exo.branding.company.logo";
    public static final String BRANDING_COMPANY_NAME_SETTING_KEY = "exo.branding.company.name";
    public static final String BRANDING_SITE_NAME_SETTING_KEY = "exo.branding.company.siteName";
    public static final String BRANDING_COMPANY_LINK_SETTING_KEY = "exo.branding.company.link";
    public static final String BRANDING_THEME_LESS_PATH = "exo.branding.theme.path";
    public static final String BRANDING_THEME_VARIABLES = "exo.branding.theme.variables";
    public static final String BRANDING_TOPBAR_THEME_SETTING_KEY = "bar_navigation_style";
    public static final String BRANDING_LOGO_ID_SETTING_KEY = "exo.branding.company.id";
    public static final String BRANDING_LAST_UPDATED_TIME_KEY = "branding.lastUpdatedTime";
    public static final String FILE_API_NAME_SPACE = "CompanyBranding";
    public static final String LOGO_NAME = "logo.png";
    public static final String BRANDING_DEFAULT_LOGO_PATH = "/images/logo/DefaultLogo.png";
    public static final Context BRANDING_CONTEXT = Context.GLOBAL.id("BRANDING");
    public static final Scope BRANDING_SCOPE = Scope.APPLICATION.id("BRANDING");
    public static final long DEFAULT_LAST_MODIFED = System.currentTimeMillis();
    private SettingService settingService;
    private FileService fileService;
    private UploadService uploadService;
    private ConfigurationManager configurationManager;
    private String defaultCompanyName = "";
    private String defaultSiteName = "";
    private String defaultCompanyLink = "";
    private String defaultTopbarTheme = "Dark";
    private String defaultConfiguredLogoPath = null;
    private String lessFilePath = null;
    private Map<String, String> themeVariables = null;
    private String lessThemeContent = null;
    private String themeCSSContent = null;
    private Logo logo = null;

    public BrandingServiceImpl(ConfigurationManager configurationManager, SettingService settingService, FileService fileService, UploadService uploadService, InitParams initParams) {
        this.configurationManager = configurationManager;
        this.settingService = settingService;
        this.fileService = fileService;
        this.uploadService = uploadService;
        this.loadInitParams(initParams);
    }

    public void start() {
        this.computeThemeCSS();
    }

    public void stop() {
    }

    @Override
    public String getThemeCSSContent() {
        return this.themeCSSContent;
    }

    @Override
    public Branding getBrandingInformation() {
        Branding branding = new Branding();
        branding.setCompanyName(this.getCompanyName());
        branding.setCompanyLink(this.getCompanyLink());
        branding.setSiteName(this.getSiteName());
        branding.setTopBarTheme(this.getTopBarTheme());
        branding.setLogo(this.getLogo());
        branding.setThemeColors(this.getThemeColors());
        branding.setLastUpdatedTime(this.getLastUpdatedTime());
        return branding;
    }

    @Override
    public long getLastUpdatedTime() {
        SettingValue lastUpdatedTime = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, BRANDING_LAST_UPDATED_TIME_KEY);
        if (lastUpdatedTime == null || lastUpdatedTime.getValue() == null) {
            return DEFAULT_LAST_MODIFED;
        }
        return Long.parseLong(lastUpdatedTime.getValue().toString());
    }

    @Override
    public void updateBrandingInformation(Branding branding) {
        try {
            this.updateCompanyName(branding.getCompanyName(), false);
            this.updateSiteName(branding.getSiteName(), false);
            this.updateCompanyLink(branding.getCompanyLink(), false);
            this.updateTopBarTheme(branding.getTopBarTheme(), false);
            this.updateLogo(branding.getLogo(), false);
            this.updateThemeColors(branding.getThemeColors(), false);
        }
        finally {
            this.updateLastUpdatedTime(System.currentTimeMillis());
        }
    }

    @Override
    public String getCompanyName() {
        SettingValue brandingCompanyName = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.name");
        if (brandingCompanyName != null && StringUtils.isNotBlank((CharSequence)((CharSequence)brandingCompanyName.getValue()))) {
            return (String)brandingCompanyName.getValue();
        }
        return this.defaultCompanyName;
    }

    @Override
    public String getCompanyLink() {
        SettingValue brandingCompanyLink = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.link");
        if (brandingCompanyLink != null && StringUtils.isNotBlank((CharSequence)((CharSequence)brandingCompanyLink.getValue()))) {
            return (String)brandingCompanyLink.getValue();
        }
        return this.defaultCompanyLink;
    }

    @Override
    public String getSiteName() {
        SettingValue brandingSiteName = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.siteName");
        if (brandingSiteName != null && StringUtils.isNotBlank((CharSequence)((CharSequence)brandingSiteName.getValue()))) {
            return (String)brandingSiteName.getValue();
        }
        return this.defaultSiteName;
    }

    @Override
    public void updateCompanyName(String companyName) {
        this.updateCompanyName(companyName, true);
    }

    @Override
    public void updateCompanyLink(String companyLink) {
        this.updateCompanyLink(companyLink, true);
    }

    @Override
    public void updateSiteName(String siteName) {
        this.updateSiteName(siteName, true);
    }

    @Override
    public String getTopBarTheme() {
        SettingValue topBarTheme = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, BRANDING_TOPBAR_THEME_SETTING_KEY);
        if (topBarTheme != null && StringUtils.isNotBlank((CharSequence)((CharSequence)topBarTheme.getValue()))) {
            return (String)topBarTheme.getValue();
        }
        return this.defaultTopbarTheme;
    }

    @Override
    public Long getLogoId() {
        SettingValue logoId = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, BRANDING_LOGO_ID_SETTING_KEY);
        if (logoId != null && logoId.getValue() != null) {
            return Long.parseLong((String)logoId.getValue());
        }
        return null;
    }

    @Override
    public Logo getLogo() {
        Long imageId;
        if (this.logo == null && (imageId = this.getLogoId()) != null) {
            try {
                FileItem fileItem = this.fileService.getFile(imageId.longValue());
                if (fileItem != null) {
                    Logo storedLogo = new Logo();
                    storedLogo.setData(fileItem.getAsByte());
                    storedLogo.setSize(fileItem.getFileInfo().getSize());
                    storedLogo.setUpdatedDate(fileItem.getFileInfo().getUpdatedDate().getTime());
                    this.logo = storedLogo;
                    return this.logo;
                }
            }
            catch (FileStorageException e) {
                LOG.error((Object)"Error while retrieving branding logo", (Throwable)e);
            }
        }
        return this.getDefaultLogo();
    }

    @Override
    public Logo getDefaultLogo() {
        if (this.logo == null || this.logo.getData() == null) {
            String logoPath = this.defaultConfiguredLogoPath;
            if (StringUtils.isBlank((CharSequence)logoPath)) {
                logoPath = BRANDING_DEFAULT_LOGO_PATH;
            }
            try {
                File file = new File(logoPath);
                if (file.exists()) {
                    this.logo = new Logo(null, Files.readAllBytes(file.toPath()), file.length(), file.lastModified());
                } else {
                    InputStream is = PortalContainer.getInstance().getPortalContext().getResourceAsStream(logoPath);
                    if (is != null) {
                        byte[] streamContentAsBytes = IOUtil.getStreamContentAsBytes((InputStream)is);
                        this.logo = new Logo(null, streamContentAsBytes, streamContentAsBytes.length, DEFAULT_LAST_MODIFED);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("The file of the default configured logo cannot be retrieved (" + logoPath + ")"), (Throwable)e);
            }
        }
        return this.logo;
    }

    @Override
    public void updateTopBarTheme(String topBarTheme) {
        this.updateTopBarTheme(topBarTheme, true);
    }

    @Override
    public void updateLastUpdatedTime(long lastUpdatedTimestamp) {
        if (lastUpdatedTimestamp <= 0L) {
            this.settingService.remove(Context.GLOBAL, Scope.GLOBAL, BRANDING_LAST_UPDATED_TIME_KEY);
        } else {
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL, BRANDING_LAST_UPDATED_TIME_KEY, SettingValue.create((Long)lastUpdatedTimestamp));
        }
    }

    @Override
    public void updateLogo(Logo logo) {
        this.updateLogo(logo, true);
    }

    @Override
    public void updateThemeColors(Map<String, String> themeColors) {
        this.updateThemeColors(themeColors, true);
    }

    @Override
    public Map<String, String> getThemeColors() {
        if (this.themeVariables == null || this.themeVariables.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> themeColors = new HashMap<String, String>();
        Set<String> variables = this.themeVariables.keySet();
        for (String themeVariable : variables) {
            SettingValue storedColorValue = this.settingService.get(BRANDING_CONTEXT, BRANDING_SCOPE, themeVariable);
            String colorValue = storedColorValue == null || storedColorValue.getValue() == null ? this.themeVariables.get(themeVariable) : storedColorValue.getValue().toString();
            if (!StringUtils.isNotBlank((CharSequence)colorValue)) continue;
            themeColors.put(themeVariable, colorValue);
        }
        return themeColors;
    }

    private void loadInitParams(InitParams initParams) {
        if (initParams != null) {
            ValuesParam lessVariablesParam;
            ValueParam lessFileParam;
            ValueParam logoParam;
            ValueParam siteNameParam;
            ValueParam companyLinkParam;
            ValueParam companyNameParam = initParams.getValueParam("exo.branding.company.name");
            if (companyNameParam != null) {
                this.defaultCompanyName = companyNameParam.getValue();
            }
            if ((companyLinkParam = initParams.getValueParam("exo.branding.company.link")) != null) {
                this.defaultCompanyLink = companyLinkParam.getValue();
            }
            if ((siteNameParam = initParams.getValueParam("exo.branding.company.siteName")) != null) {
                this.defaultSiteName = siteNameParam.getValue();
            }
            if ((logoParam = initParams.getValueParam(BRANDING_LOGO_INIT_PARAM)) != null) {
                this.defaultConfiguredLogoPath = logoParam.getValue();
            }
            if ((lessFileParam = initParams.getValueParam(BRANDING_THEME_LESS_PATH)) != null) {
                this.lessFilePath = lessFileParam.getValue();
            }
            if ((lessVariablesParam = initParams.getValuesParam(BRANDING_THEME_VARIABLES)) != null) {
                List variables = lessVariablesParam.getValues();
                this.themeVariables = new HashMap<String, String>();
                for (String themeVariable : variables) {
                    if (StringUtils.isBlank((CharSequence)themeVariable) || !themeVariable.contains(":")) continue;
                    String[] themeVariablesPart = themeVariable.split(":");
                    this.themeVariables.put(themeVariablesPart[0], themeVariablesPart[1]);
                }
            }
        }
    }

    private void updateTopBarTheme(String topBarTheme, boolean updateLastUpdatedTime) {
        if (StringUtils.isBlank((CharSequence)topBarTheme)) {
            this.settingService.remove(Context.GLOBAL, Scope.GLOBAL, BRANDING_TOPBAR_THEME_SETTING_KEY);
        } else {
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL, BRANDING_TOPBAR_THEME_SETTING_KEY, SettingValue.create((String)topBarTheme));
        }
        if (updateLastUpdatedTime) {
            this.updateLastUpdatedTime(System.currentTimeMillis());
        }
    }

    private void updateCompanyLink(String companyLink, boolean updateLastUpdatedTime) {
        if (StringUtils.isEmpty((CharSequence)companyLink)) {
            this.settingService.remove(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.link");
        } else {
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.link", SettingValue.create((String)companyLink));
        }
        if (updateLastUpdatedTime) {
            this.updateLastUpdatedTime(System.currentTimeMillis());
        }
    }

    private void updateSiteName(String siteName, boolean updateLastUpdatedTime) {
        if (StringUtils.isEmpty((CharSequence)siteName)) {
            this.settingService.remove(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.siteName");
        } else {
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.siteName", SettingValue.create((String)siteName));
        }
        if (updateLastUpdatedTime) {
            this.updateLastUpdatedTime(System.currentTimeMillis());
        }
    }

    private void updateCompanyName(String companyName, boolean updateLastUpdatedTime) {
        if (StringUtils.isEmpty((CharSequence)companyName)) {
            this.settingService.remove(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.name");
        } else {
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.name", SettingValue.create((String)companyName));
        }
        if (updateLastUpdatedTime) {
            this.updateLastUpdatedTime(System.currentTimeMillis());
        }
    }

    private void updateThemeColors(Map<String, String> themeColors, boolean updateLastUpdatedTime) {
        if (this.themeVariables == null || this.themeVariables.isEmpty()) {
            return;
        }
        Set<String> variables = this.themeVariables.keySet();
        for (String themeVariable : variables) {
            if (themeColors != null && themeColors.get(themeVariable) != null) {
                String themeColor = themeColors.get(themeVariable);
                this.settingService.set(BRANDING_CONTEXT, BRANDING_SCOPE, themeVariable, SettingValue.create((String)themeColor));
                continue;
            }
            this.settingService.remove(BRANDING_CONTEXT, BRANDING_SCOPE, themeVariable);
        }
        this.computeThemeCSS();
        if (updateLastUpdatedTime) {
            this.updateLastUpdatedTime(System.currentTimeMillis());
        }
    }

    private void updateLogo(Logo logo, boolean updateLastUpdatedTime) {
        this.logo = null;
        if (logo == null || (logo.getData() == null || logo.getData().length <= 0) && StringUtils.isBlank((CharSequence)logo.getUploadId())) {
            Long logoId = this.getLogoId();
            if (logoId != null) {
                this.fileService.deleteFile(logoId.longValue());
                this.settingService.remove(Context.GLOBAL, Scope.GLOBAL, BRANDING_LOGO_ID_SETTING_KEY);
            }
        } else {
            try {
                InputStream inputStream;
                if (logo.getData() != null && logo.getData().length > 0) {
                    inputStream = new ByteArrayInputStream(logo.getData());
                } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{logo.getUploadId()})) {
                    inputStream = this.getUploadDataAsStream(logo.getUploadId());
                } else {
                    throw new IllegalArgumentException("Cannot update branding logo, the logo object must contain the image data or an upload id");
                }
                String currentUserId = this.getCurrentUserId();
                Long logoId = this.getLogoId();
                if (logoId == null) {
                    FileItem fileItem = new FileItem(null, LOGO_NAME, "image/png", FILE_API_NAME_SPACE, logo.getSize(), new Date(), currentUserId, false, inputStream);
                    fileItem = this.fileService.writeFile(fileItem);
                    this.settingService.set(Context.GLOBAL, Scope.GLOBAL, BRANDING_LOGO_ID_SETTING_KEY, SettingValue.create((String)String.valueOf(fileItem.getFileInfo().getId())));
                } else {
                    FileItem fileItem = new FileItem(logoId, LOGO_NAME, "image/png", FILE_API_NAME_SPACE, logo.getSize(), new Date(), currentUserId, false, inputStream);
                    this.fileService.updateFile(fileItem);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Error while updating logo", e);
            }
        }
        if (updateLastUpdatedTime) {
            this.updateLastUpdatedTime(System.currentTimeMillis());
        }
    }

    private String computeThemeCSS() {
        if (StringUtils.isNotBlank((CharSequence)this.lessFilePath)) {
            try {
                InputStream inputStream = this.configurationManager.getInputStream(this.lessFilePath);
                this.lessThemeContent = IOUtil.getStreamContentAsString((InputStream)inputStream);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error retrieving less file content", (Throwable)e);
            }
        }
        if (this.themeVariables != null && !this.themeVariables.isEmpty()) {
            Set<String> variables = this.themeVariables.keySet();
            for (String themeVariable : variables) {
                SettingValue storedColorValue = this.settingService.get(BRANDING_CONTEXT, BRANDING_SCOPE, themeVariable);
                String colorValue = storedColorValue == null || storedColorValue.getValue() == null ? this.themeVariables.get(themeVariable) : storedColorValue.getValue().toString();
                if (!StringUtils.isNotBlank((CharSequence)colorValue) || !StringUtils.isNotBlank((CharSequence)this.lessThemeContent)) continue;
                this.lessThemeContent = this.lessThemeContent.replaceAll("@" + themeVariable + ":[ #a-zA-Z0-9]*;?\r?\n", "@" + themeVariable + ": " + colorValue + ";\n");
            }
            if (StringUtils.isNotBlank((CharSequence)this.lessThemeContent)) {
                ThreadUnsafeLessCompiler compiler = new ThreadUnsafeLessCompiler();
                try {
                    LessCompiler.Configuration configuration = new LessCompiler.Configuration();
                    configuration.setLinkSourceMap(false);
                    LessCompiler.CompilationResult result = compiler.compile(this.lessThemeContent, configuration);
                    this.themeCSSContent = result.getCss();
                }
                catch (Less4jException e) {
                    LOG.warn((Object)"Error compiling less file content", (Throwable)e);
                }
            }
        }
        return this.themeCSSContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getUploadDataAsStream(String uploadId) throws FileNotFoundException {
        UploadResource uploadResource = this.uploadService.getUploadResource(uploadId);
        if (uploadResource == null) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(uploadResource.getStoreLocation()));
            return fileInputStream;
        }
        finally {
            this.uploadService.removeUploadResource(uploadId);
        }
    }

    private String getCurrentUserId() {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null && conversationState.getIdentity() != null) {
            return conversationState.getIdentity().getUserId();
        }
        return null;
    }
}

