/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import java.nio.channels.Channel;
import java.nio.channels.SeekableByteChannel;
import org.apache.sis.internal.storage.io.Markable;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

public abstract class ChannelData
implements Markable {
    private static final int BIT_OFFSET_SIZE = 3;
    public final String filename;
    public final ByteBuffer buffer;
    public final long channelOffset;
    long bufferOffset;
    private long bitPosition;
    private Mark mark;

    ChannelData(String string, Channel channel, ByteBuffer byteBuffer) throws IOException {
        this.filename = string;
        this.buffer = byteBuffer;
        this.channelOffset = channel instanceof SeekableByteChannel ? ((SeekableByteChannel)channel).position() : 0L;
    }

    public final int getBitOffset() {
        long l = this.bufferOffset + (long)this.buffer.position();
        if (this.bitPosition >>> 3 != l) {
            this.bitPosition = l << 3;
        }
        return (int)(this.bitPosition & 7L);
    }

    public final void setBitOffset(int n) {
        ArgumentChecks.ensureBetween((String)"bitOffset", (int)0, (int)7, (int)n);
        long l = this.bufferOffset + (long)this.buffer.position();
        this.bitPosition = l << 3 | (long)n;
    }

    final void clearBitOffset() {
        this.bitPosition = 0L;
    }

    @Override
    public long getStreamPosition() {
        return this.bufferOffset + (long)this.buffer.position();
    }

    public final void setStreamPosition(long l) {
        this.bufferOffset = l - (long)this.buffer.position();
        this.clearBitOffset();
        this.mark = null;
    }

    public final long getFlushedPosition() {
        return this.bufferOffset;
    }

    public final void flushBefore(long l) throws IOException {
        long l2 = this.getStreamPosition();
        if (l < this.bufferOffset || l > l2) {
            throw new IndexOutOfBoundsException(Errors.format((short)166, (Object)"position", (Object)this.bufferOffset, (Object)l2, (Object)l));
        }
        int n = (int)(l - this.bufferOffset);
        int n2 = this.buffer.position() - n;
        int n3 = this.buffer.limit() - n;
        this.flushAndSetPosition(n);
        this.buffer.compact().position(n2).limit(n3);
        Mark mark = null;
        Mark mark2 = this.mark;
        while (mark2 != null) {
            if (mark2.position >= l) {
                mark = mark2;
            }
            mark2 = mark2.next;
        }
        if (mark != null) {
            mark.next = null;
        } else {
            this.mark = null;
        }
    }

    void flushAndSetPosition(int n) throws IOException {
        this.buffer.position(n);
        this.bufferOffset += (long)n;
    }

    public abstract void seek(long var1) throws IOException;

    @Override
    public final void mark() {
        this.mark = new Mark(this.getStreamPosition(), (byte)this.getBitOffset(), this.mark);
    }

    @Override
    public final void reset() throws IOException {
        Mark mark = this.mark;
        if (mark == null) {
            throw new InvalidMarkException();
        }
        this.mark = mark.next;
        this.seek(mark.position);
        this.setBitOffset(mark.bitOffset);
    }

    protected void onEmptyTransfer() throws IOException {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getSimpleName()).append("[\u201c").append(this.filename).append('\u201d');
        if (this.buffer != null) {
            stringBuilder.append(" at ").append(this.getStreamPosition());
        }
        return stringBuilder.append(']').toString();
    }

    private static final class Mark {
        final long position;
        final byte bitOffset;
        Mark next;

        Mark(long l, byte by, Mark mark) {
            this.position = l;
            this.bitOffset = by;
            this.next = mark;
        }
    }
}

