/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.search;

import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.listener.PageWikiListener;

public class PageIndexingListener
extends PageWikiListener {
    private IndexingService indexingService;

    public PageIndexingListener(IndexingService indexingService) {
        this.indexingService = indexingService;
    }

    @Override
    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        this.indexingService.index("wiki-page", page.getId());
    }

    @Override
    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, PageUpdateType wikiUpdateType) throws WikiException {
        if (!page.isDraftPage()) {
            this.indexingService.reindex("wiki-page", page.getId());
        }
    }

    @Override
    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        this.indexingService.unindex("wiki-page", page.getId());
    }

    @Override
    public void postgetPagefromTree(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
    }

    @Override
    public void postgetPagefromBreadCrumb(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
    }
}

