/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.storedproc;

import com.datical.liquibase.ext.storedlogic.AbstractMissingStoredLogicChangeGenerator;
import liquibase.change.Change;
import liquibase.change.core.CreateProcedureChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.structure.core.StoredProcedure;

public class MissingStoredProcedureChangeGenerator
extends AbstractMissingStoredLogicChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (StoredProcedure.class.isAssignableFrom(clazz)) {
            return 101;
        }
        return -1;
    }

    @Override
    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database database, Database object, ChangeGeneratorChain object2) {
        object = (StoredProcedure)databaseObject;
        object2 = new CreateProcedureChange();
        ((CreateProcedureChange)object2).setProcedureText(((StoredDatabaseLogic)object).getBody());
        ((CreateProcedureChange)object2).setProcedureName(((StoredDatabaseLogic)object).getName());
        if (diffOutputControl.getIncludeCatalog()) {
            ((CreateProcedureChange)object2).setCatalogName(((StoredDatabaseLogic)object).getSchema().getCatalogName());
        }
        if (diffOutputControl.getIncludeSchema()) {
            ((CreateProcedureChange)object2).setSchemaName(((StoredDatabaseLogic)object).getSchema().getName());
        }
        if (database instanceof MSSQLDatabase && !((StoredDatabaseLogic)object).getBody().toUpperCase().contains("AS EXTERNAL NAME")) {
            ((CreateProcedureChange)object2).setReplaceIfExists(Boolean.TRUE);
        }
        return MissingStoredProcedureChangeGenerator.wrapWithQuotedIdentifier(databaseObject, database, new Change[]{object2});
    }
}

