/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.change;

import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.DropTriggerStatement;
import java.util.ArrayList;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.EnterpriseDBDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class DropTriggerGenerator
extends AbstractSqlGenerator<DropTriggerStatement> {
    @Override
    public boolean supports(DropTriggerStatement dropTriggerStatement, Database database) {
        return database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof AbstractDb2Database || database instanceof PostgresDatabase && !(database instanceof CockroachDatabase);
    }

    @Override
    public ValidationErrors validate(DropTriggerStatement dropTriggerStatement, Database database, SqlGeneratorChain object) {
        object = new ValidationErrors();
        ((ValidationErrors)object).checkDisallowedField("catalogName", dropTriggerStatement.getCatalogName(), database, MSSQLDatabase.class);
        ((ValidationErrors)object).checkRequiredField("triggerName", dropTriggerStatement.getTriggerName());
        if (dropTriggerStatement.getScope() != null) {
            if (database instanceof MSSQLDatabase && !dropTriggerStatement.getScope().equalsIgnoreCase("CATALOG") && dropTriggerStatement.getScope().equalsIgnoreCase("TABLE")) {
                ((ValidationErrors)object).addError("Invalid dropTrigger scope " + dropTriggerStatement.getScope() + ". Possible values: CATALOG, TABLE");
            }
            if (database instanceof PostgresDatabase) {
                if (!dropTriggerStatement.getScope().equalsIgnoreCase("CASCADE") && !dropTriggerStatement.getScope().equalsIgnoreCase("RESTRICT")) {
                    ((ValidationErrors)object).addError("Invalid dropTrigger scope " + dropTriggerStatement.getScope() + ". Possible values: CASCADE , RESTRICT ");
                }
                ((ValidationErrors)object).checkRequiredField("tableName", dropTriggerStatement.getTableName());
            }
        }
        return object;
    }

    @Override
    public Sql[] generateSql(DropTriggerStatement object, Database database, SqlGeneratorChain object2) {
        object2 = ";";
        ArrayList<UnparsedSql> arrayList = new ArrayList<UnparsedSql>();
        StringBuilder stringBuilder = new StringBuilder();
        String string = database.escapeObjectName(((DropTriggerStatement)object).getCatalogName(), ((DropTriggerStatement)object).getSchemaName(), ((DropTriggerStatement)object).getTriggerName(), Trigger.class);
        stringBuilder.append("DROP TRIGGER ");
        if (database instanceof MSSQLDatabase && ((DropTriggerStatement)object).getScope() != null && ((DropTriggerStatement)object).getScope().equalsIgnoreCase("CATALOG")) {
            string = database.escapeObjectName(((DropTriggerStatement)object).getTriggerName(), Trigger.class);
            string = String.format("%s ON DATABASE", string);
        }
        if (database instanceof PostgresDatabase) {
            string = this.generateSchemaSetSql((DropTriggerStatement)object, database);
            arrayList.add(new UnparsedSql(string, (String)object2, new DatabaseObject[0]));
            object2 = database.escapeObjectName(((DropTriggerStatement)object).getTriggerName(), Trigger.class);
            string = database.escapeObjectName(((DropTriggerStatement)object).getTableName(), Trigger.class);
            String string2 = database.escapeObjectName(((DropTriggerStatement)object).getSchemaName(), Trigger.class);
            if (string2 == null || string2.isEmpty()) {
                string2 = database.getDefaultSchemaName();
            }
            if ((object = database.escapeObjectName(((DropTriggerStatement)object).getScope(), Trigger.class)) == null) {
                object = "";
            }
            string = String.format("%s ON %s.%s %s", object2, string2, string, object);
        }
        stringBuilder.append(string);
        arrayList.add(new UnparsedSql(stringBuilder.toString(), new DatabaseObject[0]));
        return arrayList.toArray(new Sql[0]);
    }

    private String generateSchemaSetSql(DropTriggerStatement object, Database database) {
        if ((object = ((DropTriggerStatement)object).getSchemaName()) == null || ((String)object).isEmpty()) {
            object = database.getDefaultSchemaName();
        }
        if (database instanceof EnterpriseDBDatabase) {
            return String.format("ALTER SESSION SET SEARCH_PATH=%s\n", object);
        }
        return String.format("SET SEARCH_PATH=%s\n", object);
    }
}

