/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.setting;

import groovy.text.GStringTemplateEngine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationChildPlugin;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationPlugin;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.setting.PluginContainer;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.notification.template.ResourceBundleConfigDeployer;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.WebAppListener;
import org.picocontainer.Startable;

public class NotificationPluginContainer
implements PluginContainer,
Startable {
    private static final Log LOG = ExoLogger.getLogger(NotificationPluginContainer.class);
    private final Map<PluginKey, BaseNotificationPlugin> pluginMap = new HashMap<PluginKey, BaseNotificationPlugin>();
    private final Map<PluginKey, List<PluginKey>> parentChildrenKeysMap = new HashMap<PluginKey, List<PluginKey>>();
    private PluginSettingService pSettingService = CommonsUtils.getService(PluginSettingService.class);
    private ResourceBundleConfigDeployer deployer = new ResourceBundleConfigDeployer();
    private GStringTemplateEngine gTemplateEngine = new GStringTemplateEngine();

    public void start() {
        HashSet<String> datas = new HashSet<String>();
        for (BaseNotificationPlugin plugin : this.pluginMap.values()) {
            boolean isChild = plugin instanceof AbstractNotificationChildPlugin;
            for (PluginConfig pluginConfig : plugin.getPluginConfigs()) {
                this.pSettingService.registerPluginConfig(pluginConfig.isChildPlugin(isChild));
                if (StringUtils.isEmpty((String)pluginConfig.getBundlePath()) && !StringUtils.isEmpty((String)pluginConfig.getTemplateConfig().getBundlePath())) {
                    pluginConfig.setBundlePath(pluginConfig.getTemplateConfig().getBundlePath());
                }
                datas.add(pluginConfig.getBundlePath());
            }
        }
        if (ServletContainerFactory.getServletContainer().addWebAppListener((WebAppListener)this.deployer)) {
            this.deployer.initBundlePath(datas);
        }
    }

    public void stop() {
        ServletContainerFactory.getServletContainer().removeWebAppListener((WebAppListener)this.deployer);
    }

    public BaseNotificationPlugin getPlugin(PluginKey key) {
        return this.pluginMap.get(key);
    }

    public List<PluginKey> getChildPluginKeys(PluginKey parentKey) {
        List<PluginKey> keys = this.parentChildrenKeysMap.get(parentKey);
        if (keys != null) {
            return keys;
        }
        return new ArrayList<PluginKey>();
    }

    public void addChildPlugin(AbstractNotificationChildPlugin plugin) {
        this.registerChildPlugin(plugin);
        List parentIds = plugin.getParentPluginIds();
        for (String parentId : parentIds) {
            PluginKey parentKey = new PluginKey(parentId);
            List<PluginKey> childrenKeys = this.parentChildrenKeysMap.containsKey(parentKey) ? this.parentChildrenKeysMap.get(parentKey) : new ArrayList<PluginKey>();
            childrenKeys.add(plugin.getKey());
            this.parentChildrenKeysMap.put(parentKey, childrenKeys);
        }
        String templatePath = plugin.getTemplatePath();
        if (templatePath != null && templatePath.length() > 0) {
            try {
                String template = TemplateUtils.loadGroovyTemplate(templatePath);
                plugin.setTemplateEngine(this.gTemplateEngine.createTemplate(template));
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to build groovy template engine for: " + plugin.getId()), (Throwable)e);
            }
        }
    }

    public void addPlugin(BaseNotificationPlugin plugin) {
        if (plugin.isOldPlugin()) {
            this.registerPlugin((AbstractNotificationPlugin)plugin);
        }
        this.pluginMap.put(plugin.getKey(), plugin);
    }

    private void registerPlugin(AbstractNotificationPlugin plugin) {
        try {
            String templatePath = ((PluginConfig)plugin.getPluginConfigs().get(0)).getTemplateConfig().getTemplatePath();
            String template = TemplateUtils.loadGroovyTemplate(templatePath);
            plugin.setTemplateEngine(this.gTemplateEngine.createTemplate(template));
        }
        catch (Exception e) {
            LOG.debug((Object)("Failed to register notification plugin " + plugin.getId()), (Throwable)e);
        }
        this.pluginMap.put(plugin.getKey(), (BaseNotificationPlugin)plugin);
    }

    private void registerChildPlugin(AbstractNotificationChildPlugin plugin) {
        try {
            String templatePath = ((PluginConfig)plugin.getPluginConfigs().get(0)).getTemplateConfig().getTemplatePath();
            String template = TemplateUtils.loadGroovyTemplate(templatePath);
            plugin.setTemplateEngine(this.gTemplateEngine.createTemplate(template));
        }
        catch (Exception e) {
            LOG.debug((Object)("Failed to register notification plugin " + plugin.getId()), (Throwable)e);
        }
        this.pluginMap.put(plugin.getKey(), (BaseNotificationPlugin)plugin);
    }

    public boolean remove(PluginKey key) {
        this.pluginMap.remove(key);
        return true;
    }

    public List<String> getDefaultActivePlugins() {
        ArrayList<String> list = new ArrayList<String>();
        for (BaseNotificationPlugin plugin : this.pluginMap.values()) {
            if (plugin instanceof AbstractNotificationChildPlugin) continue;
            for (String defaultConf : ((PluginConfig)plugin.getPluginConfigs().get(0)).getDefaultConfig()) {
                if (UserSetting.FREQUENCY.getFrequecy((String)defaultConf) != UserSetting.FREQUENCY.INSTANTLY) continue;
                list.add(plugin.getId());
            }
        }
        return list;
    }
}

