/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.math.Line;
import org.apache.sis.math.Vector;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.operation.builder.LocalizationGridBuilder;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class SatelliteGroundTrack
extends AbstractMathTransform2D {
    private static final ParameterDescriptorGroup PARAMETERS;
    private final ContextualParameters context;
    private final double \u03bb0;
    private final double slope;
    private final MathTransform2D inverse;

    private SatelliteGroundTrack(LocalizationGridBuilder localizationGridBuilder, int n, int n2) throws TransformException {
        Vector vector;
        Vector vector2;
        int n3 = (int)localizationGridBuilder.getSourceEnvelope(false).getMedian(n2 ^ 1);
        if (n2 == 0) {
            vector2 = localizationGridBuilder.getRow(n, n3);
            vector = localizationGridBuilder.getRow(n ^ 1, n3);
        } else {
            vector2 = localizationGridBuilder.getColumn(n, n3);
            vector = localizationGridBuilder.getColumn(n ^ 1, n3);
        }
        Line line = new Line();
        line.fit(vector, vector2);
        this.\u03bb0 = line.y0();
        this.slope = Math.toRadians(line.slope());
        this.inverse = new Inverse();
        this.context = new ContextualParameters(PARAMETERS, 2, 2);
        MatrixSIS matrixSIS = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        matrixSIS.convertAfter(1, (Number)DoubleDouble.createDegreesToRadians(), null);
        this.setPositionParameter("central_meridian_start", line, vector.doubleValue(0));
        this.setPositionParameter("central_meridian_end", line, vector.doubleValue(vector.size() - 1));
    }

    private void setPositionParameter(String string, Line line, double d) {
        DirectPosition2D directPosition2D = new DirectPosition2D(d, line.y(d));
        this.context.parameter(string).setValue((Object)directPosition2D);
    }

    static MathTransform create(MathTransformFactory mathTransformFactory, LocalizationGridBuilder localizationGridBuilder, int n, int n2) throws TransformException, FactoryException {
        SatelliteGroundTrack satelliteGroundTrack = new SatelliteGroundTrack(localizationGridBuilder, n, n2);
        return satelliteGroundTrack.context.completeTransform(mathTransformFactory, (MathTransform)satelliteGroundTrack);
    }

    public ParameterValueGroup getParameterValues() {
        return this.context;
    }

    protected ContextualParameters getContextualParameters() {
        return this.context;
    }

    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = Math.cos(d2);
        double d4 = d2 * this.slope + this.\u03bb0;
        double d5 = d - d4;
        if (dArray2 != null) {
            dArray2[n2] = d5 * d3 + d4;
            dArray2[n2 + 1] = d2;
        }
        if (!bl) {
            return null;
        }
        Matrix2 matrix2 = new Matrix2();
        matrix2.m00 = d3;
        matrix2.m01 = this.slope * (1.0 - d3) - d5 * Math.sin(d2);
        return matrix2;
    }

    public MathTransform2D inverse() {
        return this.inverse;
    }

    static {
        ParameterBuilder parameterBuilder = new ParameterBuilder().setRequired(true);
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{((ParameterBuilder)parameterBuilder.addName((CharSequence)"central_meridian_start")).create(DirectPosition.class, null), ((ParameterBuilder)parameterBuilder.addName((CharSequence)"central_meridian_end")).create(DirectPosition.class, null)};
        PARAMETERS = ((ParameterBuilder)parameterBuilder.addName((CharSequence)"Satellite ground track")).createGroup((GeneralParameterDescriptor[])parameterDescriptorArray);
    }

    private final class Inverse
    extends AbstractMathTransform2D.Inverse {
        Inverse() {
        }

        public MathTransform2D inverse() {
            return SatelliteGroundTrack.this;
        }

        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.cos(d2);
            double d4 = d2 * SatelliteGroundTrack.this.slope + SatelliteGroundTrack.this.\u03bb0;
            double d5 = d - d4;
            if (dArray2 != null) {
                dArray2[n2] = d5 / d3 + d4;
                dArray2[n2 + 1] = d2;
            }
            if (!bl) {
                return null;
            }
            Matrix2 matrix2 = new Matrix2();
            matrix2.m00 = 1.0 / d3;
            matrix2.m01 = (d5 * Math.sin(d2) / d3 - SatelliteGroundTrack.this.slope) / d3 + SatelliteGroundTrack.this.slope;
            return matrix2;
        }
    }
}

