/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.coverage.SubspaceNotSpecifiedException;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridCoordinatesView;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.io.TableAppender;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.CodeList;
import org.opengis.util.FactoryException;

public class GridExtent
implements Serializable {
    private static final long serialVersionUID = -4717353677844056017L;
    private static final Map<AxisDirection, DimensionNameType> AXIS_DIRECTIONS;
    private static final DimensionNameType[] DEFAULT_TYPES;
    private static final WeakValueHashMap<DimensionNameType[], DimensionNameType[]> POOL;
    private final DimensionNameType[] types;
    private final long[] coordinates;

    private static long[] allocate(int n) throws IllegalArgumentException {
        if (n >= Short.MAX_VALUE) {
            throw new IllegalArgumentException(Errors.format((short)37, (Object)n));
        }
        return new long[n << 1];
    }

    private void validateCoordinates() throws IllegalArgumentException {
        int n = this.coordinates.length >>> 1;
        for (int i = 0; i < n; ++i) {
            long l = this.coordinates[i];
            long l2 = this.coordinates[i + n];
            if (l <= l2) continue;
            throw new IllegalArgumentException(Resources.format((short)32, this.getAxisIdentification(i, i), l, l2));
        }
    }

    private static DimensionNameType[] validateAxisTypes(DimensionNameType[] dimensionNameTypeArray) throws IllegalArgumentException {
        if (dimensionNameTypeArray == null) {
            return null;
        }
        if (Arrays.equals(DEFAULT_TYPES, dimensionNameTypeArray)) {
            return DEFAULT_TYPES;
        }
        DimensionNameType[] dimensionNameTypeArray2 = (DimensionNameType[])POOL.get((Object)dimensionNameTypeArray);
        if (dimensionNameTypeArray2 == null) {
            dimensionNameTypeArray = (DimensionNameType[])dimensionNameTypeArray.clone();
            for (int i = 1; i < dimensionNameTypeArray.length; ++i) {
                DimensionNameType dimensionNameType = dimensionNameTypeArray[i];
                if (dimensionNameType == null) continue;
                int n = i;
                while (--n >= 0) {
                    if (!dimensionNameType.equals((Object)dimensionNameTypeArray[n])) continue;
                    throw new IllegalArgumentException(Errors.format((short)24, (Object)dimensionNameType));
                }
            }
            dimensionNameTypeArray2 = (DimensionNameType[])POOL.putIfAbsent((Object)dimensionNameTypeArray, (Object)dimensionNameTypeArray);
            if (dimensionNameTypeArray2 == null) {
                return dimensionNameTypeArray;
            }
        }
        return dimensionNameTypeArray2;
    }

    private GridExtent(int n, DimensionNameType[] dimensionNameTypeArray) {
        this.coordinates = GridExtent.allocate(n);
        this.types = GridExtent.validateAxisTypes(dimensionNameTypeArray);
    }

    public GridExtent(long l, long l2) {
        ArgumentChecks.ensureStrictlyPositive((String)"width", (long)l);
        ArgumentChecks.ensureStrictlyPositive((String)"height", (long)l2);
        this.coordinates = new long[4];
        this.coordinates[2] = l - 1L;
        this.coordinates[3] = l2 - 1L;
        this.types = DEFAULT_TYPES;
    }

    public GridExtent(DimensionNameType[] dimensionNameTypeArray, long[] lArray, long[] lArray2, boolean bl) {
        ArgumentChecks.ensureNonNull((String)"high", (Object)lArray2);
        int n = lArray2.length;
        if (lArray != null && lArray.length != n) {
            throw new IllegalArgumentException(Errors.format((short)80, (Object)lArray.length, (Object)n));
        }
        if (dimensionNameTypeArray != null && dimensionNameTypeArray.length != n) {
            throw new IllegalArgumentException(Errors.format((short)77));
        }
        this.coordinates = GridExtent.allocate(n);
        if (lArray != null) {
            System.arraycopy(lArray, 0, this.coordinates, 0, n);
        }
        System.arraycopy(lArray2, 0, this.coordinates, n, n);
        if (!bl) {
            for (int i = n; i < this.coordinates.length; ++i) {
                this.coordinates[i] = Math.decrementExact(this.coordinates[i]);
            }
        }
        this.types = GridExtent.validateAxisTypes(dimensionNameTypeArray);
        this.validateCoordinates();
    }

    GridExtent(AbstractEnvelope abstractEnvelope, GridRoundingMode gridRoundingMode, int[] nArray, GridExtent gridExtent, int[] nArray2) {
        int n = abstractEnvelope.getDimension();
        this.coordinates = gridExtent != null ? (long[])gridExtent.coordinates.clone() : GridExtent.allocate(n);
        for (int i = 0; i < n; ++i) {
            long l;
            long l2;
            boolean bl;
            double d = abstractEnvelope.getLower(i);
            double d2 = abstractEnvelope.getUpper(i);
            boolean bl2 = d >= -9.223372036854776E18;
            boolean bl3 = bl = d2 <= 9.223372036854776E18;
            if (d > d2 || gridExtent == null && !(bl2 & bl)) {
                throw new IllegalArgumentException(Resources.format((short)32, this.getAxisIdentification(i, i), d, d2));
            }
            if (!bl2) {
                d = -9.223372036854776E18;
            }
            if (!bl) {
                d2 = 9.223372036854776E18;
            }
            switch (gridRoundingMode) {
                default: {
                    throw new AssertionError((Object)gridRoundingMode);
                }
                case ENCLOSING: {
                    l2 = (long)Math.floor(d);
                    l = (long)Math.ceil(d2);
                    if (l2 == l) break;
                    --l;
                    break;
                }
                case NEAREST: {
                    double d3;
                    long l3;
                    long l4;
                    l2 = Math.round(d);
                    l = Math.round(d2);
                    if (l2 != l) {
                        --l;
                    }
                    if ((l4 = l - l2 + 1L) < 0L || (l3 = Math.round(d3 = abstractEnvelope.getSpan(i))) == 0L || Math.abs(l4 -= l3) != 1L) break;
                    double d4 = Math.abs(d - Math.rint(d));
                    double d5 = Math.abs(d2 - Math.rint(d2));
                    boolean bl4 = d5 >= d4;
                    double d6 = Math.abs(d3 - (double)l3);
                    double d7 = bl4 ? d5 : d4;
                    if (!(d6 < d7)) break;
                    if (bl4) {
                        l = Math.subtractExact(l, l4);
                        break;
                    }
                    l2 = Math.addExact(l2, l4);
                }
            }
            if (nArray != null && i < nArray.length) {
                int n2 = nArray[i];
                if (gridExtent != null && n2 > 0) {
                    if (l2 < (l2 -= (long)n2)) {
                        l2 = Long.MIN_VALUE;
                    }
                    if (l > (l += (long)n2)) {
                        l = Long.MAX_VALUE;
                    }
                } else {
                    l2 = Math.subtractExact(l2, (long)n2);
                    l = Math.addExact(l, (long)n2);
                }
            }
            if (l2 > l) {
                l += l2 - l >>> 1;
                l2 = l;
            }
            int n3 = this.getDimension();
            if (gridExtent != null) {
                int n4 = nArray2 != null ? nArray2[i] : i;
                int n5 = n4 + n3;
                long l5 = this.coordinates[n4];
                long l6 = this.coordinates[n5];
                if (l2 > l5) {
                    this.coordinates[n4] = l2;
                }
                if (l < l6) {
                    this.coordinates[n5] = l;
                }
                if (l2 <= l6 && l >= l5) continue;
                throw new DisjointExtentException(gridExtent.getAxisIdentification(n4, i), l5, l6, l2, l);
            }
            this.coordinates[i] = l2;
            this.coordinates[i + n3] = l;
        }
        if (gridExtent != null) {
            this.types = gridExtent.types;
        } else {
            DimensionNameType[] dimensionNameTypeArray = null;
            CoordinateReferenceSystem coordinateReferenceSystem = abstractEnvelope.getCoordinateReferenceSystem();
            if (coordinateReferenceSystem != null) {
                CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
                for (int i = 0; i < n; ++i) {
                    DimensionNameType dimensionNameType = AXIS_DIRECTIONS.get(AxisDirections.absolute((AxisDirection)coordinateSystem.getAxis(i).getDirection()));
                    if (dimensionNameType == null) continue;
                    if (dimensionNameTypeArray == null) {
                        dimensionNameTypeArray = new DimensionNameType[n];
                    }
                    dimensionNameTypeArray[i] = dimensionNameType;
                }
            }
            this.types = GridExtent.validateAxisTypes(dimensionNameTypeArray);
        }
    }

    private GridExtent(GridExtent gridExtent) {
        this.types = gridExtent.types;
        this.coordinates = (long[])gridExtent.coordinates.clone();
    }

    public final int getDimension() {
        return this.coordinates.length >>> 1;
    }

    public boolean startsAtZero() {
        int n = this.getDimension();
        while (--n >= 0) {
            if (this.coordinates[n] == 0L) continue;
            return false;
        }
        return true;
    }

    GridCoordinatesView getLow() {
        return new GridCoordinatesView(this.coordinates, 0);
    }

    GridCoordinatesView getHigh() {
        return new GridCoordinatesView(this.coordinates, this.getDimension());
    }

    public long getLow(int n) {
        ArgumentChecks.ensureValidIndex((int)this.getDimension(), (int)n);
        return this.coordinates[n];
    }

    public long getHigh(int n) {
        int n2 = this.getDimension();
        ArgumentChecks.ensureValidIndex((int)n2, (int)n);
        return this.coordinates[n + n2];
    }

    public long getSize(int n) {
        int n2 = this.getDimension();
        ArgumentChecks.ensureValidIndex((int)n2, (int)n);
        return Math.incrementExact(Math.subtractExact(this.coordinates[n2 + n], this.coordinates[n]));
    }

    public double getSize(int n, boolean bl) {
        int n2 = this.getDimension();
        ArgumentChecks.ensureValidIndex((int)n2, (int)n);
        long l = this.coordinates[n2 + n] - this.coordinates[n];
        if (!bl && ++l == 0L) {
            return 1.8446744073709552E19;
        }
        return Numerics.toUnsignedDouble((long)l);
    }

    public double[] getPointOfInterest() {
        int n = this.getDimension();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = ((double)this.coordinates[i] + (double)this.coordinates[i + n] + 1.0) * 0.5;
        }
        return dArray;
    }

    public int[] getSubspaceDimensions(int n) {
        int n2;
        ArgumentChecks.ensurePositive((String)"s", (int)n);
        int n3 = this.getDimension();
        if (n > n3) {
            throw new RuntimeException(Resources.format((short)29, n));
        }
        int[] nArray = new int[n];
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            long l = this.coordinates[n2];
            long l2 = this.coordinates[n2 + n3];
            if (l == l2) continue;
            if (n4 < n) {
                nArray[n4++] = n2;
                continue;
            }
            throw new SubspaceNotSpecifiedException(Resources.format((short)44, n, this.getAxisIdentification(n2, n2), Numerics.toUnsignedDouble((long)(l2 - l))));
        }
        n2 = n - n4;
        if (n2 != 0) {
            System.arraycopy(nArray, 0, nArray, n2, n4);
            n4 = 0;
            int n5 = 0;
            while (true) {
                if (this.coordinates[n5] == this.coordinates[n5 + n3]) {
                    nArray[n4++] = n5;
                    if (n4 == n2) break;
                }
                ++n5;
            }
            Arrays.sort(nArray);
        }
        return nArray;
    }

    public Optional<DimensionNameType> getAxisType(int n) {
        ArgumentChecks.ensureValidIndex((int)this.getDimension(), (int)n);
        return Optional.ofNullable(this.types != null ? this.types[n] : null);
    }

    final Object getAxisIdentification(int n, int n2) {
        DimensionNameType dimensionNameType;
        if (this.types != null && (dimensionNameType = this.types[n]) != null) {
            return n2 + " (" + Types.getCodeTitle((CodeList)dimensionNameType) + ')';
        }
        return n2;
    }

    final GeneralEnvelope toCRS(MathTransform mathTransform, MathTransform mathTransform2, Envelope envelope) throws TransformException {
        int n;
        int n2 = this.getDimension();
        GeneralEnvelope generalEnvelope = new GeneralEnvelope(n2);
        for (n = 0; n < n2; ++n) {
            generalEnvelope.setRange(n, (double)this.coordinates[n], (double)this.coordinates[n + n2] + 1.0);
        }
        if ((generalEnvelope = Envelopes.transform((MathTransform)mathTransform, (Envelope)generalEnvelope)).isEmpty()) {
            try {
                int n3;
                n = mathTransform2 != mathTransform ? 1 : 0;
                TransformSeparator transformSeparator = null;
                for (n3 = 0; n3 < n2; ++n3) {
                    if (this.coordinates[n3 + n2] != 0L || this.coordinates[n3] != 0L) continue;
                    if (transformSeparator == null) {
                        transformSeparator = new TransformSeparator(mathTransform2);
                    }
                    transformSeparator.addSourceDimensionRange(n3, n3 + 1);
                    Matrix matrix = MathTransforms.getMatrix((MathTransform)transformSeparator.separate());
                    if (matrix != null) {
                        int[] nArray = transformSeparator.getTargetDimensions();
                        for (int i = 0; i < nArray.length; ++i) {
                            int n4 = nArray[i];
                            double d = generalEnvelope.getLower(n4);
                            double d2 = generalEnvelope.getUpper(n4);
                            double d3 = matrix.getElement(i, matrix.getNumCol() - 1);
                            if (n != 0) {
                                double d4 = d2 - d3;
                                if (Double.isNaN(d4) && Double.isNaN(d4 = d3 - d)) {
                                    d4 = 0.0;
                                }
                                if (Double.isNaN(d)) {
                                    d = d3 - d4;
                                }
                                if (Double.isNaN(d2)) {
                                    d2 = d3 + d4;
                                }
                            } else if (Double.isNaN(d)) {
                                d = d3;
                            }
                            generalEnvelope.setRange(n4, d, d2);
                        }
                    }
                    transformSeparator.clear();
                }
                if (envelope != null) {
                    n3 = generalEnvelope.getDimension();
                    while (--n3 >= 0) {
                        boolean bl = false;
                        double d = generalEnvelope.getLower(n3);
                        double d5 = generalEnvelope.getUpper(n3);
                        if (Double.isNaN(d)) {
                            d = envelope.getMinimum(n3);
                            bl = true;
                        }
                        if (Double.isNaN(d5)) {
                            d5 = envelope.getMaximum(n3);
                            bl = true;
                        }
                        if (!bl || d > d5) continue;
                        generalEnvelope.setRange(n3, d, d5);
                    }
                }
            }
            catch (FactoryException factoryException) {
                GridGeometry.recoverableException((Exception)((Object)factoryException));
            }
        }
        return generalEnvelope;
    }

    public GridExtent insert(int n, DimensionNameType dimensionNameType, long l, long l2, boolean bl) {
        int n2 = this.getDimension();
        ArgumentChecks.ensureBetween((String)"offset", (int)0, (int)n2, (int)n);
        if (!bl) {
            l2 = Math.decrementExact(l2);
        }
        int n3 = n2 + 1;
        DimensionNameType[] dimensionNameTypeArray = null;
        if (this.types != null || dimensionNameType != null) {
            dimensionNameTypeArray = this.types != null ? (DimensionNameType[])ArraysExt.insert((Object[])this.types, (int)n, (int)1) : new DimensionNameType[n3];
            dimensionNameTypeArray[n] = dimensionNameType;
        }
        GridExtent gridExtent = new GridExtent(n3, dimensionNameTypeArray);
        System.arraycopy(this.coordinates, 0, gridExtent.coordinates, 0, n);
        System.arraycopy(this.coordinates, n, gridExtent.coordinates, n + 1, n2 - n);
        System.arraycopy(this.coordinates, n2, gridExtent.coordinates, n3, n);
        System.arraycopy(this.coordinates, n2 + n, gridExtent.coordinates, n3 + n + 1, n2 - n);
        gridExtent.coordinates[n] = l;
        gridExtent.coordinates[n + n3] = l2;
        gridExtent.validateCoordinates();
        return gridExtent;
    }

    static int[] verifyDimensions(int[] nArray, int n) {
        ArgumentChecks.ensureNonNull((String)"dimensions", (Object)nArray);
        int n2 = nArray.length;
        ArgumentChecks.ensureSizeBetween((String)"dimensions", (int)1, (int)n, (int)n2);
        nArray = (int[])nArray.clone();
        if (!ArraysExt.isSorted((int[])nArray, (boolean)true)) {
            throw new IllegalArgumentException(Resources.format((short)46));
        }
        int n3 = nArray[0];
        if (n3 >= 0 && (n3 = nArray[n2 - 1]) < n) {
            return (int[])(n2 != n ? nArray : null);
        }
        throw new IndexOutOfBoundsException(Errors.format((short)71, (Object)n3));
    }

    public GridExtent expand(long ... lArray) {
        ArgumentChecks.ensureNonNull((String)"margins", (Object)lArray);
        int n = this.getDimension();
        int n2 = Math.min(n, lArray.length);
        GridExtent gridExtent = new GridExtent(this);
        long[] lArray2 = gridExtent.coordinates;
        for (int i = 0; i < n2; ++i) {
            long l = lArray[i];
            lArray2[i] = Math.subtractExact(lArray2[i], l);
            lArray2[i + n] = Math.addExact(lArray2[i + n], l);
        }
        return Arrays.equals(lArray2, this.coordinates) ? this : gridExtent;
    }

    public GridExtent resize(long ... lArray) {
        ArgumentChecks.ensureNonNull((String)"sizes", (Object)lArray);
        int n = this.getDimension();
        int n2 = Math.min(n, lArray.length);
        GridExtent gridExtent = new GridExtent(this);
        long[] lArray2 = gridExtent.coordinates;
        for (int i = 0; i < n2; ++i) {
            long l = lArray[i];
            if (l <= 0L) {
                throw new IllegalArgumentException(Errors.format((short)165, (Object)Strings.toIndexed((String)"sizes", (int)i), (Object)l));
            }
            long l2 = lArray2[i];
            long l3 = lArray2[i + n];
            long l4 = Math.incrementExact(Math.subtractExact(l3, l2));
            if (Math.abs(l2) <= Math.abs(l3)) {
                l2 = Numerics.multiplyDivide((long)l2, (long)l, (long)l4);
                l3 = Math.addExact(l2, l - 1L);
            } else {
                l3 = Numerics.multiplyDivide((long)l3, (long)l, (long)l4);
                l2 = Math.subtractExact(l3, l - 1L);
            }
            lArray2[i] = l2;
            lArray2[i + n] = l3;
        }
        return Arrays.equals(lArray2, this.coordinates) ? this : gridExtent;
    }

    public GridExtent reduce(int ... nArray) {
        int n = this.getDimension();
        if ((nArray = GridExtent.verifyDimensions(nArray, n)) == null) {
            return this;
        }
        int n2 = nArray.length;
        DimensionNameType[] dimensionNameTypeArray = null;
        if (this.types != null) {
            dimensionNameTypeArray = new DimensionNameType[n2];
            for (int i = 0; i < n2; ++i) {
                dimensionNameTypeArray[i] = this.types[nArray[i]];
            }
        }
        GridExtent gridExtent = new GridExtent(n2, dimensionNameTypeArray);
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            gridExtent.coordinates[i] = this.coordinates[n3];
            gridExtent.coordinates[i + n2] = this.coordinates[n3 + n];
        }
        return gridExtent;
    }

    public GridExtent subsample(int ... nArray) {
        ArgumentChecks.ensureNonNull((String)"periods", (Object)nArray);
        int n = this.getDimension();
        ArgumentChecks.ensureDimensionMatches((String)"periods", (int)n, (int[])nArray);
        GridExtent gridExtent = new GridExtent(this);
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 > 1) {
                int n3 = i + n;
                long l = this.coordinates[i];
                long l2 = this.coordinates[n3] - l + 1L;
                if (l2 == 0L) {
                    throw new ArithmeticException(Errors.format((short)188, (Object)64));
                }
                long l3 = Long.divideUnsigned(l2, n2);
                if (l3 * (long)n2 == l2) {
                    --l3;
                }
                gridExtent.coordinates[i] = l /= (long)n2;
                gridExtent.coordinates[n3] = l + l3;
                continue;
            }
            if (n2 > 0) continue;
            throw new IllegalArgumentException(Errors.format((short)165, (Object)Strings.toIndexed((String)"periods", (int)i), (Object)n2));
        }
        return Arrays.equals(this.coordinates, gridExtent.coordinates) ? this : gridExtent;
    }

    final GridExtent sliceByRatio(DirectPosition directPosition, double d, int[] nArray) {
        int n = directPosition.getDimension();
        while (--n >= 0) {
            directPosition.setOrdinate(n, d * this.getSize(n, true) + (double)this.getLow(n));
        }
        for (n = 0; n < nArray.length; ++n) {
            directPosition.setOrdinate(nArray[n], Double.NaN);
        }
        return this.slice(directPosition, null);
    }

    final GridExtent slice(DirectPosition directPosition, int[] nArray) {
        GridExtent gridExtent = new GridExtent(this);
        int n = directPosition.getDimension();
        int n2 = this.getDimension();
        for (int i = 0; i < n; ++i) {
            double d = directPosition.getOrdinate(i);
            if (Double.isNaN(d)) continue;
            long l = Math.round(d);
            int n3 = nArray != null ? nArray[i] : i;
            long l2 = this.coordinates[n3];
            long l3 = this.coordinates[n3 + n2];
            if (l >= l2 && l <= l3) {
                gridExtent.coordinates[n3 + n2] = gridExtent.coordinates[n3] = l;
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int j = 0; j < n; ++j) {
                if (j != 0) {
                    stringBuilder.append(", ");
                }
                if (Double.isNaN(d = directPosition.getOrdinate(j))) {
                    stringBuilder.append("NaN");
                    continue;
                }
                stringBuilder.append(Math.round(d));
            }
            throw new RuntimeException(Resources.format((short)28, this.getAxisIdentification(n3, i), l2, l3, stringBuilder.toString()));
        }
        return Arrays.equals(this.coordinates, gridExtent.coordinates) ? this : gridExtent;
    }

    final MatrixSIS cornerToCRS(Envelope envelope) {
        int n = this.getDimension();
        int n2 = envelope.getDimension();
        MatrixSIS matrixSIS = Matrices.create((int)(n2 + 1), (int)(n + 1), (Number[])ExtendedPrecisionMatrix.ZERO);
        DoubleDouble doubleDouble = new DoubleDouble();
        DoubleDouble doubleDouble2 = new DoubleDouble();
        for (int i = 0; i < n2; ++i) {
            if (i < n) {
                doubleDouble2.set(this.coordinates[i]);
                doubleDouble.set(this.coordinates[i + n]);
                doubleDouble.subtract(doubleDouble2);
                doubleDouble.add(1.0);
                doubleDouble.inverseDivideGuessError(envelope.getSpan(i));
                if (!doubleDouble2.isZero()) {
                    doubleDouble2.multiply(doubleDouble);
                    doubleDouble2.negate();
                }
                doubleDouble2.addGuessError(envelope.getMinimum(i));
                matrixSIS.setNumber(i, n, (Number)doubleDouble2);
            } else {
                doubleDouble.value = Double.NaN;
                doubleDouble.error = Double.NaN;
            }
            matrixSIS.setNumber(i, i, (Number)doubleDouble);
        }
        matrixSIS.setElement(n2, n, 1.0);
        return matrixSIS;
    }

    public int hashCode() {
        return Arrays.hashCode(this.coordinates) + Arrays.hashCode(this.types) ^ 0xD838F82F;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == GridExtent.class) {
            GridExtent gridExtent = (GridExtent)object;
            return Arrays.equals(this.coordinates, gridExtent.coordinates) && Arrays.equals(this.types, gridExtent.types);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        try {
            this.appendTo(stringBuilder, Vocabulary.getResources((Locale)null));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return stringBuilder.toString();
    }

    final void appendTo(Appendable appendable, Vocabulary vocabulary) throws IOException {
        TableAppender tableAppender = new TableAppender(appendable, "");
        int n = this.getDimension();
        for (int i = 0; i < n; ++i) {
            String string;
            if (this.types == null || (string = Types.getCodeTitle((CodeList)this.types[i])) == null) {
                string = vocabulary.getString((short)148, (Object)i);
            }
            long l = this.coordinates[i];
            long l2 = this.coordinates[i + n];
            tableAppender.setCellAlignment((byte)-1);
            tableAppender.append((CharSequence)string).append((CharSequence)": ").nextColumn();
            tableAppender.append('[').nextColumn();
            tableAppender.setCellAlignment((byte)1);
            tableAppender.append((CharSequence)Long.toString(l)).append((CharSequence)" \u2026 ").nextColumn();
            tableAppender.append((CharSequence)Long.toString(l2)).append((CharSequence)"] ").nextColumn();
            tableAppender.append('(').append((CharSequence)vocabulary.getString((short)149, (Object)Long.toUnsignedString(l2 - l + 1L))).append(')').nextLine();
        }
        tableAppender.flush();
    }

    static {
        HashMap<AxisDirection, DimensionNameType> hashMap = new HashMap<AxisDirection, DimensionNameType>(6);
        hashMap.put(AxisDirection.COLUMN_POSITIVE, DimensionNameType.COLUMN);
        hashMap.put(AxisDirection.ROW_POSITIVE, DimensionNameType.ROW);
        hashMap.put(AxisDirection.UP, DimensionNameType.VERTICAL);
        hashMap.put(AxisDirection.FUTURE, DimensionNameType.TIME);
        AXIS_DIRECTIONS = hashMap;
        DEFAULT_TYPES = new DimensionNameType[]{DimensionNameType.COLUMN, DimensionNameType.ROW};
        POOL = new WeakValueHashMap(DimensionNameType[].class);
    }
}

