/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache.selector;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.social.core.storage.cache.model.key.CacheKey;
import org.exoplatform.social.core.storage.cache.model.key.IdentityFilterKey;
import org.exoplatform.social.core.storage.cache.model.key.ListIdentitiesKey;
import org.exoplatform.social.core.storage.cache.selector.CacheSelector;

public class IdentityCacheSelector
extends CacheSelector<CacheKey, Object> {
    private String provider;

    public IdentityCacheSelector(String provider) {
        if (StringUtils.isBlank((String)provider)) {
            throw new IllegalArgumentException("Provider id is empty");
        }
        this.provider = provider;
    }

    @Override
    public boolean select(CacheKey key, ObjectCacheInfo<? extends Object> ocinfo) {
        if (key == null) {
            return false;
        }
        if (!super.select(key, ocinfo)) {
            return false;
        }
        if (key instanceof IdentityFilterKey) {
            return this.provider.equals(((IdentityFilterKey)key).getProviderId());
        }
        if (key instanceof ListIdentitiesKey) {
            return this.provider.equals(((ListIdentitiesKey)key).getKey().getProviderId());
        }
        return false;
    }
}

