/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.ogg;

import org.gagravarr.ogg.OggPacketData;
import org.gagravarr.ogg.OggPage;

public class OggPacket
extends OggPacketData {
    private OggPage parent;
    private boolean bos;
    private boolean eos;

    protected OggPacket(OggPage parent, byte[] data, boolean bos, boolean eos) {
        super(data);
        this.parent = parent;
        this.bos = bos;
        this.eos = eos;
    }

    public OggPacket(byte[] data) {
        super(data);
    }

    protected void setParent(OggPage parent) {
        this.parent = parent;
    }

    protected void setIsBOS() {
        this.bos = true;
    }

    protected void setIsEOS() {
        this.eos = true;
    }

    protected OggPage _getParent() {
        return this.parent;
    }

    public int getSid() {
        return this.parent.getSid();
    }

    public long getGranulePosition() {
        return this.parent.getGranulePosition();
    }

    public int getSequenceNumber() {
        return this.parent.getSequenceNumber();
    }

    public int getOverheadBytes() {
        if (this.parent == null) {
            return 0;
        }
        double ourShare = 1.0;
        int ourDataLen = this.getData().length;
        int pageDataLen = this.parent.getDataSize();
        if (pageDataLen != ourDataLen) {
            if (ourDataLen > pageDataLen) {
                int approxPages = (int)Math.ceil(ourDataLen / pageDataLen);
                ourShare = approxPages;
            } else {
                ourShare = (double)ourDataLen / (double)pageDataLen;
            }
        }
        return (int)Math.rint(ourShare * (double)(this.parent.getPageSize() - pageDataLen));
    }

    public boolean isBeginningOfStream() {
        return this.bos;
    }

    public boolean isEndOfStream() {
        return this.eos;
    }
}

