/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.text.Format;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.CoordinateFormat;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.TemporalUtilities;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultSpatialTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.referencing.cs.DefaultParametricCS;
import org.apache.sis.referencing.datum.DefaultParametricDatum;
import org.apache.sis.referencing.factory.GeodeticObjectFactory;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;
import org.opengis.util.NoSuchIdentifierException;

public final class ServicesForMetadata
extends ReferencingServices {
    public static final String CONNECTION = "CONNECTION";

    private static String dimensionNotFound(short s, CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem == null) {
            return Errors.format((short)157);
        }
        return Resources.format(s, coordinateReferenceSystem.getName());
    }

    private static DefaultGeographicBoundingBox setGeographicExtent(Envelope envelope, DefaultGeographicBoundingBox defaultGeographicBoundingBox, CoordinateReferenceSystem coordinateReferenceSystem, GeographicCRS geographicCRS, String string) throws TransformException {
        double d;
        double d2;
        double d3;
        double d4;
        if (geographicCRS != null) {
            CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
            EllipsoidalCS ellipsoidalCS = geographicCRS.getCoordinateSystem();
            if (!Utilities.equalsIgnoreMetadata((Object)ellipsoidalCS.getAxis(0), (Object)coordinateSystem.getAxis(0)) || !Utilities.equalsIgnoreMetadata((Object)ellipsoidalCS.getAxis(1), (Object)coordinateSystem.getAxis(1))) {
                CoordinateOperation coordinateOperation;
                DefaultCoordinateOperationFactory defaultCoordinateOperationFactory = CoordinateOperations.factory();
                try {
                    coordinateOperation = defaultCoordinateOperationFactory.createOperation(coordinateReferenceSystem, (CoordinateReferenceSystem)geographicCRS);
                }
                catch (FactoryException factoryException) {
                    if (string != null) {
                        Logging.recoverableException((Logger)Logging.getLogger((String)"org.apache.sis.referencing"), Envelopes.class, (String)string, (Throwable)factoryException);
                        return null;
                    }
                    throw new TransformException(Resources.format((short)8), (Throwable)factoryException);
                }
                envelope = Envelopes.transform(coordinateOperation, envelope);
            }
        }
        if (envelope instanceof AbstractEnvelope) {
            AbstractEnvelope abstractEnvelope = (AbstractEnvelope)envelope;
            d4 = abstractEnvelope.getLower(0);
            d3 = abstractEnvelope.getUpper(0);
            d2 = abstractEnvelope.getLower(1);
            d = abstractEnvelope.getUpper(1);
        } else {
            d4 = envelope.getMinimum(0);
            d3 = envelope.getMaximum(0);
            d2 = envelope.getMinimum(1);
            d = envelope.getMaximum(1);
        }
        if (geographicCRS != null) {
            double d5 = CRS.getGreenwichLongitude((GeodeticCRS)geographicCRS);
            d4 += d5;
            d3 += d5;
        }
        if (string != null) {
            if (Double.isNaN(d2)) {
                d2 = -90.0;
            }
            if (Double.isNaN(d)) {
                d = 90.0;
            }
            if (Double.isNaN(d3) || Double.isNaN(d4)) {
                d3 = -180.0;
                d4 = 180.0;
            }
        }
        if (defaultGeographicBoundingBox == null) {
            defaultGeographicBoundingBox = new DefaultGeographicBoundingBox();
        }
        defaultGeographicBoundingBox.setBounds(d4, d3, d2, d);
        defaultGeographicBoundingBox.setInclusion(Boolean.TRUE);
        return defaultGeographicBoundingBox;
    }

    private static void setVerticalExtent(Envelope envelope, DefaultVerticalExtent defaultVerticalExtent, CoordinateReferenceSystem coordinateReferenceSystem, VerticalCRS verticalCRS) {
        int n;
        if (verticalCRS == null) {
            n = 0;
        } else {
            n = AxisDirections.indexOfColinear(coordinateReferenceSystem.getCoordinateSystem(), (CoordinateSystem)verticalCRS.getCoordinateSystem());
            assert (n >= 0) : coordinateReferenceSystem;
        }
        defaultVerticalExtent.setMinimumValue(Double.valueOf(envelope.getMinimum(n)));
        defaultVerticalExtent.setMaximumValue(Double.valueOf(envelope.getMaximum(n)));
        defaultVerticalExtent.setVerticalCRS(verticalCRS);
    }

    private static void setTemporalExtent(Envelope envelope, DefaultTemporalExtent defaultTemporalExtent, CoordinateReferenceSystem coordinateReferenceSystem, TemporalCRS temporalCRS) {
        int n = AxisDirections.indexOfColinear(coordinateReferenceSystem.getCoordinateSystem(), (CoordinateSystem)temporalCRS.getCoordinateSystem());
        assert (n >= 0) : coordinateReferenceSystem;
        DefaultTemporalCRS defaultTemporalCRS = DefaultTemporalCRS.castOrCopy(temporalCRS);
        defaultTemporalExtent.setBounds(TemporalUtilities.toDate((Instant)defaultTemporalCRS.toInstant(envelope.getMinimum(n))), TemporalUtilities.toDate((Instant)defaultTemporalCRS.toInstant(envelope.getMaximum(n))));
    }

    public DefaultGeographicBoundingBox setBounds(Envelope envelope, DefaultGeographicBoundingBox defaultGeographicBoundingBox, String string) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        GeographicCRS geographicCRS = ReferencingUtilities.toNormalizedGeographicCRS(coordinateReferenceSystem, false, false);
        if (geographicCRS == null) {
            if (coordinateReferenceSystem != null) {
                geographicCRS = CommonCRS.defaultGeographic();
            } else if (envelope.getDimension() != 2) {
                if (string != null) {
                    return null;
                }
                throw new TransformException(ServicesForMetadata.dimensionNotFound((short)40, coordinateReferenceSystem));
            }
        }
        return ServicesForMetadata.setGeographicExtent(envelope, defaultGeographicBoundingBox, coordinateReferenceSystem, geographicCRS, string);
    }

    public void setBounds(Envelope envelope, DefaultVerticalExtent defaultVerticalExtent) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        VerticalCRS verticalCRS = CRS.getVerticalComponent(coordinateReferenceSystem, true);
        if (verticalCRS == null && envelope.getDimension() != 1) {
            throw new TransformException(ServicesForMetadata.dimensionNotFound((short)45, coordinateReferenceSystem));
        }
        ServicesForMetadata.setVerticalExtent(envelope, defaultVerticalExtent, coordinateReferenceSystem, verticalCRS);
    }

    public void setBounds(Envelope envelope, DefaultTemporalExtent defaultTemporalExtent) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        TemporalCRS temporalCRS = CRS.getTemporalComponent(coordinateReferenceSystem);
        if (temporalCRS == null) {
            throw new TransformException(ServicesForMetadata.dimensionNotFound((short)43, coordinateReferenceSystem));
        }
        ServicesForMetadata.setTemporalExtent(envelope, defaultTemporalExtent, coordinateReferenceSystem, temporalCRS);
    }

    public void setBounds(Envelope envelope, DefaultSpatialTemporalExtent defaultSpatialTemporalExtent) throws TransformException {
        GeographicExtent geographicExtent;
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        SingleCRS singleCRS = CRS.getHorizontalComponent(coordinateReferenceSystem);
        VerticalCRS verticalCRS = CRS.getVerticalComponent(coordinateReferenceSystem, true);
        TemporalCRS temporalCRS = CRS.getTemporalComponent(coordinateReferenceSystem);
        if (singleCRS == null && verticalCRS == null && temporalCRS == null) {
            throw new TransformException(ServicesForMetadata.dimensionNotFound((short)42, coordinateReferenceSystem));
        }
        DefaultGeographicBoundingBox defaultGeographicBoundingBox = null;
        boolean bl = singleCRS != null;
        Collection collection = defaultSpatialTemporalExtent.getSpatialExtent();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            geographicExtent = (GeographicExtent)iterator.next();
            if (!(geographicExtent instanceof GeographicBoundingBox)) continue;
            if (bl && geographicExtent instanceof DefaultGeographicBoundingBox) {
                defaultGeographicBoundingBox = (DefaultGeographicBoundingBox)geographicExtent;
                bl = false;
                continue;
            }
            iterator.remove();
        }
        if (singleCRS != null) {
            if (defaultGeographicBoundingBox == null) {
                defaultGeographicBoundingBox = new DefaultGeographicBoundingBox();
                collection.add(defaultGeographicBoundingBox);
            }
            if ((geographicExtent = ReferencingUtilities.toNormalizedGeographicCRS(coordinateReferenceSystem, false, false)) == null) {
                geographicExtent = CommonCRS.defaultGeographic();
            }
            ServicesForMetadata.setGeographicExtent(envelope, defaultGeographicBoundingBox, coordinateReferenceSystem, (GeographicCRS)geographicExtent, null);
        }
        if (verticalCRS != null) {
            geographicExtent = defaultSpatialTemporalExtent.getVerticalExtent();
            if (!(geographicExtent instanceof DefaultVerticalExtent)) {
                geographicExtent = new DefaultVerticalExtent();
                defaultSpatialTemporalExtent.setVerticalExtent((VerticalExtent)geographicExtent);
            }
            ServicesForMetadata.setVerticalExtent(envelope, (DefaultVerticalExtent)geographicExtent, coordinateReferenceSystem, verticalCRS);
        } else {
            defaultSpatialTemporalExtent.setVerticalExtent(null);
        }
        if (temporalCRS != null) {
            ServicesForMetadata.setTemporalExtent(envelope, (DefaultTemporalExtent)defaultSpatialTemporalExtent, coordinateReferenceSystem, temporalCRS);
        } else {
            defaultSpatialTemporalExtent.setExtent(null);
        }
    }

    public void addElements(Envelope envelope, DefaultExtent defaultExtent) throws TransformException {
        DefaultVerticalExtent defaultVerticalExtent;
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        SingleCRS singleCRS = CRS.getHorizontalComponent(coordinateReferenceSystem);
        VerticalCRS verticalCRS = CRS.getVerticalComponent(coordinateReferenceSystem, true);
        TemporalCRS temporalCRS = CRS.getTemporalComponent(coordinateReferenceSystem);
        if (singleCRS == null && verticalCRS == null && temporalCRS == null) {
            throw new TransformException(ServicesForMetadata.dimensionNotFound((short)42, coordinateReferenceSystem));
        }
        if (singleCRS != null) {
            defaultExtent.getGeographicElements().add(this.setBounds(envelope, null, null));
        }
        if (verticalCRS != null) {
            defaultVerticalExtent = new DefaultVerticalExtent();
            ServicesForMetadata.setVerticalExtent(envelope, defaultVerticalExtent, coordinateReferenceSystem, verticalCRS);
            defaultExtent.getVerticalElements().add(defaultVerticalExtent);
        }
        if (temporalCRS != null) {
            defaultVerticalExtent = new DefaultTemporalExtent();
            ServicesForMetadata.setTemporalExtent(envelope, (DefaultTemporalExtent)defaultVerticalExtent, coordinateReferenceSystem, temporalCRS);
            defaultExtent.getTemporalElements().add(defaultVerticalExtent);
        }
    }

    public DirectPosition geographic(double d, double d2) {
        return new DirectPosition2D((CoordinateReferenceSystem)CommonCRS.defaultGeographic(), d, d2);
    }

    public String getPreferredIdentifier(IdentifiedObject identifiedObject) throws FactoryException {
        Integer n = IdentifiedObjects.lookupEPSG(identifiedObject);
        if (n != null) {
            return "EPSG:" + n;
        }
        for (ReferenceIdentifier referenceIdentifier : identifiedObject.getIdentifiers()) {
            if ("EPSG".equalsIgnoreCase(referenceIdentifier.getCodeSpace())) continue;
            return IdentifiedObjects.toString((Identifier)referenceIdentifier);
        }
        return IdentifiedObjects.getSimpleNameOrIdentifier(identifiedObject);
    }

    public ParameterDescriptor<?> toImplementation(ParameterDescriptor<?> parameterDescriptor) {
        return DefaultParameterDescriptor.castOrCopy(parameterDescriptor);
    }

    public static CoordinateSystem createParametricCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CSFactory cSFactory) throws FactoryException {
        if (!(cSFactory instanceof GeodeticObjectFactory)) {
            cSFactory = (CSFactory)DefaultFactories.forBuildin(CSFactory.class, GeodeticObjectFactory.class);
        }
        return ((GeodeticObjectFactory)cSFactory).createParametricCS(map, coordinateSystemAxis);
    }

    public static Datum createParametricDatum(Map<String, ?> map, DatumFactory datumFactory) throws FactoryException {
        if (!(datumFactory instanceof GeodeticObjectFactory)) {
            datumFactory = (DatumFactory)DefaultFactories.forBuildin(DatumFactory.class, GeodeticObjectFactory.class);
        }
        return ((GeodeticObjectFactory)datumFactory).createParametricDatum(map);
    }

    public static SingleCRS createParametricCRS(Map<String, ?> map, Datum datum, CoordinateSystem coordinateSystem, CRSFactory cRSFactory) throws FactoryException {
        if (!(cRSFactory instanceof GeodeticObjectFactory)) {
            cRSFactory = (CRSFactory)DefaultFactories.forBuildin(CRSFactory.class, GeodeticObjectFactory.class);
        }
        try {
            return ((GeodeticObjectFactory)cRSFactory).createParametricCRS(map, (DefaultParametricDatum)datum, (DefaultParametricCS)coordinateSystem);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidGeodeticParameterException(classCastException.toString(), classCastException);
        }
    }

    public Format createCoordinateFormat(Locale locale, TimeZone timeZone) {
        return new CoordinateFormat(locale, timeZone);
    }

    public CoordinateOperationFactory getCoordinateOperationFactory() {
        return CoordinateOperations.factory();
    }

    public static OperationMethod getOperationMethod(CoordinateOperationFactory coordinateOperationFactory, MathTransformFactory mathTransformFactory, String string) throws FactoryException {
        OperationMethod operationMethod;
        if (coordinateOperationFactory instanceof DefaultCoordinateOperationFactory) {
            ((DefaultCoordinateOperationFactory)coordinateOperationFactory).getOperationMethod(string);
        }
        if ((operationMethod = ServicesForMetadata.getOperationMethod(mathTransformFactory.getAvailableMethods(SingleOperation.class), string)) != null) {
            return operationMethod;
        }
        throw new NoSuchIdentifierException("No such operation method: " + string, string);
    }

    private static OperationMethod getOperationMethod(Iterable<? extends OperationMethod> iterable, String string) {
        OperationMethod operationMethod = null;
        for (OperationMethod operationMethod2 : iterable) {
            if (!IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)operationMethod2, string) && !NameToIdentifier.isHeuristicMatchForIdentifier((Iterable)operationMethod2.getIdentifiers(), (String)string)) continue;
            if (!(operationMethod2 instanceof Deprecable) || !((Deprecable)operationMethod2).isDeprecated()) {
                return operationMethod2;
            }
            if (operationMethod != null) continue;
            operationMethod = operationMethod2;
        }
        return operationMethod;
    }

    public String getInformation(String string, Locale locale) {
        switch (string) {
            case "EPSG": {
                Citation citation;
                try {
                    citation = CRS.getAuthorityFactory("EPSG").getAuthority();
                }
                catch (FactoryException factoryException) {
                    String string2 = Exceptions.getLocalizedMessage((Throwable)factoryException, (Locale)locale);
                    return string2 != null ? string2 : factoryException.toString();
                }
                if (citation instanceof DefaultCitation) {
                    OnLineFunction onLineFunction = OnLineFunction.valueOf((String)CONNECTION);
                    for (OnlineResource onlineResource : ((DefaultCitation)citation).getOnlineResources()) {
                        InternationalString internationalString;
                        if (!onLineFunction.equals((Object)onlineResource.getFunction()) || (internationalString = onlineResource.getDescription()) == null) continue;
                        return internationalString.toString(locale);
                    }
                    InternationalString internationalString = citation.getTitle();
                    if (internationalString != null) {
                        return internationalString.toString(locale);
                    }
                }
                return Vocabulary.getResources((Locale)locale).getString((short)109);
            }
        }
        return super.getInformation(string, locale);
    }
}

