/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.blockchain.service;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.javascript.jscomp.jarjar.com.google.re2j.Pattern;
import java.io.IOException;
import java.math.BigInteger;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.blockchain.BlockchainRequestException;
import org.exoplatform.wallet.blockchain.MaxRequestRateReachedException;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector;
import org.exoplatform.wallet.contract.MeedsToken;
import org.exoplatform.wallet.model.ContractDetail;
import org.exoplatform.wallet.model.ContractTransactionEvent;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.service.BlockchainTransactionService;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.service.WalletService;
import org.exoplatform.wallet.service.WalletTransactionService;
import org.exoplatform.wallet.utils.WalletUtils;
import org.picocontainer.Startable;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.EventValues;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.protocol.core.Response;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;

public class EthereumBlockchainTransactionService
implements BlockchainTransactionService,
Startable {
    private static final Log LOG = ExoLogger.getLogger(EthereumBlockchainTransactionService.class);
    private static final Pattern GAS_PRICE_TOO_LOW_MESSAGE_PATTERN = Pattern.compile((String)"transaction gas price.*too low");
    private static final Pattern NONCE_TOO_LOW_MESSAGE_PATTERN = Pattern.compile((String)"nonce (is )?too low");
    private static final String TRANSFER_SIG = EventEncoder.encode((Event)MeedsToken.TRANSFER_EVENT);
    private static final Map<String, String> CONTRACT_METHODS_BY_SIG = new HashMap<String, String>();
    private PortalContainer container;
    private EthereumClientConnector ethereumClientConnector;
    private WalletAccountService accountService;
    private WalletTransactionService transactionService;
    private SettingService settingService;
    private ListenerService listenerService;
    private long networkId;
    private Queue<TransactionDetail> transactionDetailsToRefresh = new PriorityBlockingQueue<TransactionDetail>(1, this::compareTransactionDate);
    private ScheduledExecutorService transactionRefreshExecutor = null;

    public EthereumBlockchainTransactionService(PortalContainer container, WalletService walletService, SettingService settingService, EthereumClientConnector ethereumClientConnector, WalletTransactionService transactionService, WalletAccountService accountService, ListenerService listenerService) {
        this.container = container;
        this.settingService = settingService;
        this.ethereumClientConnector = ethereumClientConnector;
        this.transactionService = transactionService;
        this.accountService = accountService;
        this.listenerService = listenerService;
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("Ethereum-transaction-refresh-%d").build();
        this.transactionRefreshExecutor = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
    }

    public void start() {
        this.networkId = WalletUtils.getNetworkId();
        PortalContainer.addInitTask((ServletContext)this.container.getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostInitTask(){

            public void execute(ServletContext context, PortalContainer portalContainer) {
                CompletableFuture.runAsync(EthereumBlockchainTransactionService.this::startAsync);
                EthereumBlockchainTransactionService.this.transactionRefreshExecutor.scheduleWithFixedDelay(() -> EthereumBlockchainTransactionService.this.processTransactionRefreshingFromBlockchain(), 0L, EthereumBlockchainTransactionService.this.ethereumClientConnector.getPollingInterval(), TimeUnit.MILLISECONDS);
            }
        });
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransactionDetail> sendPendingTransactionsToBlockchain() {
        ArrayList<TransactionDetail> arrayList;
        List transactionsToSend = this.transactionService.getTransactionsToSend();
        if (CollectionUtils.isEmpty((Collection)transactionsToSend)) {
            return Collections.emptyList();
        }
        long startTime = System.currentTimeMillis();
        LOG.info("Start sending {} transactions to blockchain", new Object[]{transactionsToSend.size()});
        ArrayList<TransactionDetail> sentTransactions = new ArrayList<TransactionDetail>();
        try {
            for (TransactionDetail transactionDetail : transactionsToSend) {
                TransactionDetail trantactionDetailSent = this.sendTransactionToBlockchain(transactionDetail);
                if (trantactionDetailSent == null || !trantactionDetailSent.isPending() || trantactionDetailSent.getSentTimestamp() <= 0L) continue;
                sentTransactions.add(trantactionDetailSent);
            }
            arrayList = sentTransactions;
        }
        catch (Throwable throwable) {
            LOG.info("End sending {}/{} pending transactions to blockchain in {}ms", new Object[]{sentTransactions.size(), transactionsToSend.size(), System.currentTimeMillis() - startTime});
            throw throwable;
        }
        LOG.info("End sending {}/{} pending transactions to blockchain in {}ms", new Object[]{sentTransactions.size(), transactionsToSend.size(), System.currentTimeMillis() - startTime});
        return arrayList;
    }

    public void addTransactionToRefreshFromBlockchain(TransactionDetail transactionDetail) {
        if (this.transactionDetailsToRefresh.stream().noneMatch(otherTransactionDetail -> StringUtils.equalsIgnoreCase((CharSequence)otherTransactionDetail.getHash(), (CharSequence)transactionDetail.getHash()))) {
            this.transactionDetailsToRefresh.add(transactionDetail);
        }
    }

    public TransactionDetail refreshTransactionFromBlockchain(String transactionHash) {
        TransactionDetail transactionDetail = this.transactionService.getTransactionByHash(transactionHash);
        if (transactionDetail != null && !transactionDetail.isPending() && transactionDetail.isSucceeded()) {
            return transactionDetail;
        }
        Transaction transaction = this.ethereumClientConnector.getTransaction(transactionHash);
        this.retrieveTransactionDetailsFromBlockchain(transactionDetail, transaction);
        if (transaction != null && transaction.getBlockNumber() != null && transaction.getBlockNumber().longValue() > this.getLastWatchedBlockNumber()) {
            long blockNumber = transaction.getBlockNumber().longValue();
            this.saveLastWatchedBlockNumber(blockNumber);
            this.ethereumClientConnector.setLastWatchedBlockNumber(blockNumber);
        }
        return this.transactionService.getTransactionByHash(transactionHash);
    }

    public double getGasPrice() throws IOException {
        return this.ethereumClientConnector.getGasPrice().doubleValue();
    }

    public boolean hasManagedWalletInTransaction(ContractTransactionEvent transactionEvent) {
        List topics;
        String methodName;
        if (CollectionUtils.isNotEmpty((Collection)transactionEvent.getTopics()) && StringUtils.equals((CharSequence)(methodName = CONTRACT_METHODS_BY_SIG.get((topics = transactionEvent.getTopics()).get(0))), (CharSequence)"transfer")) {
            org.web3j.protocol.core.methods.response.Log log = new org.web3j.protocol.core.methods.response.Log();
            log.setAddress(transactionEvent.getContractAddress());
            log.setData(transactionEvent.getData());
            log.setTopics(topics);
            EventValues parameters = Contract.staticExtractEventParameters((Event)MeedsToken.TRANSFER_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
            if (parameters == null) {
                return false;
            }
            String from = ((Type)parameters.getIndexedValues().get(0)).getValue().toString();
            String to = ((Type)parameters.getIndexedValues().get(1)).getValue().toString();
            if (this.accountService.getWalletByAddress(from) != null) {
                return true;
            }
            if (this.accountService.getWalletByAddress(to) != null) {
                return true;
            }
        }
        return false;
    }

    public long getLastWatchedBlockNumber() {
        SettingValue lastBlockNumberValue = this.settingService.get(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, "ADDONS_ETHEREUM_LAST_BLOCK_NUMBER" + this.networkId);
        if (lastBlockNumberValue != null && lastBlockNumberValue.getValue() != null) {
            return Long.parseLong(lastBlockNumberValue.getValue().toString());
        }
        return 0L;
    }

    public void saveLastWatchedBlockNumber(long lastWatchedBlockNumber) {
        LOG.debug("Save watched block number {} on network {}", new Object[]{lastWatchedBlockNumber, this.networkId});
        this.settingService.set(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, "ADDONS_ETHEREUM_LAST_BLOCK_NUMBER" + this.networkId, SettingValue.create((Long)lastWatchedBlockNumber));
    }

    public Future startWatchingBlockchain() {
        long lastWatchedBlockNumber = this.getLastWatchedBlockNumber();
        if (lastWatchedBlockNumber == 0L) {
            lastWatchedBlockNumber = this.ethereumClientConnector.getLastestBlockNumber() - 1L;
            this.saveLastWatchedBlockNumber(lastWatchedBlockNumber);
        }
        this.ethereumClientConnector.setLastWatchedBlockNumber(lastWatchedBlockNumber);
        return this.ethereumClientConnector.renewTransactionListeningSubscription(lastWatchedBlockNumber + 1L);
    }

    public void stopWatchingBlockchain() {
        try {
            this.ethereumClientConnector.cancelTransactionListeningToBlockchain();
        }
        finally {
            this.saveLastWatchedBlockNumber(this.ethereumClientConnector.getLastWatchedBlockNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startAsync() {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            boolean hasEverUsedWallet;
            long pendingContractTransactionsSent = this.transactionService.countContractPendingTransactionsSent();
            boolean noPendingTransactionsToWatch = pendingContractTransactionsSent == 0L;
            Wallet adminWallet = this.accountService.getAdminWallet();
            boolean isAdminWalletEnabled = adminWallet != null && adminWallet.isEnabled() && adminWallet.getEtherBalance() != null && adminWallet.getEtherBalance() > 0.0 && adminWallet.getTokenBalance() != null && adminWallet.getTokenBalance() > 0.0;
            boolean bl = hasEverUsedWallet = isAdminWalletEnabled || this.transactionService.countTransactions() > 0L;
            if (hasEverUsedWallet && noPendingTransactionsToWatch) {
                long lastWatchedBlockNumber = this.ethereumClientConnector.getLastestBlockNumber();
                this.saveLastWatchedBlockNumber(lastWatchedBlockNumber);
                this.ethereumClientConnector.setLastWatchedBlockNumber(lastWatchedBlockNumber);
            }
            if (this.ethereumClientConnector.isPermanentlyScanBlockchain() || pendingContractTransactionsSent > 0L) {
                this.startWatchingBlockchain();
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTransactionRefreshingFromBlockchain() {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            int limit = this.transactionDetailsToRefresh.size() > 10 ? 10 : this.transactionDetailsToRefresh.size();
            for (int i = 0; i < limit; ++i) {
                TransactionDetail transactionDetail = this.transactionDetailsToRefresh.poll();
                String hash = transactionDetail.getHash();
                try {
                    this.refreshTransactionFromBlockchain(hash);
                    continue;
                }
                catch (Exception e) {
                    LOG.warn("Error while refreshing transaction with hash {}. Retry it after few seconds.", new Object[]{hash, e});
                    this.addTransactionToRefreshFromBlockchain(transactionDetail);
                }
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private void retrieveTransactionDetailsFromBlockchain(TransactionDetail transactionDetail, Transaction transaction) {
        Wallet wallet;
        TransactionReceipt transactionReceipt;
        if (transaction == null || this.isTransactionPendingOnBlockchain(transaction)) {
            if (transactionDetail == null) {
                throw new IllegalStateException("Nothing to verify for a null transaction from DB and Blockchain.");
            }
            if (transactionDetail.isPending()) {
                LOG.debug("Transaction {} is marked as pending in database and is not yet found on blockchain", new Object[]{transactionDetail.getHash()});
                this.checkPendingTransactionValidity(transactionDetail);
            }
            return;
        }
        ContractDetail contractDetail = WalletUtils.getContractDetail();
        if (contractDetail == null) {
            throw new IllegalStateException("Principal contract detail wasn't found in database");
        }
        String transactionHash = transaction.getHash();
        if (transactionDetail == null) {
            String contractAddress = transaction.getTo();
            if (!StringUtils.equalsIgnoreCase((CharSequence)contractDetail.getAddress(), (CharSequence)contractAddress)) {
                LOG.debug("Transaction '{}' is not a contract transaction, thus it will not be added into database", new Object[]{transactionHash});
                return;
            }
            transactionDetail = new TransactionDetail();
            transactionDetail.setNetworkId(this.networkId);
            transactionDetail.setContractAddress(contractAddress);
            transactionDetail.setHash(transactionHash);
        }
        if ((transactionReceipt = this.ethereumClientConnector.getTransactionReceipt(transactionHash)) == null) {
            throw new IllegalStateException("Couldn't find transaction receipt with hash '" + transactionHash + "' on blockchain");
        }
        boolean broadcastMinedTransaction = transactionDetail.isPending() || transactionDetail.isSucceeded() != transactionReceipt.isStatusOK();
        this.computeTransactionDetail(transactionDetail, contractDetail, transaction, transactionReceipt);
        if (StringUtils.isNotBlank((CharSequence)transactionDetail.getFrom()) && WalletUtils.isWalletEmpty((Wallet)transactionDetail.getFromWallet())) {
            wallet = this.accountService.getWalletByAddress(transactionDetail.getFrom());
            transactionDetail.setFromWallet(wallet);
        }
        if (StringUtils.isNotBlank((CharSequence)transactionDetail.getTo()) && WalletUtils.isWalletEmpty((Wallet)transactionDetail.getToWallet())) {
            wallet = this.accountService.getWalletByAddress(transactionDetail.getTo());
            transactionDetail.setToWallet(wallet);
        }
        if (StringUtils.isNotBlank((CharSequence)transactionDetail.getBy()) && WalletUtils.isWalletEmpty((Wallet)transactionDetail.getByWallet())) {
            wallet = this.accountService.getWalletByAddress(transactionDetail.getBy());
            transactionDetail.setByWallet(wallet);
        }
        this.transactionService.saveTransactionDetail(transactionDetail, broadcastMinedTransaction);
        if (transactionDetail.isSucceeded()) {
            this.transactionService.cancelTransactionsWithSameNonce(transactionDetail);
        }
    }

    private void checkPendingTransactionValidity(TransactionDetail transactionDetail) {
        boolean checkNonceValidity;
        boolean maxSendingTentativesReached = this.isMaxSendingTentativesReached(transactionDetail);
        boolean markTransactionAsFailed = this.isTransactionTimedOut(transactionDetail);
        boolean bl = checkNonceValidity = !markTransactionAsFailed && maxSendingTentativesReached;
        if (checkNonceValidity && this.isSameNonceAlreadyMined(transactionDetail.getFrom(), transactionDetail.getNonce())) {
            boolean bl2 = markTransactionAsFailed = !this.hasTransactionReceipt(transactionDetail.getHash());
        }
        if (markTransactionAsFailed) {
            transactionDetail.setPending(false);
            transactionDetail.setSucceeded(false);
            transactionDetail.setNonce(0L);
            LOG.info("Transaction '{}' was NOT FOUND on blockchain for more than '{}' days, and after '{}' tentatives to send", new Object[]{transactionDetail.getHash(), this.transactionService.getPendingTransactionMaxDays(), transactionDetail.getSendingAttemptCount()});
            this.transactionService.saveTransactionDetail(transactionDetail, true);
        }
    }

    private boolean isTransactionPendingOnBlockchain(Transaction transaction) {
        String blockHash = transaction.getBlockHash();
        return StringUtils.isBlank((CharSequence)blockHash) || StringUtils.equalsIgnoreCase((CharSequence)"0x0000000000000000000000000000000000000000000000000000000000000000", (CharSequence)blockHash) || transaction.getBlockNumber() == null;
    }

    private boolean canSendPendingTransactionToBlockchain(TransactionDetail transactionDetail) {
        boolean isPending = transactionDetail.isPending();
        boolean maxSendingTentativesReached = this.isMaxSendingTentativesReached(transactionDetail);
        boolean isTimedOut = this.isTransactionTimedOut(transactionDetail);
        boolean isEffectivelySent = this.isEffectivelySentToBlockchain(transactionDetail);
        boolean isAlreadySent = transactionDetail.getSendingAttemptCount() > 0L || transactionDetail.getSentTimestamp() > 0L;
        return isPending && !maxSendingTentativesReached && !isTimedOut && !isEffectivelySent && (isAlreadySent || this.transactionService.canSendTransactionToBlockchain(transactionDetail.getFrom()));
    }

    private boolean isEffectivelySentToBlockchain(TransactionDetail transactionDetail) {
        return transactionDetail.getSendingAttemptCount() == -200L;
    }

    private boolean isMaxSendingTentativesReached(TransactionDetail transactionDetail) {
        long sendingAttemptCount = transactionDetail.getSendingAttemptCount();
        long maxAttemptsToSend = this.transactionService.getMaxAttemptsToSend();
        return sendingAttemptCount > 0L && sendingAttemptCount >= maxAttemptsToSend;
    }

    private boolean isTransactionTimedOut(TransactionDetail transactionDetail) {
        boolean isInternalWalletTransaction = StringUtils.isNotBlank((CharSequence)transactionDetail.getRawTransaction());
        boolean transactionSendingTimedOut = false;
        if (isInternalWalletTransaction) {
            long timestamp = transactionDetail.getTimestamp();
            long pendingTransactionMaxDays = this.transactionService.getPendingTransactionMaxDays();
            Duration duration = Duration.ofMillis(System.currentTimeMillis() - timestamp);
            transactionSendingTimedOut = timestamp > 0L && pendingTransactionMaxDays > 0L && duration.toDays() >= pendingTransactionMaxDays;
        }
        return transactionSendingTimedOut;
    }

    private boolean isSameNonceAlreadyMined(String senderAddress, long nonce) {
        try {
            BigInteger nextNonce = this.ethereumClientConnector.getNonce(senderAddress);
            return nextNonce != null && nonce < nextNonce.longValue();
        }
        catch (Exception e) {
            LOG.warn("Error retrieving last nonce of {}", new Object[]{senderAddress, e});
            return false;
        }
    }

    private boolean handleTransactionSendingRequest(TransactionDetail transactionDetail, EthSendTransaction transaction) {
        String transactionHash = transactionDetail.getHash();
        transactionDetail.increaseSendingAttemptCount();
        if (transaction != null && transaction.getTransactionHash() != null) {
            transactionHash = transaction.getTransactionHash();
            LOG.debug("Received transaction hash {} for sent transaction {}", new Object[]{transactionHash, transactionDetail.getHash()});
            transactionDetail.setHash(transactionHash);
            this.setSentTimestampIfNotSet(transactionDetail);
            if (transaction.getError() == null) {
                this.markTransactionAsEffectivelySent(transactionDetail);
            }
        }
        boolean alreadyMined = false;
        boolean sentToBlockchain = false;
        try {
            boolean hasError;
            Response.Error transactionError = transaction == null ? null : transaction.getError();
            boolean bl = hasError = transactionError != null && StringUtils.isBlank((CharSequence)((CharSequence)transaction.getResult()));
            if (hasError) {
                if (this.isRequestRateLimitReached(transactionError)) {
                    throw new MaxRequestRateReachedException(transactionDetail.getHash(), transactionError.getMessage());
                }
                if (this.isAlreadySentError(transactionError)) {
                    sentToBlockchain = true;
                    this.setSentTimestampIfNotSet(transactionDetail);
                    this.markTransactionAsEffectivelySent(transactionDetail);
                } else if (this.hasTransactionReceipt(transactionDetail.getHash())) {
                    alreadyMined = true;
                    this.addTransactionToRefreshFromBlockchain(transactionDetail);
                } else if (this.isUnrecoverableError(transactionError)) {
                    transactionDetail.setNonce(0L);
                    transactionDetail.setPending(false);
                    transactionDetail.setSucceeded(false);
                    LOG.warn("Error when sending transaction {} with an unrecoverable Error: [{}]. Mark it as failed.", new Object[]{transactionDetail.getHash(), this.getTransactionErrorMessage(transactionError)});
                } else {
                    LOG.warn("Error when sending transaction {}. Error: [{}].", new Object[]{transactionDetail.getHash(), this.getTransactionErrorMessage(transactionError)});
                }
            } else {
                sentToBlockchain = true;
            }
        }
        catch (MaxRequestRateReachedException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn("Error handling Transaction '{}' Sending", new Object[]{transactionHash, e});
        }
        if (!alreadyMined) {
            boolean broadcastMined = !transactionDetail.isPending();
            this.transactionService.saveTransactionDetail(transactionDetail, broadcastMined);
        }
        return sentToBlockchain;
    }

    private boolean isRequestRateLimitReached(Response.Error transactionError) {
        return transactionError != null && transactionError.getCode() == 429;
    }

    private void markTransactionAsEffectivelySent(TransactionDetail transactionDetail) {
        transactionDetail.setSendingAttemptCount(-200L);
    }

    private boolean hasTransactionReceipt(String hash) {
        return this.ethereumClientConnector.getTransactionReceipt(hash) != null;
    }

    private void setSentTimestampIfNotSet(TransactionDetail transactionDetail) {
        if (transactionDetail.getSentTimestamp() == 0L) {
            transactionDetail.setSentTimestamp(System.currentTimeMillis());
        }
    }

    private boolean isUnrecoverableError(Response.Error transactionError) {
        String message = StringUtils.lowerCase((String)this.getTransactionErrorMessage(transactionError));
        return message != null && (StringUtils.containsAny((CharSequence)message, (CharSequence[])new CharSequence[]{"insufficient funds", "base fee exceeds gas limit", "replacement transaction underpriced", "only replay-protected"}) || GAS_PRICE_TOO_LOW_MESSAGE_PATTERN.matcher((CharSequence)message).find() || this.isNonceTooLow(transactionError));
    }

    private boolean isAlreadySentError(Response.Error transactionError) {
        String message = StringUtils.lowerCase((String)this.getTransactionErrorMessage(transactionError));
        return StringUtils.containsIgnoreCase((CharSequence)message, (CharSequence)"already known");
    }

    private boolean isNonceTooLow(Response.Error transactionError) {
        String message = StringUtils.lowerCase((String)this.getTransactionErrorMessage(transactionError));
        return NONCE_TOO_LOW_MESSAGE_PATTERN.matcher((CharSequence)message).find();
    }

    private void computeTransactionDetail(TransactionDetail transactionDetail, ContractDetail contractDetail, Transaction transaction, TransactionReceipt transactionReceipt) {
        String receiverAddress;
        String contractAddress;
        boolean isContractTransaction;
        transactionDetail.setFrom(transaction.getFrom());
        transactionDetail.setSucceeded(transactionReceipt.isStatusOK());
        transactionDetail.setGasUsed(transactionReceipt.getGasUsed().intValue());
        transactionDetail.setGasPrice(transaction.getGasPrice().doubleValue());
        transactionDetail.setPending(false);
        transactionDetail.setNonce(transaction.getNonce().longValue());
        if (transactionDetail.getTimestamp() <= 0L) {
            transactionDetail.setTimestamp(System.currentTimeMillis());
        }
        if (transaction.getValue().compareTo(BigInteger.ZERO) >= 0) {
            BigInteger weiAmount = transaction.getValue();
            transactionDetail.setValueDecimal(weiAmount, 18);
        }
        if (isContractTransaction = StringUtils.equalsIgnoreCase((CharSequence)(contractAddress = contractDetail.getAddress()), (CharSequence)(receiverAddress = transaction.getTo()))) {
            transactionDetail.setContractAddress(contractAddress);
            if (transactionReceipt.isStatusOK()) {
                this.computeContractTransactionDetails(transactionDetail, contractDetail, transactionReceipt.getLogs());
            }
        } else {
            transactionDetail.setTo(receiverAddress);
            transactionDetail.setTokenFee(0.0);
            transactionDetail.setEtherFee(0.0);
            transactionDetail.setContractAddress(null);
            transactionDetail.setContractMethodName(null);
            transactionDetail.setContractAmount(0.0);
            transactionDetail.setNoContractFunds(false);
        }
    }

    private void computeContractTransactionDetails(TransactionDetail transactionDetail, ContractDetail contractDetail, List<org.web3j.protocol.core.methods.response.Log> logs) {
        if (logs != null && !logs.isEmpty()) {
            Integer contractDecimals = contractDetail.getDecimals();
            int logsSize = logs.size();
            String hash = transactionDetail.getHash();
            LOG.debug("Retrieving information from blockchain for transaction {} with {} LOGS", new Object[]{hash, logsSize});
            int i = 0;
            while (i < logsSize) {
                org.web3j.protocol.core.methods.response.Log log;
                List topics;
                if ((topics = (log = logs.get(i++)).getTopics()) == null || topics.isEmpty()) {
                    LOG.warn("Transaction {} has NO topics", new Object[]{hash});
                    transactionDetail.setSucceeded(false);
                    continue;
                }
                String topic = (String)topics.get(0);
                LOG.debug("Treating transaction log {} with {} topics", new Object[]{hash, topics.size()});
                String methodName = CONTRACT_METHODS_BY_SIG.get(topic);
                if (!StringUtils.isNotBlank((CharSequence)methodName)) continue;
                transactionDetail.setContractAddress(contractDetail.getAddress());
                transactionDetail.setContractMethodName(methodName);
                if (!StringUtils.equals((CharSequence)methodName, (CharSequence)"transfer")) continue;
                EventValues parameters = Contract.staticExtractEventParameters((Event)MeedsToken.TRANSFER_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                this.readTransactionDetailsFromEventParameters(transactionDetail, parameters, contractDecimals);
                return;
            }
        }
    }

    private TransactionDetail sendTransactionToBlockchain(TransactionDetail transactionDetail) {
        if (!this.canSendPendingTransactionToBlockchain(transactionDetail)) {
            return null;
        }
        try {
            CompletableFuture<EthSendTransaction> future = this.ethereumClientConnector.sendTransactionToBlockchain(transactionDetail);
            if (future != null) {
                CompletionStage completableFuture = future.handle((ethSendTransaction, throwable) -> {
                    if (throwable != null) {
                        throw new BlockchainRequestException(TRANSFER_SIG, (Throwable)throwable);
                    }
                    ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
                    RequestLifeCycle.begin((ExoContainer)this.container);
                    try {
                        boolean sent = this.handleTransactionSendingRequest(transactionDetail, (EthSendTransaction)ethSendTransaction);
                        if (sent) {
                            this.broadcastTransactionSentToBlockchain(transactionDetail);
                        }
                        TransactionDetail transactionDetail2 = transactionDetail;
                        return transactionDetail2;
                    }
                    finally {
                        RequestLifeCycle.end();
                    }
                });
                return (TransactionDetail)((CompletableFuture)completableFuture).get();
            }
        }
        catch (BlockchainRequestException | MaxRequestRateReachedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BlockchainRequestException(transactionDetail.getHash(), e);
        }
        return null;
    }

    private void broadcastTransactionSentToBlockchain(TransactionDetail transactionDetail) {
        try {
            this.listenerService.broadcast("exo.wallet.transaction.sent", (Object)transactionDetail, (Object)transactionDetail);
        }
        catch (Exception e) {
            LOG.warn("Error when triggering event after transaction '{}' sent to blockchain", new Object[]{transactionDetail.getHash(), e});
        }
    }

    private void readTransactionDetailsFromEventParameters(TransactionDetail transactionDetail, EventValues parameters, Integer contractDecimals) {
        if (parameters != null) {
            String senderAddress = transactionDetail.getFrom();
            transactionDetail.setFrom(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
            transactionDetail.setTo(((Type)parameters.getIndexedValues().get(1)).getValue().toString());
            BigInteger amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
            transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
            transactionDetail.setAdminOperation(false);
            if (StringUtils.equals((CharSequence)"transfer", (CharSequence)transactionDetail.getContractMethodName()) && !StringUtils.equals((CharSequence)senderAddress, (CharSequence)transactionDetail.getFrom())) {
                transactionDetail.setBy(senderAddress);
                transactionDetail.setContractMethodName("transferFrom");
            }
        }
    }

    private String getTransactionErrorMessage(Response.Error transactionError) {
        if (transactionError == null) {
            return null;
        }
        return "Code: " + transactionError.getCode() + ", Message: " + transactionError.getMessage() + ", Data: " + transactionError.getData();
    }

    private int compareTransactionDate(TransactionDetail transactionDetail, TransactionDetail otherTransactionDetail) {
        return (int)(transactionDetail.getTimestamp() - otherTransactionDetail.getTimestamp());
    }

    static {
        CONTRACT_METHODS_BY_SIG.put(TRANSFER_SIG, "transfer");
    }
}

