/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.ant;

import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.exception.LiquibaseException;
import liquibase.integration.ant.AbstractChangeLogBasedTask;
import liquibase.repackaged.org.apache.tools.ant.BuildException;

public class DatabaseUpdateTestingRollbackTask
extends AbstractChangeLogBasedTask {
    private boolean dropFirst;

    @Override
    public void executeWithLiquibaseClassloader() throws BuildException {
        Liquibase liquibase = this.getLiquibase();
        try {
            if (this.isDropFirst()) {
                liquibase.dropAll();
            }
            liquibase.updateTestingRollback(new Contexts(this.getContexts()), this.getLabels());
        }
        catch (LiquibaseException e2) {
            throw new BuildException("Unable to update database with a rollback test: " + e2.getMessage(), (Throwable)e2);
        }
    }

    public boolean isDropFirst() {
        return this.dropFirst;
    }

    public void setDropFirst(boolean dropFirst) {
        this.dropFirst = dropFirst;
    }
}

