/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.notification;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.integration.notification.NotificationUtils;
import org.exoplatform.task.util.ProjectUtil;
import org.exoplatform.task.util.TaskUtil;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.router.Router;

public abstract class AbstractNotificationPlugin
extends BaseNotificationPlugin {
    public AbstractNotificationPlugin(InitParams initParams) {
        super(initParams);
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        TaskDto task = (TaskDto)ctx.value(NotificationUtils.TASK);
        String notificationCreator = (String)ctx.value(NotificationUtils.CREATOR);
        Set coworker = (Set)ctx.value(NotificationUtils.COWORKER);
        Set mentioned = (Set)ctx.value(NotificationUtils.MENTIONED);
        String actionName = (String)ctx.value(NotificationUtils.ACTION_NAME);
        String projectName = "";
        String projectId = "";
        ProjectDto project = null;
        if (task.getStatus() != null) {
            project = task.getStatus().getProject();
            projectName = project.getName();
            projectId = String.valueOf(project.getId());
        }
        StringBuilder activityId = new StringBuilder(projectId);
        activityId.append("-").append(notificationCreator);
        ExoContainer container = this.getContainer();
        WebAppController controller = (WebAppController)container.getComponentInstanceOfType(WebAppController.class);
        RequestLifeCycle.begin((ExoContainer)container);
        String taskUrl = this.buildTaskUrl(task, container, controller);
        String projectUrl = this.buildProjectUrl(project, container, controller);
        String assignee = task.getAssignee();
        Set listOfCoworker = task.getCoworker();
        Set listOfWatcher = task.getWatcher();
        Set<String> receivers = this.getReceiver(task, ctx);
        String taskCreator = task.getCreatedBy();
        RequestLifeCycle.end();
        return NotificationInfo.instance().to(new LinkedList<String>(receivers)).with("taskName", task.getTitle()).with("taskDescription", task.getDescription()).with(NotificationUtils.CREATOR.getKey(), notificationCreator).with("projectName", projectName).with("activityId", activityId.toString()).with("taskUrl", taskUrl).with("projectUrl", projectUrl).with("taskAssignee", assignee).with(NotificationUtils.RECEIVERS.getKey(), String.valueOf(receivers)).with("taskCoworkers", String.valueOf(listOfCoworker)).with("taskWatchers", String.valueOf(listOfWatcher)).with("addedCoworker", String.valueOf(coworker)).with("mentionedUsers", String.valueOf(mentioned)).with(NotificationUtils.ACTION_NAME.getKey(), String.valueOf(actionName)).with("taskCreator", taskCreator).key(this.getKey()).end();
    }

    private ExoContainer getContainer() {
        String containerName = PortalContainer.getCurrentPortalContainerName();
        PortalContainer container = RootContainer.getInstance().getPortalContainer(containerName);
        return container;
    }

    private String buildProjectUrl(ProjectDto project, ExoContainer container, WebAppController controller) {
        return CommonsUtils.getCurrentDomain() + ProjectUtil.buildProjectURL((ProjectDto)project, (SiteKey)CommonsUtils.getCurrentSite(), (ExoContainer)container, (Router)controller.getRouter());
    }

    protected Set<String> getReceiver(TaskDto task, NotificationContext ctx) {
        OrganizationService organizationService = CommonsUtils.getOrganizationService();
        HashSet<String> receivers = new HashSet<String>();
        if (task.getAssignee() != null && !task.getAssignee().isEmpty()) {
            receivers.add(task.getAssignee());
        }
        if (task.getCreatedBy() != null && !task.getCreatedBy().isEmpty()) {
            receivers.add(task.getCreatedBy());
        }
        if (task.getCoworker() != null && task.getCoworker().size() > 0) {
            receivers.addAll(task.getCoworker());
        }
        if (task.getWatcher() != null && task.getWatcher().size() > 0) {
            receivers.addAll(task.getWatcher());
        }
        if (ctx != null) {
            receivers.remove(ctx.value(NotificationUtils.CREATOR));
        }
        ProjectDto project = task.getStatus().getProject();
        receivers.removeIf(user -> !ProjectUtil.isProjectParticipant((OrganizationService)organizationService, (String)user, (ProjectDto)project));
        return receivers;
    }

    private String buildTaskUrl(TaskDto t, ExoContainer container, WebAppController controller) {
        return CommonsUtils.getCurrentDomain() + TaskUtil.buildTaskURL((TaskDto)t, (SiteKey)CommonsUtils.getCurrentSite(), (ExoContainer)container, (Router)controller.getRouter());
    }
}

