/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.Date;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.impl.MembershipTypeImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="v1/membershipTypes")
@Tag(name="v1/membershipTypes", description="Manage membership types operations")
public class MembershipTypeRestResourcesV1
implements ResourceContainer {
    private OrganizationService organizationService;
    private UserACL userACL;

    public MembershipTypeRestResourcesV1(OrganizationService organizationService, UserACL userACL) {
        this.organizationService = organizationService;
        this.userACL = userACL;
    }

    @GET
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets membership types", description="Gets membership types", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getMembershipType() throws Exception {
        Collection membershipTypes = this.organizationService.getMembershipTypeHandler().findMembershipTypes();
        return Response.ok((Object)membershipTypes).build();
    }

    @POST
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @Operation(summary="Creates a new membership type", description="Creates a new membership type", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createMembershipType(@RequestBody(description="Membership type object") MembershipTypeImpl membershipType) throws Exception {
        if (membershipType == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Membership type object is required").build();
        }
        if (StringUtils.isBlank((String)membershipType.getName())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"NAME:MANDATORY").build();
        }
        if (membershipType.getName().length() > 30 || membershipType.getName().length() < 3) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"NAME:LENGTH_INVALID").build();
        }
        if (StringUtils.isBlank((String)membershipType.getDescription())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"DESCRIPTION:MANDATORY").build();
        }
        if (membershipType.getDescription().length() > 255 || membershipType.getDescription().length() < 3) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"DESCRIPTION:LENGTH_INVALID").build();
        }
        if (this.organizationService.getMembershipTypeHandler().findMembershipType(membershipType.getName()) != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"NAME:ALREADY_EXISTS").build();
        }
        membershipType.setCreatedDate(new Date());
        membershipType.setModifiedDate(new Date());
        membershipType.setOwner(ConversationState.getCurrent().getIdentity().getUserId());
        this.organizationService.getMembershipTypeHandler().createMembershipType((MembershipType)membershipType, true);
        return Response.noContent().build();
    }

    @PUT
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @Operation(summary="Updates an existing membership type", description="Updates an existing membership type", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateMembershipType(@RequestBody(description="Membership type object") MembershipTypeImpl membershipType) throws Exception {
        if (membershipType == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Membership type object is required").build();
        }
        if (StringUtils.isBlank((String)membershipType.getName())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"NAME:MANDATORY").build();
        }
        if (this.organizationService.getMembershipTypeHandler().findMembershipType(membershipType.getName()) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"NAME:NOT_FOUND").build();
        }
        membershipType.setModifiedDate(new Date());
        membershipType.setOwner(ConversationState.getCurrent().getIdentity().getUserId());
        this.organizationService.getMembershipTypeHandler().saveMembershipType((MembershipType)membershipType, true);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="{membershipType}")
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Deletes an existing membership type", description="Deletes an existing membership type", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteMembershipType(@Parameter(description="Membership type name", required=true) @PathParam(value="membershipType") String membershipType) throws Exception {
        if (StringUtils.isBlank((String)membershipType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"NAME:MANDATORY").build();
        }
        if (this.userACL.getMandatoryMSTypes() != null && this.userACL.getMandatoryMSTypes().contains(membershipType) || StringUtils.equals((String)this.userACL.getMakableMT(), (String)membershipType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"MandatoryMembershipType").build();
        }
        if (this.organizationService.getMembershipTypeHandler().findMembershipType(membershipType) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"NAME:NOT_FOUND").build();
        }
        this.organizationService.getMembershipTypeHandler().removeMembershipType(membershipType, true);
        return Response.noContent().build();
    }
}

