/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.entities.domain.configuration.DomainEntity;
import org.exoplatform.addons.gamification.entities.domain.configuration.RuleEntity;
import org.exoplatform.addons.gamification.search.RuleSearchConnector;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleFilter;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityType;
import org.exoplatform.addons.gamification.service.mapper.RuleMapper;
import org.exoplatform.addons.gamification.storage.dao.GamificationHistoryDAO;
import org.exoplatform.addons.gamification.storage.dao.RuleDAO;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.commons.exception.ObjectNotFoundException;

public class RuleStorage {
    private RuleSearchConnector ruleSearchConnector;
    private RuleDAO ruleDAO;
    private GamificationHistoryDAO gamificationHistoryDAO;

    public RuleStorage(RuleDAO ruleDAO, RuleSearchConnector ruleSearchConnector, GamificationHistoryDAO gamificationHistoryDAO) {
        this.ruleSearchConnector = ruleSearchConnector;
        this.ruleDAO = ruleDAO;
        this.gamificationHistoryDAO = gamificationHistoryDAO;
    }

    public RuleDTO saveRule(RuleDTO ruleDTO) {
        RuleEntity ruleEntity = RuleMapper.ruleDTOToRule(ruleDTO);
        ruleEntity.setLastModifiedDate(new Date());
        DomainDTO domainDTO = ruleDTO.getDomainDTO();
        if (domainDTO != null) {
            DomainEntity domainEntity = Utils.getDomainById(domainDTO.getId());
            ruleEntity.setDomainEntity(domainEntity);
        }
        if (ruleEntity.getId() == null) {
            ruleEntity.setCreatedDate(new Date());
            ruleEntity = (RuleEntity)this.ruleDAO.create(ruleEntity);
        } else if (!ruleEntity.isDeleted()) {
            ruleEntity = (RuleEntity)this.ruleDAO.update(ruleEntity);
        }
        return RuleMapper.ruleToRuleDTO(ruleEntity);
    }

    public RuleDTO findEnableRuleByTitle(String ruleTitle) {
        return RuleMapper.ruleToRuleDTO(this.ruleDAO.findEnableRuleByTitle(ruleTitle));
    }

    public RuleDTO findRuleById(Long id) {
        return RuleMapper.ruleToRuleDTO((RuleEntity)this.ruleDAO.find(id));
    }

    public List<RuleDTO> findEnabledRulesByEvent(String event) {
        List<RuleEntity> entities = this.ruleDAO.findEnabledRulesByEvent(event);
        return RuleMapper.rulesToRuleDTOs(entities);
    }

    public RuleDTO findRuleByTitle(String ruleTitle) {
        return RuleMapper.ruleToRuleDTO(this.ruleDAO.findRuleByTitle(ruleTitle));
    }

    public RuleDTO findRuleByEventAndDomain(String event, long domainId) {
        return RuleMapper.ruleToRuleDTO(this.ruleDAO.findRuleByEventAndDomain(event, domainId));
    }

    public List<Long> findRulesIdsByFilter(RuleFilter ruleFilter, int offset, int limit) {
        List<Long> rulesIds = StringUtils.isBlank((CharSequence)ruleFilter.getTerm()) ? this.ruleDAO.findRulesIdsByFilter(ruleFilter, offset, limit) : this.ruleSearchConnector.search(ruleFilter, offset, limit).stream().map(RuleEntity::getId).collect(Collectors.toList());
        return rulesIds;
    }

    public int countRulesByFilter(RuleFilter ruleFilter) {
        if (ruleFilter == null) {
            return this.ruleDAO.count().intValue();
        }
        if (StringUtils.isBlank((CharSequence)ruleFilter.getTerm())) {
            return this.ruleDAO.countRulesByFilter(ruleFilter);
        }
        return this.ruleSearchConnector.count(ruleFilter);
    }

    public List<RuleDTO> findAllRules() {
        return RuleMapper.rulesToRuleDTOs(this.ruleDAO.getAllRules());
    }

    public List<Long> findAllRulesIds(int offset, int limit) {
        return this.ruleDAO.findRulesIdsByFilter(new RuleFilter(), offset, limit);
    }

    public List<RuleDTO> getActiveRules() {
        return RuleMapper.rulesToRuleDTOs(this.ruleDAO.getActiveRules());
    }

    public List<RuleDTO> getAllRulesByDomain(String domain) {
        return RuleMapper.rulesToRuleDTOs(this.ruleDAO.getAllRulesByDomain(domain));
    }

    public List<RuleDTO> getAllRulesWithNullDomain() {
        return RuleMapper.rulesToRuleDTOs(this.ruleDAO.getAllRulesWithNullDomain());
    }

    public List<String> getAllEvents() {
        return this.ruleDAO.getAllEvents();
    }

    public List<String> getDomainListFromRules() {
        return this.ruleDAO.getDomainList();
    }

    public long getRulesTotalScoreByDomain(long domainId) {
        return this.ruleDAO.getRulesTotalScoreByDomain(domainId);
    }

    public RuleDTO deleteRuleById(long ruleId, String userId) throws ObjectNotFoundException {
        return this.deleteRuleById(ruleId, userId, false);
    }

    public RuleDTO deleteRuleById(long ruleId, String userId, boolean force) throws ObjectNotFoundException {
        RuleEntity ruleEntity = (RuleEntity)this.ruleDAO.find(Long.valueOf(ruleId));
        if (ruleEntity == null) {
            throw new ObjectNotFoundException("Rule with id " + ruleId + " does not exist");
        }
        if (force) {
            this.ruleDAO.delete(ruleEntity);
        } else {
            ruleEntity.setLastModifiedBy(userId);
            ruleEntity.setLastModifiedDate(new Date());
            ruleEntity.setDeleted(true);
            this.ruleDAO.update(ruleEntity);
        }
        return RuleMapper.ruleToRuleDTO(ruleEntity);
    }

    public List<Long> findMostRealizedRuleIds(List<Long> spacesIds, int offset, int limit, EntityType type) {
        return this.gamificationHistoryDAO.findMostRealizedRuleIds(spacesIds, offset, limit, type);
    }

    public void clearCache() {
    }
}

