/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import java.util.List;
import org.exoplatform.social.core.jpa.storage.dao.jpa.LabelDAO;
import org.exoplatform.social.core.jpa.storage.entity.LabelEntity;
import org.exoplatform.social.core.model.Label;
import org.exoplatform.social.core.storage.api.LabelStorage;

public class RDBMSLabelStorageImpl
implements LabelStorage {
    private final LabelDAO labelDAO;

    public RDBMSLabelStorageImpl(LabelDAO labelDAO) {
        this.labelDAO = labelDAO;
    }

    public Label findLabelByObjectTypeAndObjectIdAndLang(String objectType, String objectId, String language) {
        return this.convertFromEntity(this.labelDAO.findLabelByObjectTypeAndObjectIdAndLang(objectType, objectId, language));
    }

    public List<Label> findLabelByObjectTypeAndObjectId(String objectType, String objectId) {
        return this.labelDAO.findLabelByObjectTypeAndObjectId(objectType, objectId).stream().map(this::convertFromEntity).toList();
    }

    public Label saveLabel(Label label, boolean isNew) {
        if (isNew) {
            return this.convertFromEntity((LabelEntity)this.labelDAO.create(this.convertToEntity(label)));
        }
        return this.convertFromEntity((LabelEntity)this.labelDAO.update(this.convertToEntity(label)));
    }

    public void deleteLabel(Long id) {
        this.labelDAO.delete((LabelEntity)this.labelDAO.find(id));
    }

    private LabelEntity convertToEntity(Label label) {
        if (label == null) {
            return null;
        }
        LabelEntity labelEntity = new LabelEntity();
        labelEntity.setId(label.getId());
        labelEntity.setObjectType(label.getObjectType());
        labelEntity.setObjectId(label.getObjectId());
        labelEntity.setLabel(label.getLabel());
        labelEntity.setLanguage(label.getLanguage());
        return labelEntity;
    }

    private Label convertFromEntity(LabelEntity labelEntity) {
        if (labelEntity == null) {
            return null;
        }
        Label label = new Label();
        label.setId(labelEntity.getId());
        label.setObjectType(labelEntity.getObjectType());
        label.setObjectId(labelEntity.getObjectId());
        label.setLabel(labelEntity.getLabel());
        label.setLanguage(labelEntity.getLanguage());
        return label;
    }
}

