/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.social.core.profile.settings.ProfilePropertySettingsService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;

public class GroupSynchronizationSocialProfileListener
extends ProfileListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(GroupSynchronizationSocialProfileListener.class);
    private static final String PROFILE_GROUP_NAME = "profile";
    private static final String MEMBER = "member";
    private final ProfilePropertySettingsService profilePropertySettingsService;
    private final OrganizationService organizationService;

    public GroupSynchronizationSocialProfileListener(ProfilePropertySettingsService profilePropertySettingsService, OrganizationService organizationService) {
        this.profilePropertySettingsService = profilePropertySettingsService;
        this.organizationService = organizationService;
    }

    public void avatarUpdated(ProfileLifeCycleEvent event) {
        this.profileUpdated(event);
    }

    public void bannerUpdated(ProfileLifeCycleEvent event) {
        this.profileUpdated(event);
    }

    public void contactSectionUpdated(ProfileLifeCycleEvent event) {
        this.profileUpdated(event);
    }

    public void experienceSectionUpdated(ProfileLifeCycleEvent event) {
        this.profileUpdated(event);
    }

    public void createProfile(ProfileLifeCycleEvent event) {
        this.profileUpdated(event);
    }

    private void profileUpdated(ProfileLifeCycleEvent profileLifeCycleEvent) {
        Profile profile = profileLifeCycleEvent.getProfile();
        try {
            User user = this.organizationService.getUserHandler().findUserByName(profile.getIdentity().getRemoteId());
            this.synchronizePropertyGroups(profileLifeCycleEvent.getProfile(), user, this.profilePropertySettingsService, this.organizationService);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while synchronizing profile property groups");
        }
    }

    private void synchronizePropertyGroups(Profile profile, User user, ProfilePropertySettingsService profilePropertySettingsService, OrganizationService organizationService) {
        Group profileGroup = this.createGroup(PROFILE_GROUP_NAME, null, organizationService);
        if (profileGroup != null) {
            List<String> synchronizedProperties = profilePropertySettingsService.getSynchronizedPropertySettings().stream().filter(ProfilePropertySetting::isActive).map(ProfilePropertySetting::getPropertyName).toList();
            Set properties = profile.getProperties().entrySet();
            properties.stream().filter(property -> synchronizedProperties.contains(property.getKey())).forEach(property -> {
                String propertyName = (String)property.getKey();
                String propertyValue = (String)property.getValue();
                Group newPropertyNameGroup = this.createGroup(propertyName, profileGroup, organizationService);
                if (newPropertyNameGroup != null) {
                    Group newPropertyValueGroup = this.createGroup(propertyValue, newPropertyNameGroup, organizationService);
                    this.addUserToGroup(newPropertyValueGroup, user, organizationService);
                }
            });
        }
    }

    private Group getGroup(String groupId, OrganizationService organizationService) {
        try {
            GroupHandler groupHandler = organizationService.getGroupHandler();
            return groupHandler.findGroupById(groupId);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Group createGroup(String groupName, Group parentGroup, OrganizationService organizationService) {
        try {
            Group group = this.getGroup(this.buildGroupId(parentGroup, groupName), organizationService);
            if (group != null) {
                return group;
            }
            GroupHandler groupHandler = organizationService.getGroupHandler();
            Group newGroup = groupHandler.createGroupInstance();
            newGroup.setGroupName(groupName.toLowerCase());
            newGroup.setLabel(StringUtils.capitalize((String)groupName));
            newGroup.setDescription(groupName + " group");
            groupHandler.addChild(parentGroup, newGroup, true);
            return this.getGroup(this.buildGroupId(parentGroup, groupName), organizationService);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void addUserToGroup(Group group, User user, OrganizationService organizationService) {
        if (group == null) {
            return;
        }
        try {
            MembershipType membershipType = organizationService.getMembershipTypeHandler().findMembershipType(MEMBER);
            organizationService.getMembershipHandler().linkMembership(user, group, membershipType, true);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while adding user to Group", (Throwable)e);
        }
    }

    private String buildGroupId(Group parentGroup, String groupName) {
        if (parentGroup == null) {
            return "/" + groupName.toLowerCase();
        }
        return parentGroup.getId() + "/" + groupName.toLowerCase();
    }
}

