/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.model.Label;
import org.exoplatform.social.core.storage.api.LabelStorage;

public class LabelService {
    private static final Log LOG = ExoLogger.getLogger(LabelService.class);
    private final LabelStorage labelStorage;

    public LabelService(LabelStorage labelStorage) {
        this.labelStorage = labelStorage;
    }

    public Label findLabelByObjectTypeAndObjectIdAndLang(String objectType, String objectId, String language) {
        return this.labelStorage.findLabelByObjectTypeAndObjectIdAndLang(objectType, objectId, language);
    }

    public List<Label> findLabelByObjectTypeAndObjectId(String objectType, String objectId) {
        return this.labelStorage.findLabelByObjectTypeAndObjectId(objectType, objectId);
    }

    public void createLabels(List<Label> labels, String objectType, String objectId) {
        for (Label label : labels) {
            try {
                if (StringUtils.isBlank((String)label.getObjectType())) {
                    label.setObjectType(objectType);
                }
                if (StringUtils.isBlank((String)label.getObjectId())) {
                    label.setObjectId(objectId);
                }
                this.createLabel(label);
            }
            catch (ObjectAlreadyExistsException e) {
                LOG.warn((Object)"Label already exist it will not be created");
            }
        }
    }

    public void createLabel(Label label) throws ObjectAlreadyExistsException {
        if (label == null) {
            throw new IllegalArgumentException("Label Item Object is mandatory");
        }
        if (StringUtils.isBlank((String)label.getObjectType())) {
            throw new IllegalArgumentException("Object type is mandatory");
        }
        if (label.getObjectId() == null) {
            throw new IllegalArgumentException("Object Id is mandatory");
        }
        if (StringUtils.isBlank((String)label.getLanguage())) {
            throw new IllegalArgumentException("language is mandatory");
        }
        if (StringUtils.isBlank((String)label.getLabel())) {
            throw new IllegalArgumentException("label value is mandatory");
        }
        Label storedLabel = this.labelStorage.findLabelByObjectTypeAndObjectIdAndLang(label.getObjectType(), label.getObjectId(), label.getLanguage());
        if (storedLabel != null) {
            throw new ObjectAlreadyExistsException((Object)storedLabel, "Label already exist");
        }
        this.labelStorage.saveLabel(label, true);
    }

    public void mergeLabels(List<Label> labels, String objectType, String objectId) {
        List<Label> storedLabels = this.findLabelByObjectTypeAndObjectId(objectType, objectId);
        ArrayList<Label> labelstoUpdate = new ArrayList<Label>();
        ArrayList<Label> labelstoDelete = new ArrayList<Label>();
        ArrayList<Label> labelstoCreate = new ArrayList<Label>();
        if (labels.isEmpty() && !storedLabels.isEmpty()) {
            this.deleteLabels(storedLabels);
        } else {
            for (Label label : storedLabels) {
                Label foundLabel = this.containsLabel(labels, label);
                if (foundLabel != null) {
                    if (foundLabel.equals((Object)label)) continue;
                    labelstoUpdate.add(foundLabel);
                    continue;
                }
                labelstoDelete.add(label);
            }
            for (Label label : labels) {
                if (label.getId() != null && label.getId() != 0L) continue;
                labelstoCreate.add(label);
            }
            for (Label label : labelstoCreate) {
                try {
                    if (StringUtils.isBlank((String)label.getObjectType())) {
                        label.setObjectType(objectType);
                    }
                    if (StringUtils.isBlank((String)label.getObjectId())) {
                        label.setObjectId(objectId);
                    }
                    this.createLabel(label);
                }
                catch (ObjectAlreadyExistsException e) {
                    LOG.warn((Object)"Label already exist it will not be created");
                }
            }
            for (Label label : labelstoUpdate) {
                this.updateLabel(label);
            }
            this.deleteLabels(labelstoDelete);
        }
    }

    private Label containsLabel(List<Label> list, Label label) {
        return list.stream().filter(o -> o.getId() != null && o.getId().equals(label.getId())).findAny().orElse(null);
    }

    public void updateLabel(Label label) {
        this.labelStorage.saveLabel(label, false);
    }

    public void deleteLabels(List<Label> labels) {
        for (Label label : labels) {
            this.deleteLabel(label.getId());
        }
    }

    public void deleteLabel(Long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException("Label Technical Identifier is mandatory");
        }
        this.labelStorage.deleteLabel(id);
    }
}

