/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.service.LinkProvider;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ProfileSearchConnector {
    private static final Log LOG = ExoLogger.getLogger(ProfileSearchConnector.class);
    private final ElasticSearchingClient client;
    private String index;
    private String searchType;

    public ProfileSearchConnector(InitParams initParams, ElasticSearchingClient client) {
        PropertiesParam param = initParams.getPropertiesParam("constructor.params");
        this.index = param.getProperty("index");
        this.searchType = param.getProperty("searchType");
        this.client = client;
    }

    public List<Identity> search(Identity identity, ProfileFilter filter, Relationship.Type type, long offset, long limit) {
        if (identity == null && filter.getViewerIdentity() != null) {
            identity = filter.getViewerIdentity();
        }
        String esQuery = this.buildQueryStatement(identity, filter, type, offset, limit);
        String jsonResponse = this.client.sendRequest(esQuery, this.index);
        return this.buildResult(jsonResponse);
    }

    public int count(Identity identity, ProfileFilter filter, Relationship.Type type) {
        String esQuery = this.buildQueryStatement(identity, filter, type, 0L, 1L);
        String jsonResponse = this.client.sendRequest(esQuery, this.index);
        return this.getCount(jsonResponse);
    }

    private int getCount(String jsonResponse) {
        LOG.debug("Search Query response from ES : {} ", new Object[]{jsonResponse});
        JSONParser parser = new JSONParser();
        Map json = null;
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return 0;
        }
        Object totalSize = ((JSONObject)jsonResult.get((Object)"total")).get((Object)"value");
        return totalSize == null ? 0 : Integer.parseInt(totalSize.toString());
    }

    private List<Identity> buildResult(String jsonResponse) {
        LOG.debug("Search Query response from ES : {} ", new Object[]{jsonResponse});
        ArrayList<Identity> results = new ArrayList<Identity>();
        JSONParser parser = new JSONParser();
        Map json = null;
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return results;
        }
        JSONArray jsonHits = (JSONArray)jsonResult.get((Object)"hits");
        Identity identity = null;
        for (Object jsonHit : jsonHits) {
            JSONObject hitSource = (JSONObject)((JSONObject)jsonHit).get((Object)"_source");
            String position = (String)hitSource.get((Object)"position");
            String aboutMe = (String)hitSource.get((Object)"aboutMe");
            String name = (String)hitSource.get((Object)"name");
            String userName = (String)hitSource.get((Object)"userName");
            String firstName = (String)hitSource.get((Object)"firstName");
            String lastName = (String)hitSource.get((Object)"lastName");
            String avatarUrl = (String)hitSource.get((Object)"avatarUrl");
            String email = (String)hitSource.get((Object)"email");
            String identityId = (String)((JSONObject)jsonHit).get((Object)"_id");
            identity = new Identity("organization", userName);
            identity.setId(identityId);
            Profile p = new Profile(identity);
            Profile profile = this.getIdentityProfile(userName);
            if (profile == null) continue;
            p.setId(identityId);
            p.setAvatarUrl(avatarUrl);
            p.setUrl(LinkProvider.getProfileUri(userName));
            p.setProperty("fullName", (Object)name);
            p.setProperty("firstName", (Object)firstName);
            p.setProperty("lastName", (Object)lastName);
            p.setProperty("position", (Object)position);
            p.setProperty("email", (Object)email);
            p.setProperty("username", (Object)userName);
            p.setProperty("aboutMe", (Object)aboutMe);
            if ((String)profile.getProperty("external") != null && !((String)profile.getProperty("external")).isEmpty()) {
                p.setProperty("external", (Object)((String)profile.getProperty("external")));
            }
            if ((String)profile.getProperty("synchronizedDate") != null && !((String)profile.getProperty("synchronizedDate")).isEmpty()) {
                p.setProperty("synchronizedDate", (Object)((String)profile.getProperty("synchronizedDate")));
            }
            if ((String)profile.getProperty("enrollmentDate") != null && !((String)profile.getProperty("enrollmentDate")).isEmpty()) {
                p.setProperty("enrollmentDate", (Object)((String)profile.getProperty("enrollmentDate")));
            }
            identity.setProfile(p);
            results.add(identity);
        }
        return results;
    }

    private Profile getIdentityProfile(String userName) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        Identity identity = identityManager.getOrCreateIdentity("organization", userName);
        return identity == null ? null : identity.getProfile();
    }

    private String buildQueryStatement(Identity identity, ProfileFilter filter, Relationship.Type type, long offset, long limit) {
        String expEs = this.buildExpression(filter);
        String expEsForAdvancedFilter = !filter.getProfileSettings().isEmpty() ? this.buildAdvancedFilterExpression(filter) : null;
        StringBuilder esQuery = new StringBuilder();
        esQuery.append("{\n");
        esQuery.append("   \"from\" : " + offset + ", \"size\" : " + limit + ",\n");
        Sorting sorting = filter.getSorting();
        if (sorting != null && sorting.sortBy != null) {
            esQuery.append("   \"sort\": {");
            switch (sorting.sortBy) {
                case DATE: {
                    esQuery.append("\"lastUpdatedDate\"");
                    break;
                }
                case FIRSTNAME: {
                    esQuery.append("\"firstName.raw\"");
                    break;
                }
                case LASTNAME: {
                    esQuery.append("\"lastName.raw\"");
                    break;
                }
                default: {
                    esQuery.append("\"name.raw\"");
                }
            }
            esQuery.append(": {\"order\": \"").append(sorting.orderBy == null ? "asc" : sorting.orderBy.name()).append("\"}}\n");
        } else {
            esQuery.append("   \"sort\": {\"name.raw\": {\"order\": \"asc\"}}\n");
        }
        StringBuilder esSubQuery = new StringBuilder();
        esSubQuery.append("       ,\n");
        esSubQuery.append("\"query\" : {\n");
        esSubQuery.append("      \"constant_score\" : {\n");
        esSubQuery.append("        \"filter\" : {\n");
        esSubQuery.append("          \"bool\" :{\n");
        boolean subQueryEmpty = true;
        boolean appendCommar = false;
        if (expEsForAdvancedFilter != null) {
            esSubQuery.append("    \"filter\": [\n");
            esSubQuery.append("      {");
            esSubQuery.append("          \"query_string\": {\n");
            esSubQuery.append("            \"query\": \"" + expEsForAdvancedFilter + "\"\n");
            esSubQuery.append("          }\n");
            esSubQuery.append("      }\n");
            esSubQuery.append("    ],\n");
        }
        if (filter.getUserType() != null && !filter.getUserType().isEmpty()) {
            if (filter.getUserType().equals("internal")) {
                esSubQuery.append("    \"should\": [\n");
                esSubQuery.append("                  {\n");
                esSubQuery.append("                    \"term\": {\n");
                esSubQuery.append("                      \"external\": false\n");
                esSubQuery.append("                    }\n");
                esSubQuery.append("                  },\n");
                esSubQuery.append("                  {\n");
                esSubQuery.append("                    \"bool\": {\n");
                esSubQuery.append("                      \"must_not\": {\n");
                esSubQuery.append("                        \"exists\": {\n");
                esSubQuery.append("                          \"field\": \"external\"\n");
                esSubQuery.append("                        }\n");
                esSubQuery.append("                      }\n");
                esSubQuery.append("                    }\n");
                esSubQuery.append("                  }\n");
                esSubQuery.append("                  ]\n");
                subQueryEmpty = false;
                appendCommar = true;
            } else if (filter.getUserType().equals("external")) {
                esSubQuery.append("    \"should\": [\n");
                esSubQuery.append("                  {\n");
                esSubQuery.append("                    \"term\": {\n");
                esSubQuery.append("                      \"external\": true\n");
                esSubQuery.append("                    }\n");
                esSubQuery.append("                  }\n");
                esSubQuery.append("                  ]\n");
                subQueryEmpty = false;
                appendCommar = true;
            }
            esSubQuery.append("                  ,\"minimum_should_match\" : 1\n");
        }
        if (filter.isConnected() != null) {
            esSubQuery.append("    \"should\": [\n");
            esSubQuery.append("                  {\n");
            esSubQuery.append("                    \"bool\": {\n");
            if (filter.isConnected().booleanValue()) {
                esSubQuery.append("                      \"must\": {\n");
            } else {
                esSubQuery.append("                      \"must_not\": {\n");
            }
            esSubQuery.append("                        \"exists\": {\n");
            esSubQuery.append("                          \"field\": \"lastLoginTime\"\n");
            esSubQuery.append("                        }\n");
            esSubQuery.append("                      }\n");
            esSubQuery.append("                    }\n");
            esSubQuery.append("                  }\n");
            esSubQuery.append("                  ]\n");
            esSubQuery.append("                  ,\"minimum_should_match\" : 1\n");
            subQueryEmpty = false;
            appendCommar = true;
        }
        if (filter.getEnrollmentStatus() != null && !filter.getEnrollmentStatus().isEmpty()) {
            switch (filter.getEnrollmentStatus()) {
                case "enrolled": {
                    esSubQuery.append("    \"should\": [\n");
                    esSubQuery.append("                  {\n");
                    esSubQuery.append("                    \"bool\": {\n");
                    esSubQuery.append("                      \"must\": {\n");
                    esSubQuery.append("                        \"exists\": {\n");
                    esSubQuery.append("                          \"field\": \"enrollmentDate\"\n");
                    esSubQuery.append("                        }\n");
                    esSubQuery.append("                      }\n");
                    esSubQuery.append("                    }\n");
                    esSubQuery.append("                  }\n");
                    esSubQuery.append("                  ]\n");
                    esSubQuery.append("                  ,\"minimum_should_match\" : 1\n");
                    subQueryEmpty = false;
                    appendCommar = true;
                    break;
                }
                case "notEnrolled": {
                    esSubQuery.append("    \"should\": [\n");
                    esSubQuery.append("                  {\n");
                    esSubQuery.append("                    \"bool\": {\n");
                    esSubQuery.append("                      \"must_not\": [{\n");
                    esSubQuery.append("                        \"exists\": {\n");
                    esSubQuery.append("                          \"field\": \"enrollmentDate\"\n");
                    esSubQuery.append("                          }\n");
                    esSubQuery.append("                        },\n");
                    esSubQuery.append("                      {\n");
                    esSubQuery.append("                        \"exists\": {\n");
                    esSubQuery.append("                          \"field\": \"lastLoginTime\"\n");
                    esSubQuery.append("                        }\n");
                    esSubQuery.append("                      }],\n");
                    esSubQuery.append("                      \"must\": {\n");
                    esSubQuery.append("                       \"term\": {\n");
                    esSubQuery.append("                         \"external\": false\n");
                    esSubQuery.append("                         }\n");
                    esSubQuery.append("                      }\n");
                    esSubQuery.append("                    }\n");
                    esSubQuery.append("                  }\n");
                    esSubQuery.append("                  ]\n");
                    esSubQuery.append("                  ,\"minimum_should_match\" : 1\n");
                    subQueryEmpty = false;
                    appendCommar = true;
                    break;
                }
                case "noEnrollmentPossible": {
                    esSubQuery.append("    \"should\": [\n");
                    esSubQuery.append("                  {\n");
                    esSubQuery.append("                    \"bool\": {\n");
                    esSubQuery.append("                      \"must_not\": {\n");
                    esSubQuery.append("                        \"exists\": {\n");
                    esSubQuery.append("                          \"field\": \"enrollmentDate\"\n");
                    esSubQuery.append("                          }\n");
                    esSubQuery.append("                        },\n");
                    esSubQuery.append("                      \"must\": {\n");
                    esSubQuery.append("                        \"exists\": {\n");
                    esSubQuery.append("                          \"field\": \"lastLoginTime\"\n");
                    esSubQuery.append("                        }\n");
                    esSubQuery.append("                      }\n");
                    esSubQuery.append("                    }\n");
                    esSubQuery.append("                  },\n");
                    esSubQuery.append("                  {\n");
                    esSubQuery.append("                    \"term\": {\n");
                    esSubQuery.append("                      \"external\": true\n");
                    esSubQuery.append("                    }\n");
                    esSubQuery.append("                  }\n");
                    esSubQuery.append("                  ]\n");
                    esSubQuery.append("                  ,\"minimum_should_match\" : 1\n");
                    subQueryEmpty = false;
                    appendCommar = true;
                    break;
                }
            }
        }
        if (filter.getRemoteIds() != null && !filter.getRemoteIds().isEmpty()) {
            StringBuilder remoteIds = new StringBuilder();
            for (String remoteId : filter.getRemoteIds()) {
                if (remoteIds.length() > 0) {
                    remoteIds.append(",");
                }
                remoteIds.append("\"").append(remoteId).append("\"");
            }
            esSubQuery.append("      \"must\" : {\n");
            esSubQuery.append("        \"terms\" :{\n");
            esSubQuery.append("          \"userName\" : [" + remoteIds.toString() + "]\n");
            esSubQuery.append("        } \n");
            esSubQuery.append("      },\n");
            subQueryEmpty = false;
        }
        if (identity != null && type != null) {
            esSubQuery.append("      \"must\" : {\n");
            esSubQuery.append("        \"query_string\" : {\n");
            esSubQuery.append("          \"query\" : \"" + identity.getId() + "\",\n");
            esSubQuery.append("          \"fields\" : [\"" + this.buildTypeEx(type) + "\"]\n");
            esSubQuery.append("        }\n");
            esSubQuery.append("      }\n");
            subQueryEmpty = false;
            appendCommar = true;
        } else if (filter.getExcludedIdentityList() != null && filter.getExcludedIdentityList().size() > 0) {
            esSubQuery.append("      \"must_not\": [\n");
            esSubQuery.append("        {\n");
            esSubQuery.append("          \"ids\" : {\n");
            esSubQuery.append("             \"values\" : [" + this.buildExcludedIdentities(filter) + "]\n");
            esSubQuery.append("          }\n");
            esSubQuery.append("        }\n");
            esSubQuery.append("      ]\n");
            subQueryEmpty = false;
            appendCommar = true;
        }
        if (expEs != null && expEs.length() > 0) {
            if (appendCommar) {
                esSubQuery.append("      ,\n");
            }
            esSubQuery.append("    \"filter\": [\n");
            esSubQuery.append("      {");
            esSubQuery.append("          \"query_string\": {\n");
            if (filter.getName().startsWith("\"") && filter.getName().endsWith("\"")) {
                esSubQuery.append("            \"query\": \"" + expEs + "\",\n");
                esSubQuery.append("            \"default_operator\": \"AND\"\n");
            } else {
                esSubQuery.append("            \"query\": \"" + expEs + "\"\n");
            }
            esSubQuery.append("          }\n");
            esSubQuery.append("      }\n");
            esSubQuery.append("    ]\n");
            subQueryEmpty = false;
        }
        esSubQuery.append("     } \n");
        esSubQuery.append("   } \n");
        esSubQuery.append("  }\n");
        esSubQuery.append(" }\n");
        if (!subQueryEmpty) {
            esQuery.append((CharSequence)esSubQuery);
        }
        esQuery.append("}\n");
        LOG.debug("Search Query request to ES : {} ", new Object[]{esQuery});
        return esQuery.toString();
    }

    private String buildExcludedIdentities(ProfileFilter filter) {
        StringBuilder typeExp = new StringBuilder();
        if (filter.getExcludedIdentityList() != null && filter.getExcludedIdentityList().size() > 0) {
            Iterator iter = filter.getExcludedIdentityList().iterator();
            Identity first = (Identity)iter.next();
            typeExp.append("\"").append(first.getId()).append("\"");
            if (!iter.hasNext()) {
                return typeExp.toString();
            }
            while (iter.hasNext()) {
                Identity next = (Identity)iter.next();
                typeExp.append(",\"").append(next.getId()).append("\"");
            }
        }
        return typeExp.toString();
    }

    private String buildTypeEx(Relationship.Type type) {
        return switch (type) {
            case Relationship.Type.CONFIRMED -> "connections";
            case Relationship.Type.INCOMING -> "outgoings";
            case Relationship.Type.OUTGOING -> "incomings";
            default -> throw new IllegalArgumentException("Type [" + type + "] not supported");
        };
    }

    private String buildExpression(ProfileFilter filter) {
        String inputName;
        StringBuilder esExp = new StringBuilder();
        char firstChar = filter.getFirstCharacterOfName();
        if (firstChar != '\u0000') {
            String filterField = "name";
            if (filter.getFirstCharFieldName() != null) {
                switch (Sorting.SortBy.valueOf((String)filter.getFirstCharFieldName().toUpperCase())) {
                    case FIRSTNAME: {
                        filterField = "firstName";
                        break;
                    }
                    case LASTNAME: {
                        filterField = "lastName";
                        break;
                    }
                    default: {
                        filterField = "name";
                    }
                }
            }
            esExp.append(filterField).append(".whitespace:").append(firstChar).append("*");
            return esExp.toString();
        }
        String string = inputName = StringUtils.isBlank((String)filter.getName()) ? null : filter.getName().replace("*", "");
        if (StringUtils.isNotBlank(inputName)) {
            String newInputName = null;
            String[] keys = new String[]{};
            if (inputName.startsWith("\"") && inputName.endsWith("\"")) {
                newInputName = inputName.replace("\"", "");
            } else {
                keys = inputName.split(" ");
            }
            if (keys.length > 1) {
                esExp.append("(");
                for (int i = 0; i < keys.length; ++i) {
                    if (i != 0) {
                        esExp.append(" AND ");
                    }
                    esExp.append(" name.whitespace:").append("*").append(ProfileSearchConnector.removeAccents(keys[i])).append("*");
                }
                esExp.append(")");
            } else if (StringUtils.isNotBlank((String)newInputName)) {
                esExp.append("name:").append(ProfileSearchConnector.removeAccents(newInputName));
            } else {
                esExp.append("( name.whitespace:").append("*").append(ProfileSearchConnector.removeAccents(inputName)).append("*");
                esExp.append(")");
            }
        }
        return esExp.toString();
    }

    private String buildAdvancedFilterExpression(ProfileFilter filter) {
        StringBuilder esExp = new StringBuilder();
        esExp.append("( ");
        Map settings = filter.getProfileSettings();
        int settingsCount = 0;
        for (Map.Entry entry : settings.entrySet()) {
            String[] splittedValue;
            String inputValue = ((String)entry.getValue()).replace("*", "");
            if (inputValue.startsWith("\"") && inputValue.endsWith("\"")) {
                inputValue = inputValue.replace("\"", "");
            }
            if ((splittedValue = inputValue.split(" ")).length > 1) {
                esExp.append("(");
                for (int i = 0; i < splittedValue.length; ++i) {
                    if (i != 0) {
                        esExp.append(" AND ");
                    }
                    esExp.append((String)entry.getKey() + ":").append("*").append(ProfileSearchConnector.removeAccents(splittedValue[i])).append("*");
                }
                esExp.append(")");
            } else {
                esExp.append("( " + (String)entry.getKey() + ":").append("*").append(ProfileSearchConnector.removeAccents(inputValue)).append("*");
                esExp.append(")");
            }
            if (settingsCount != settings.size() - 1) {
                esExp.append(" AND ");
            }
            ++settingsCount;
        }
        esExp.append(" )");
        return esExp.toString();
    }

    private static String removeAccents(String string) {
        string = Normalizer.normalize(string, Normalizer.Form.NFD);
        string = string.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        return string;
    }
}

