/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.upgrade;

import java.util.List;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityType;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RuleIndexingUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(RuleIndexingUpgradePlugin.class);
    private static final int PAGE_COUNT = 20;
    private IndexingService indexingService;
    private RuleService ruleService;
    private int indexedRulesCount;
    private int errorIndexingCount;
    private int rulesCount;

    public RuleIndexingUpgradePlugin(SettingService settingService, IndexingService indexingService, RuleService ruleService, InitParams params) {
        super(settingService, params);
        this.indexingService = indexingService;
        this.ruleService = ruleService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        this.rulesCount = this.ruleService.countAllRules(null);
        LOG.info("START::Index '{}' Gamification rules", new Object[]{this.rulesCount});
        long startTime = System.currentTimeMillis();
        for (int offset = 0; offset < this.rulesCount; offset += 20) {
            List<RuleDTO> rules = this.ruleService.findAllRules(offset, 20);
            for (RuleDTO rule : rules) {
                if (!rule.isDeleted() && (rule.isEnabled() || EntityType.MANUAL == rule.getType())) {
                    long ruleId = rule.getId();
                    try {
                        this.indexingService.reindex("rules", String.valueOf(ruleId));
                        ++this.indexedRulesCount;
                    }
                    catch (Exception e) {
                        LOG.warn("Error while reindexing rule with id {}", new Object[]{ruleId, e});
                        ++this.errorIndexingCount;
                    }
                }
                if ((this.indexedRulesCount + this.errorIndexingCount) % 10 != 0) continue;
                LOG.info("PROGRESS::Index '{}/{}' gamification rules processed.", new Object[]{this.indexedRulesCount, this.rulesCount});
            }
        }
        if (this.errorIndexingCount > 0) {
            long diff = System.currentTimeMillis() - startTime;
            throw new IllegalStateException("END::Index '" + this.indexedRulesCount + "/" + this.rulesCount + "' gamification rules indexed successfully with '" + this.errorIndexingCount + "/" + this.rulesCount + "' rules idnexing failed. The operation took " + diff + " milliseconds.It will be re-attempted next startup");
        }
        LOG.info("END::Index '{}/{}' gamification rules indexed successfully. The operation took {} milliseconds.", new Object[]{this.indexedRulesCount, this.rulesCount, System.currentTimeMillis() - startTime});
    }

    public int getIndexedRulesCount() {
        return this.indexedRulesCount;
    }

    public int getErrorIndexingCount() {
        return this.errorIndexingCount;
    }

    public int getRulesCount() {
        return this.rulesCount;
    }
}

