/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.rules.annotation.Rule;
import com.datical.liquibase.ext.rules.api.Fact;
import com.datical.liquibase.ext.rules.api.FactEnum;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.api.LiquibaseRule;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import com.datical.liquibase.ext.rules.core.RuleIteration$FailureReason;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import liquibase.changelog.ChangeSet;
import liquibase.util.StringUtil;

@Rule
public abstract class AbstractLiquibaseRule
implements LiquibaseRule {
    private final UUID id = UUID.nameUUIDFromBytes(StringUtil.getBytesWithEncoding(this.getClass().getName()));
    private SeverityEnum severity;
    private LiquibaseRuleResult result = new LiquibaseRuleResult(this);
    public static final int MAX_SHORT_NAME_LENGTH = 64;

    @Override
    public final UUID getId() {
        return this.id;
    }

    @Override
    public SeverityEnum getSeverity() {
        return this.severity;
    }

    @Override
    public void setSeverity(SeverityEnum severityEnum) {
        this.severity = severityEnum;
    }

    @Override
    public LiquibaseRuleResult getResult() {
        return this.result;
    }

    public boolean setResult(LiquibaseRuleResult liquibaseRuleResult) {
        Objects.requireNonNull(liquibaseRuleResult);
        this.result = liquibaseRuleResult;
        return !this.result.hasRuleSucceeded();
    }

    @Override
    public List<String> getSupportedChangelogFormats() {
        return Arrays.asList("sql", "xml", "yaml", "json");
    }

    public boolean setResultSuccessful(boolean bl2, DynamicRule dynamicRule) {
        if (bl2) {
            return this.setResult(new LiquibaseRuleResult(this, dynamicRule, new RuleIteration(true)));
        }
        return this.setResult(new LiquibaseRuleResult(this));
    }

    public boolean setResultUnsuccessful(String string, DynamicRule dynamicRule) {
        return this.setResult(new LiquibaseRuleResult(this, dynamicRule, new RuleIteration(false, string)));
    }

    public void addFailureRuleIteration(String string, DynamicRule dynamicRule) {
        if (this.result == null) {
            this.setResultUnsuccessful(string, dynamicRule);
            return;
        }
        this.result.getExecutions().add(new RuleIteration(false, string));
    }

    public void addFailureRuleIteration(String string, RuleIteration$FailureReason ruleIteration$FailureReason, DynamicRule dynamicRule) {
        if (this.result == null) {
            this.setResultUnsuccessful(string, ruleIteration$FailureReason, dynamicRule);
            return;
        }
        this.result.getExecutions().add(new RuleIteration(ruleIteration$FailureReason, string));
    }

    public boolean returnAtEndOfRule(DynamicRule dynamicRule) {
        if (this.getResult().hasRuleSucceeded()) {
            return this.setResultSuccessful(true, dynamicRule);
        }
        return !this.getResult().hasRuleSucceeded();
    }

    public boolean setResultUnsuccessful(String string, RuleIteration$FailureReason ruleIteration$FailureReason, DynamicRule dynamicRule) {
        return this.setResult(new LiquibaseRuleResult(this, dynamicRule, new RuleIteration(ruleIteration$FailureReason, string)));
    }

    @Override
    public String getName() {
        return StringUtil.upperCaseFirst(StringUtil.join(StringUtil.splitCamelCase(this.getClass().getSimpleName()), " ").toLowerCase());
    }

    @Override
    public abstract String getDescription();

    public abstract String getShortName();

    @Override
    public abstract int getPriority();

    public abstract List<RuleParameter<?>> getParameters();

    public String prettyPrintParameters() {
        if (this.isConfigurable()) {
            return StringUtil.join(this.getParameters().stream().map(ruleParameter -> ruleParameter.toString() + " = " + ruleParameter.getDefaultValue()).collect(Collectors.toList()), System.lineSeparator());
        }
        return "<None>";
    }

    public boolean isConfigurable() {
        return this.getParameters() != null && !this.getParameters().isEmpty();
    }

    @Override
    public void execute(Facts facts) {
    }

    public String generateErrorMessage(String string) {
        Objects.requireNonNull(string);
        return "Change Set " + string.trim();
    }

    public ChangeSet getChangeSetFromFacts(Facts object) {
        if (object == null) {
            return null;
        }
        if ((object = ((Facts)object).getFact(FactEnum.CHANGESET.toString())) != null) {
            return (ChangeSet)((Fact)object).getValue();
        }
        return null;
    }

    public boolean shouldBeEvaluated(ChangeSet changeSet) {
        return true;
    }

    public AbstractConfigurableRule getAbstractConfigurableRuleFromFacts(Facts object) {
        if (object == null) {
            return null;
        }
        object = ((Facts)object).getFact(FactEnum.INSTANCE_SETTINGS.toString());
        Objects.requireNonNull(object);
        return (AbstractConfigurableRule)((Fact)object).getValue();
    }

    public final boolean hasDefaultParameterValues() {
        if (this.getParameters() != null) {
            Iterator<RuleParameter<?>> iterator = this.getParameters().iterator();
            while (iterator.hasNext()) {
                if (iterator.next().getDefaultValue() != null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(com.datical.liquibase.ext.rules.api.Rule rule) {
        if (this.getPriority() < rule.getPriority()) {
            return -1;
        }
        if (this.getPriority() > rule.getPriority()) {
            return 1;
        }
        return this.getName().compareTo(rule.getName());
    }
}

