/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.IdentityType;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.rest.model.GamificationInformationRestEntity;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.addons.gamification.service.mapper.DomainMapper;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

@Path(value="/gamification/gameficationinformationsboard")
@Produces(value={"application/json"})
@RolesAllowed(value={"users"})
public class GamificationInformationsEndpoint
implements ResourceContainer {
    protected IdentityManager identityManager = null;
    protected GamificationService gamificationService = null;
    protected SpaceService spaceService;

    public GamificationInformationsEndpoint(IdentityManager identityManager, SpaceService spaceService, GamificationService gamificationService) {
        this.identityManager = identityManager;
        this.gamificationService = gamificationService;
        this.spaceService = spaceService;
    }

    @GET
    @Path(value="history/all")
    @RolesAllowed(value={"users"})
    public Response getAllLeadersByRank(@Context UriInfo uriInfo, @QueryParam(value="capacity") String capacity, @QueryParam(value="providerId") String providerId, @QueryParam(value="remoteId") String remoteId) {
        List<GamificationActionsHistory> ss;
        boolean canShowDetails;
        if (StringUtils.isBlank((CharSequence)providerId)) {
            return Response.status((int)400).entity((Object)"identity 'providerId' parameter is mandatory").build();
        }
        if (StringUtils.isBlank((CharSequence)remoteId)) {
            return Response.status((int)400).entity((Object)"identity 'remoteId' parameter is mandatory").build();
        }
        providerId = IdentityType.getType(providerId).getProviderId();
        boolean isManager = Utils.isSuperManager(remoteId);
        boolean bl = canShowDetails = isManager || this.isCurrentUser(providerId, remoteId);
        if ("space".equals(providerId)) {
            boolean isSpaceMember;
            Space space = this.spaceService.getSpaceByPrettyName(remoteId);
            if (space == null) {
                return Response.status((int)404).entity((Object)("Space with pretty name '" + remoteId + "'")).build();
            }
            String currentUsername = this.getCurrentUsername();
            boolean bl2 = isSpaceMember = this.spaceService.isMember(space, currentUsername) || this.spaceService.isSuperManager(currentUsername);
            if (!isSpaceMember) {
                return Response.status((int)403).build();
            }
        }
        ArrayList<GamificationInformationRestEntity> gamificationInformationRestEntities = new ArrayList<GamificationInformationRestEntity>();
        Identity earnerIdentity = this.identityManager.getOrCreateIdentity(providerId, remoteId);
        int loadCapacity = 10;
        if (StringUtils.isNotBlank((CharSequence)capacity)) {
            loadCapacity = Integer.parseInt(capacity);
        }
        if ((ss = this.gamificationService.findActionsHistoryByEarnerId(earnerIdentity.getId(), loadCapacity)) == null || ss.isEmpty()) {
            return Response.ok(gamificationInformationRestEntities, (String)"application/json").build();
        }
        for (GamificationActionsHistory element : ss) {
            Identity receiverIdentity = this.identityManager.getIdentity(element.getReceiver());
            Profile profile = receiverIdentity.getProfile();
            GamificationInformationRestEntity gamificationInformationRestEntity = new GamificationInformationRestEntity();
            gamificationInformationRestEntity.setSocialId(receiverIdentity.getId());
            gamificationInformationRestEntity.setSpace(StringUtils.equals((CharSequence)receiverIdentity.getProviderId(), (CharSequence)"space"));
            gamificationInformationRestEntity.setReceiver(element.getReceiver());
            gamificationInformationRestEntity.setRemoteId(receiverIdentity.getRemoteId());
            gamificationInformationRestEntity.setFullname(profile.getFullName());
            gamificationInformationRestEntity.setAvatarUrl(profile.getAvatarUrl());
            gamificationInformationRestEntity.setProfileUrl(profile.getUrl());
            gamificationInformationRestEntity.setActionScore(element.getActionScore());
            gamificationInformationRestEntity.setActionTitle(element.getActionTitle());
            gamificationInformationRestEntity.setContext(element.getContext());
            gamificationInformationRestEntity.setCreatedDate(element.getCreatedDate().toGMTString());
            gamificationInformationRestEntity.setDomainDTO(DomainMapper.domainEntityToDomainDTO(element.getDomainEntity()));
            gamificationInformationRestEntity.setGlobalScore(element.getGlobalScore());
            if (canShowDetails) {
                if (element.getActivityId() != null && element.getActivityId() != 0L) {
                    gamificationInformationRestEntity.setObjectId("/" + LinkProvider.getPortalName((String)"") + "/" + LinkProvider.getPortalOwner((String)"") + "/activity?id=" + element.getActivityId());
                } else {
                    gamificationInformationRestEntity.setObjectId(element.getObjectId());
                }
            }
            gamificationInformationRestEntities.add(gamificationInformationRestEntity);
        }
        return Response.ok(gamificationInformationRestEntities, (String)"application/json").build();
    }

    private boolean isCurrentUser(String providerId, String remoteId) {
        return "organization".equals(providerId) && StringUtils.equals((CharSequence)this.getCurrentUsername(), (CharSequence)remoteId);
    }

    private String getCurrentUsername() {
        return ConversationState.getCurrent().getIdentity().getUserId();
    }
}

