/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.security.oauth.registry.OauthProviderTypeRegistryPlugin;
import org.gatein.security.oauth.spi.AccessTokenContext;
import org.gatein.security.oauth.spi.OAuthProviderType;
import org.gatein.security.oauth.spi.OAuthProviderTypeRegistry;

public class OAuthProviderTypeRegistryImpl
implements OAuthProviderTypeRegistry {
    private final Map<String, OAuthProviderType> oauthProviderTypes = new LinkedHashMap<String, OAuthProviderType>();
    private static final Log log = ExoLogger.getLogger(OAuthProviderTypeRegistryImpl.class);

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof OauthProviderTypeRegistryPlugin) {
            OauthProviderTypeRegistryPlugin oauthPlugin = (OauthProviderTypeRegistryPlugin)plugin;
            OAuthProviderType oauthPrType = oauthPlugin.getOAuthProviderType();
            if (oauthPrType != null && oauthPrType.isEnabled()) {
                this.oauthProviderTypes.put(oauthPrType.getKey(), oauthPrType);
                log.debug((Object)("Added new OAuthProviderType " + oauthPrType));
            } else {
                log.debug((Object)("Skip OAuthProviderType " + oauthPrType + " because it's disabled"));
            }
        } else {
            throw new RuntimeException("Invalid plugin type: " + plugin.getClass() + ", plugin: " + plugin);
        }
    }

    @Override
    public <T extends AccessTokenContext> OAuthProviderType<T> getOAuthProvider(String key, Class<T> accessTokenContextClass) {
        return this.oauthProviderTypes.get(key);
    }

    @Override
    public Collection<OAuthProviderType> getEnabledOAuthProviders() {
        return Collections.unmodifiableCollection(this.oauthProviderTypes.values());
    }

    @Override
    public boolean isOAuthEnabled() {
        return !this.oauthProviderTypes.isEmpty();
    }
}

