/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.portlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderResponse;
import juzu.PropertyType;
import juzu.Response;
import juzu.impl.asset.Asset;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.portlet.PortletRequestBridge;
import juzu.impl.common.Formatting;
import juzu.impl.common.Tools;
import juzu.impl.plugin.asset.AssetService;
import juzu.impl.request.ContextualParameter;
import juzu.io.Chunk;
import juzu.io.Stream;
import juzu.request.Phase;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class PortletMimeBridge<Rq extends PortletRequest, Rs extends MimeResponse>
extends PortletRequestBridge<Rq, Rs> {
    PortletMimeBridge(Bridge bridge, Phase phase, Rq request, Rs response, PortletConfig config) {
        super(bridge, phase, request, response, config);
    }

    public abstract Stream createStream(String var1, Charset var2) throws IOException;

    @Override
    public Map<ContextualParameter, Object> getContextualArguments(Set<ContextualParameter> parameters) {
        return Collections.emptyMap();
    }

    @Override
    public void send() throws IOException, PortletException {
        if (this.response instanceof Response.Status) {
            Response.Status status = (Response.Status)this.response;
            final AssetService assetPlugin = (AssetService)this.bridge.getApplication().getPlugin("asset");
            Stream stream = new Stream(){
                private Charset charset = Tools.UTF_8;
                private String mimeType = null;
                private Stream dataStream = null;
                private final LinkedList<String> assets = new LinkedList();

                @Override
                public void provide(Chunk chunk) {
                    if (chunk instanceof Chunk.Property) {
                        Chunk.Property property = (Chunk.Property)chunk;
                        if (property.type == PropertyType.ENCODING) {
                            this.charset = (Charset)property.value;
                        } else if (property.type == PropertyType.MIME_TYPE) {
                            this.mimeType = (String)property.value;
                        } else if (property.type == PropertyType.HEADER) {
                            Map.Entry header = (Map.Entry)property.value;
                            for (String value : (String[])header.getValue()) {
                                ((MimeResponse)PortletMimeBridge.this.resp).addProperty((String)header.getKey(), value);
                            }
                        }
                        if (property.type == PropertyType.TITLE) {
                            if (PortletMimeBridge.this.resp instanceof RenderResponse) {
                                ((RenderResponse)PortletMimeBridge.this.resp).setTitle((String)property.value);
                            }
                        } else if (property.type == PropertyType.META_TAG) {
                            Map.Entry metaTag = (Map.Entry)property.value;
                            Element elt = ((MimeResponse)PortletMimeBridge.this.resp).createElement("meta");
                            elt.setAttribute("name", (String)metaTag.getKey());
                            elt.setAttribute("content", (String)metaTag.getValue());
                            ((MimeResponse)PortletMimeBridge.this.resp).addProperty("javax.portlet.markup.head.element", elt);
                        } else if (property.type == PropertyType.ASSET) {
                            this.assets.add((String)property.value);
                        } else if (property.type == PropertyType.HEADER_TAG) {
                            Element headerTag = (Element)property.value;
                            Element responseTag = ((MimeResponse)PortletMimeBridge.this.resp).createElement(headerTag.getTagName());
                            for (Node child : Tools.children(headerTag)) {
                                child = responseTag.getOwnerDocument().importNode(headerTag, true);
                                responseTag.appendChild(child);
                            }
                            ((MimeResponse)PortletMimeBridge.this.resp).addProperty("javax.portlet.markup.head.element", headerTag);
                        }
                    } else if (chunk instanceof Chunk.Data) {
                        Chunk.Data data = (Chunk.Data)chunk;
                        if (this.dataStream == null) {
                            Iterable<Asset> resolvedAssets = assetPlugin.getAssetManager().resolveAssets(this.assets);
                            for (Asset resolvedAsset : resolvedAssets) {
                                Element elt;
                                if (resolvedAsset.isStylesheet()) {
                                    int pos = resolvedAsset.getURI().lastIndexOf(46);
                                    String ext = pos == -1 ? "css" : resolvedAsset.getURI().substring(pos + 1);
                                    elt = ((MimeResponse)PortletMimeBridge.this.resp).createElement("link");
                                    elt.setAttribute("media", "screen");
                                    elt.setAttribute("rel", "stylesheet");
                                    elt.setAttribute("type", "text/" + ext);
                                    elt.setAttribute("href", PortletMimeBridge.this.getAssetURL(resolvedAsset));
                                } else if (resolvedAsset.isScript()) {
                                    String url = PortletMimeBridge.this.getAssetURL(resolvedAsset);
                                    elt = ((MimeResponse)PortletMimeBridge.this.resp).createElement("script");
                                    elt.setAttribute("type", "text/javascript");
                                    elt.setAttribute("src", url);
                                    String dummy = PortletMimeBridge.this.bridge.getApplication().getName() + " script ";
                                    Comment comment = elt.getOwnerDocument().createComment(dummy);
                                    elt.appendChild(comment);
                                } else {
                                    elt = null;
                                }
                                if (elt == null) continue;
                                ((MimeResponse)PortletMimeBridge.this.resp).addProperty("javax.portlet.markup.head.element", elt);
                            }
                            try {
                                this.dataStream = PortletMimeBridge.this.createStream(this.mimeType, this.charset);
                            }
                            catch (IOException e) {
                                throw new UnsupportedOperationException("Handle me gracefully");
                            }
                        }
                        this.dataStream.provide(data);
                    }
                }

                @Override
                public void close(Thread.UncaughtExceptionHandler errorHandler) {
                }
            };
            if (status.getCode() != 200) {
                ((MimeResponse)this.resp).addProperty("portlet.http-status-code", Integer.toString(status.getCode()));
            }
            status.streamable().send(stream);
        } else if (this.response instanceof Response.Error) {
            Response.Error error = (Response.Error)this.response;
            if (this.bridge.getRunMode().getPrettyFail()) {
                ((MimeResponse)this.resp).setContentType("text/html");
                PrintWriter writer = ((MimeResponse)this.resp).getWriter();
                writer.append("<div class=\"juzu\">");
                Throwable cause = error.getCause();
                if (cause != null) {
                    Formatting.renderThrowable(null, writer, cause);
                } else {
                    writer.append(error.getMessage());
                }
                writer.append("</div>");
                writer.close();
                ((MimeResponse)this.resp).addProperty("portlet.http-status-code", "500");
            } else {
                throw new PortletException(error.getCause());
            }
        }
    }
}

