/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.externalstore;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.externalstore.IDMExternalStoreService;
import org.exoplatform.services.organization.externalstore.IDMQueueService;
import org.exoplatform.services.organization.externalstore.job.IDMEntitiesDeleteJob;
import org.exoplatform.services.organization.externalstore.job.IDMEntitiesImportJob;
import org.exoplatform.services.organization.externalstore.job.IDMQueueProcessorJob;
import org.exoplatform.services.organization.externalstore.model.IDMEntityType;
import org.exoplatform.services.organization.externalstore.model.IDMOperationType;
import org.exoplatform.services.organization.externalstore.model.IDMQueueEntry;
import org.exoplatform.services.organization.impl.UserImpl;
import org.exoplatform.services.scheduler.CronJob;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.picocontainer.Startable;

public class IDMExternalStoreImportService
implements Startable {
    public static final Log LOG = ExoLogger.getLogger(IDMExternalStoreImportService.class);
    public static final String EXTERNAL_STORE_IMPORT_CRON_EXPRESSION = "exo.idm.externalStore.import.cronExpression";
    public static final String EXTERNAL_STORE_DELETE_CRON_EXPRESSION = "exo.idm.externalStore.delete.cronExpression";
    public static final String IDM_QUEUE_PROCESSING_CRON_EXPRESSION = "exo.idm.externalStore.queue.processing.cronExpression";
    public static final String EXTERNAL_STORE_DELETE_MISSING_ENTRIES = "exo.idm.externalStore.entries.missing.delete";
    private ExoContainer container;
    private OrganizationService organizationService;
    private ListenerService listenerService;
    private IDMQueueService idmQueueService;
    private IDMExternalStoreService externalStoreService;
    private JobSchedulerService jobSchedulerService;
    private String scheduledDataImportJobCronExpression = null;
    private String scheduledDataDeleteJobCronExpression = null;
    private boolean deleteMissingEntriesFromInternalStore = true;
    private String scheduledQueueProcessingJobCronExpression = null;
    private boolean interrupted;

    public IDMExternalStoreImportService(ExoContainer container, OrganizationService organizationService, ListenerService listenerService, IDMExternalStoreService externalStoreService, JobSchedulerService jobSchedulerService, IDMQueueService idmQueueService, InitParams params) {
        this.container = container;
        this.organizationService = organizationService;
        this.listenerService = listenerService;
        this.idmQueueService = idmQueueService;
        this.externalStoreService = externalStoreService;
        this.jobSchedulerService = jobSchedulerService;
        if (params != null) {
            if (params.containsKey((Object)EXTERNAL_STORE_IMPORT_CRON_EXPRESSION)) {
                this.scheduledDataImportJobCronExpression = params.getValueParam(EXTERNAL_STORE_IMPORT_CRON_EXPRESSION).getValue();
            }
            if (params.containsKey((Object)EXTERNAL_STORE_DELETE_MISSING_ENTRIES)) {
                this.deleteMissingEntriesFromInternalStore = Boolean.parseBoolean(params.getValueParam(EXTERNAL_STORE_IMPORT_CRON_EXPRESSION).getValue());
            }
            if (StringUtils.isBlank((String)this.scheduledDataImportJobCronExpression)) {
                LOG.warn((Object)"No scheduled job will be added to periodically import IDM data from external store");
            }
            if (params.containsKey((Object)EXTERNAL_STORE_DELETE_CRON_EXPRESSION)) {
                this.scheduledDataDeleteJobCronExpression = params.getValueParam(EXTERNAL_STORE_DELETE_CRON_EXPRESSION).getValue();
            }
            if (StringUtils.isBlank((String)this.scheduledDataDeleteJobCronExpression)) {
                LOG.warn((Object)"No scheduled job will be added to periodically delete IDM data from internal store");
            }
            if (params.containsKey((Object)IDM_QUEUE_PROCESSING_CRON_EXPRESSION)) {
                this.scheduledQueueProcessingJobCronExpression = params.getValueParam(IDM_QUEUE_PROCESSING_CRON_EXPRESSION).getValue();
            }
            if (StringUtils.isBlank((String)this.scheduledQueueProcessingJobCronExpression)) {
                LOG.warn((Object)"No scheduled job will be added to periodically process IDM Queue");
            }
        }
    }

    public void start() {
        if (!this.externalStoreService.isEnabled()) {
            return;
        }
        RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
        try {
            int queueEntriesInError = this.idmQueueService.count(this.idmQueueService.getMaxRetries());
            if (queueEntriesInError > 0) {
                LOG.warn("'{}' queue entries has exceeded max IDM Queue entry retry. Those queue items will remain on database. Pleaase check using JMX.", new Object[]{queueEntriesInError});
            }
            this.initializeDataImportScheduledJob();
            this.initializeDataDeleteScheduledJob();
            this.initializeQueueProcessingScheduledJob();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while configuring external store", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void stop() {
    }

    public synchronized void importAllModifiedEntitiesToQueue() throws Exception {
        this.checkModifiedEntitiesOfType(IDMEntityType.USER, this.getUserModificationConsumer(), true);
        this.checkModifiedEntitiesOfType(IDMEntityType.GROUP, this.getGroupModificationConsumer(), true);
        this.checkModifiedEntitiesOfType(IDMEntityType.ROLE, this.getRoleModificationConsumer(), true);
    }

    public <T> void forceUpdateEntitiesOfType(IDMEntityType<T> entityType) {
        if (entityType == null) {
            throw new IllegalArgumentException("entityType is mandatory");
        }
        Set<IDMEntityType<?>> managedEntityTypes = this.externalStoreService.getManagedEntityTypes();
        if (!managedEntityTypes.contains(entityType)) {
            throw new IllegalArgumentException("entityType " + entityType.toString() + " is not managed by external store");
        }
        if (entityType.equals(IDMEntityType.USER)) {
            try {
                this.checkModifiedEntitiesOfType(IDMEntityType.USER, this.getUserModificationConsumer(), null);
            }
            catch (Exception e) {
                LOG.warn((Object)"An error occurred while importing users from external store", (Throwable)e);
            }
        } else if (entityType.equals(IDMEntityType.GROUP)) {
            try {
                this.checkModifiedEntitiesOfType(IDMEntityType.GROUP, this.getGroupModificationConsumer(), null);
            }
            catch (Exception e) {
                LOG.warn((Object)"An error occurred while importing groups from external store", (Throwable)e);
            }
        } else if (entityType.equals(IDMEntityType.ROLE)) {
            try {
                this.checkModifiedEntitiesOfType(IDMEntityType.ROLE, this.getRoleModificationConsumer(), null);
            }
            catch (Exception e) {
                LOG.warn((Object)"An error occurred while importing roles from external store", (Throwable)e);
            }
        }
    }

    public void importModifiedEntitiesOfTypeToQueue(IDMEntityType<?> entityType) throws Exception {
        if (entityType == null) {
            throw new IllegalArgumentException("entityType is mandatory");
        }
        if (entityType.equals(IDMEntityType.USER)) {
            this.checkModifiedEntitiesOfType(IDMEntityType.USER, this.getUserModificationConsumer(), true);
        } else if (entityType.equals(IDMEntityType.GROUP)) {
            this.checkModifiedEntitiesOfType(IDMEntityType.GROUP, this.getGroupModificationConsumer(), true);
        } else if (entityType.equals(IDMEntityType.ROLE)) {
            this.checkModifiedEntitiesOfType(IDMEntityType.ROLE, this.getRoleModificationConsumer(), true);
        }
    }

    public synchronized <T> void checkModifiedEntitiesOfType(IDMEntityType<T> entityType, Consumer<String> modificationConsumer, boolean updateLastCheckedTime) throws Exception {
        if (entityType == null) {
            throw new IllegalArgumentException("entityType is mandatory");
        }
        if (modificationConsumer == null) {
            throw new IllegalArgumentException("modificationConsumer is mandatory");
        }
        if (!this.externalStoreService.getManagedEntityTypes().contains(entityType)) {
            LOG.trace((Object)("Entity type " + entityType.getClassType().getName() + " is not managed by IDMExternalStoreService, check modified entities of this type will not proceed"));
            return;
        }
        LocalDateTime localDateTime = this.getLocalDateTime();
        LocalDateTime lastSuccessExecutionTime = this.idmQueueService.getLastCheckedTime(entityType);
        if (lastSuccessExecutionTime != null) {
            lastSuccessExecutionTime = lastSuccessExecutionTime.minusSeconds(1L);
        }
        this.checkModifiedEntitiesOfType(entityType, modificationConsumer, lastSuccessExecutionTime);
        if (updateLastCheckedTime) {
            this.idmQueueService.setLastCheckedTime(entityType, localDateTime);
        }
    }

    public synchronized <T> void checkModifiedEntitiesOfType(IDMEntityType<T> entityType, Consumer<String> modificationConsumer, LocalDateTime lastSuccessExecutionTime) throws Exception {
        block9: {
            String[] membershipTypes;
            block10: {
                String[] groupIds;
                block8: {
                    if (entityType == null) {
                        throw new IllegalArgumentException("entityType is mandatory");
                    }
                    if (modificationConsumer == null) {
                        throw new IllegalArgumentException("modificationConsumer is mandatory");
                    }
                    if (!this.externalStoreService.getManagedEntityTypes().contains(entityType)) {
                        LOG.trace((Object)("Entity type " + entityType.getClassType().getName() + " is not managed by IDMExternalStoreService, check modified entities of this type will not proceed"));
                        return;
                    }
                    if (!IDMEntityType.USER.equals(entityType)) break block8;
                    this.loadModifiedUsers(entityType, modificationConsumer, lastSuccessExecutionTime);
                    break block9;
                }
                if (!IDMEntityType.GROUP.equals(entityType)) break block10;
                ListAccess<String> modifiedOrAddedGroups = this.externalStoreService.getAllOfType(IDMEntityType.GROUP, lastSuccessExecutionTime);
                if (modifiedOrAddedGroups == null) {
                    return;
                }
                for (String groupId : groupIds = (String[])modifiedOrAddedGroups.load(0, Integer.MAX_VALUE)) {
                    if (this.interrupted) {
                        throw new InterruptedException("Import of modified users check is interrupted, it will be retried next startup");
                    }
                    modificationConsumer.accept(groupId);
                }
                break block9;
            }
            if (!IDMEntityType.ROLE.equals(entityType)) break block9;
            ListAccess<String> modifiedOrAddedRoles = this.externalStoreService.getAllOfType(IDMEntityType.ROLE, lastSuccessExecutionTime);
            for (String membershipType : membershipTypes = (String[])modifiedOrAddedRoles.load(0, Integer.MAX_VALUE)) {
                if (this.interrupted) {
                    throw new InterruptedException("Import of modified users check is interrupted, it will be retried next startup");
                }
                modificationConsumer.accept(membershipType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processQueueEntries() {
        try {
            for (int i = this.idmQueueService.getMaxRetries() - 1; i >= 0; --i) {
                int countAllEntitiesToImport;
                int countEntitiesToImport = countAllEntitiesToImport = this.idmQueueService.count(i);
                while (countEntitiesToImport > 0) {
                    int numberOfTransactionLevels = this.forceCloseTransaction();
                    try {
                        RequestLifeCycle.begin((ExoContainer)this.container);
                        try {
                            List<IDMQueueEntry> queueEntries = this.idmQueueService.pop(100, i, true);
                            List<IDMQueueEntry> treatedQueueEntries = this.processQueueEntries(queueEntries);
                            this.idmQueueService.storeAsProcessed(treatedQueueEntries);
                        }
                        finally {
                            RequestLifeCycle.end();
                        }
                    }
                    finally {
                        this.openTransactionLevels(numberOfTransactionLevels);
                    }
                    if (this.interrupted) {
                        throw new InterruptedException("Queue entries processing is interrupted, it will be retried next startup");
                    }
                    countEntitiesToImport = this.idmQueueService.count(i);
                    LOG.info("Treated entities with number of retries = {} : {}/{}", new Object[]{i, countAllEntitiesToImport - countEntitiesToImport, countAllEntitiesToImport});
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while processing queue", (Throwable)e);
        }
        try {
            this.idmQueueService.deleteProcessedEntries();
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while deleting processed queue elements", (Throwable)e);
        }
    }

    public <T> T importEntityToInternalStore(IDMEntityType<T> entityType, Object entityId, boolean updateModified, boolean updateDeleted) throws Exception {
        if (entityType == null) {
            throw new IllegalArgumentException("entityType is mandatory");
        }
        if (entityId == null || StringUtils.isBlank((String)entityId.toString())) {
            throw new IllegalArgumentException("entityId is mandatory");
        }
        boolean deleted = false;
        if (!this.externalStoreService.isEntityPresent(entityType, entityId)) {
            LOG.trace("Entity of type '{}' and id '{}' are not present in external store.", new Object[]{entityType.getName(), entityId});
            if (updateDeleted) {
                deleted = true;
            } else {
                return null;
            }
        }
        if (deleted) {
            LOG.info("Disable/Delete from internal store entity of type '{}' with id '{}'", new Object[]{entityType.getName(), entityId});
        } else {
            LOG.info("Import to internal store entity of type '{}' with id '{}'", new Object[]{entityType.getName(), entityId});
        }
        Serializable result = null;
        if (IDMEntityType.USER.equals(entityType)) {
            String username = entityId.toString();
            result = this.importUser(username, deleted, updateModified, updateDeleted);
        } else if (IDMEntityType.USER_PROFILE.equals(entityType)) {
            String username = entityId.toString();
            result = this.importUserProfile(username, deleted);
        } else if (IDMEntityType.GROUP.equals(entityType)) {
            String groupId = entityId.toString();
            result = this.importGroup(groupId, deleted, updateModified, updateDeleted);
        } else if (IDMEntityType.USER_MEMBERSHIPS.equals(entityType)) {
            String username = entityId.toString();
            this.importUserMemberships(username, updateModified, updateDeleted);
        } else if (IDMEntityType.GROUP_MEMBERSHIPS.equals(entityType)) {
            String groupId = entityId.toString();
            this.importGroupMemberships(groupId, updateModified, updateDeleted);
        } else if (IDMEntityType.ROLE.equals(entityType)) {
            String membershipTypeName = entityId.toString();
            result = this.importMembershipType(membershipTypeName, deleted);
        }
        LOG.info("Entity of type '{}' with id '{}' proceeded successfully", new Object[]{entityType.getName(), entityId});
        return result == null ? null : (T)entityType.getClassType().cast(result);
    }

    public synchronized void checkAllEntitiesToDeleteIntoQueue() throws Exception {
        this.checkEntitiesToDeleteIntoQueue(IDMEntityType.USER);
        this.checkEntitiesToDeleteIntoQueue(IDMEntityType.GROUP);
    }

    public synchronized void checkEntitiesToDeleteIntoQueue(IDMEntityType<?> entityType) throws Exception {
        if (entityType == null) {
            throw new IllegalArgumentException("entityType is mandatory");
        }
        if (!this.externalStoreService.getManagedEntityTypes().contains(entityType)) {
            LOG.trace((Object)("Entity type " + entityType.getClassType().getName() + " is not managed by IDMExternalStoreService, check deleted entities of this type will not proceed"));
            return;
        }
        if (entityType.equals(IDMEntityType.USER)) {
            LOG.info((Object)"Check deleted users from external store");
            this.checkDeletedEntitiesOfType(IDMEntityType.USER, this.getUserDeletionConsumer());
        } else if (entityType.equals(IDMEntityType.GROUP)) {
            LOG.info((Object)"Check deleted groups from external store");
            this.checkDeletedEntitiesOfType(IDMEntityType.GROUP, this.getGroupDeletionConsumer());
        }
    }

    public synchronized <T> void checkDeletedEntitiesOfType(IDMEntityType<T> entityType, Consumer<String> deletionConsumer) throws Exception {
        if (entityType == null) {
            throw new IllegalArgumentException("entityType is mandatory");
        }
        if (deletionConsumer == null) {
            throw new IllegalArgumentException("modificationConsumer is mandatory");
        }
        if (!this.externalStoreService.getManagedEntityTypes().contains(entityType)) {
            LOG.trace((Object)("Entity type " + entityType.getClassType().getName() + " is not managed by IDMExternalStoreService, check deleted entities of this type will not proceed"));
            return;
        }
        if (!this.externalStoreService.getManagedEntityTypes().contains(entityType)) {
            LOG.trace((Object)("Entity type " + entityType.getClassType().getName() + " is not managed by IDMExternalStoreService, check deleted entities of this type will not proceed"));
            return;
        }
        if (IDMEntityType.USER.equals(entityType)) {
            ListAccess<User> allStoredUsersInInternalStore = this.externalStoreService.getAllInternalUsers();
            LOG.info((Object)"Retrieving all existing external users");
            ArrayList externalUsernames = new ArrayList();
            this.loadModifiedUsers(entityType, username -> externalUsernames.add(username), null);
            LOG.info("{} users was retrieved from external store", new Object[]{externalUsernames.size()});
            int totalUsers = allStoredUsersInInternalStore.getSize();
            int index = 0;
            int offset = 0;
            int limit = 100;
            while (index < totalUsers) {
                User[] users;
                if (index + limit > totalUsers) {
                    limit = totalUsers - index;
                }
                if ((users = (User[])allStoredUsersInInternalStore.load(offset, limit)) != null && users.length != 0) {
                    offset += limit;
                    for (User user : users) {
                        if (this.interrupted) {
                            throw new InterruptedException("Deleted users check is interrupted, it will be retried next startup");
                        }
                        ++index;
                        String username2 = user.getUserName();
                        if (externalUsernames.contains(username2) || (user = this.organizationService.getUserHandler().findUserByName(username2)).isInternalStore()) continue;
                        deletionConsumer.accept(username2);
                    }
                    LOG.info("{}/{} was checked if deleted from external store", new Object[]{offset, totalUsers});
                    continue;
                }
                break;
            }
        } else if (IDMEntityType.GROUP.equals(entityType)) {
            Collection<Group> allGroups = this.organizationService.getGroupHandler().getAllGroups();
            LOG.info("{} groups to check if deleted from external store", new Object[]{allGroups.size()});
            for (Group group : allGroups) {
                if (this.interrupted) {
                    throw new InterruptedException("Deleted users check is interrupted, it will be retried next startup");
                }
                if (group.isInternalStore() || this.externalStoreService.isEntityPresent(IDMEntityType.GROUP, group.getId())) continue;
                deletionConsumer.accept(group.getId());
            }
            LOG.info((Object)"End groups deletion check from external store");
        }
    }

    public void interrupt() {
        this.interrupted = true;
    }

    private Consumer<String> getGroupDeletionConsumer() {
        Consumer<String> groupDeletionConsumer = groupId -> {
            LOG.info("Group '{}' is deleted from external store, a new IDM queue entry will be added", new Object[]{groupId});
            try {
                this.idmQueueService.push(new IDMQueueEntry(IDMEntityType.GROUP, (String)groupId, IDMOperationType.DELETE));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to push Group '" + groupId + "' entry to delete on queue", e);
            }
        };
        return groupDeletionConsumer;
    }

    private Consumer<String> getUserDeletionConsumer() {
        Consumer<String> userDeletionConsumer = username -> {
            LOG.info("User '{}' is deleted from external store, a new IDM queue entry will be added", new Object[]{username});
            try {
                this.idmQueueService.push(new IDMQueueEntry(IDMEntityType.USER, (String)username, IDMOperationType.DELETE));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to push user '" + username + "' entry to delete on queue", e);
            }
        };
        return userDeletionConsumer;
    }

    private Consumer<String> getRoleModificationConsumer() {
        Consumer<String> roleModificationConsumer = membershipType -> {
            try {
                if (this.organizationService.getMembershipTypeHandler().findMembershipType((String)membershipType) == null) {
                    LOG.info("Role '{}' is added/updated from external store, a new IDM queue entry will be added", new Object[]{membershipType});
                    this.idmQueueService.push(new IDMQueueEntry(IDMEntityType.ROLE, (String)membershipType, IDMOperationType.ADD_OR_UPDATE));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to push Role '" + membershipType + "' entry to add/modify on queue", e);
            }
        };
        return roleModificationConsumer;
    }

    private Consumer<String> getGroupModificationConsumer() {
        Consumer<String> groupModificationConsumer = groupId -> {
            LOG.info("Group '{}' is added/updated from external store, a new IDM queue entry will be added", new Object[]{groupId});
            try {
                this.idmQueueService.push(new IDMQueueEntry(IDMEntityType.GROUP, (String)groupId, IDMOperationType.ADD_OR_UPDATE));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to push Group '" + groupId + "' entry to add/modify on queue", e);
            }
        };
        return groupModificationConsumer;
    }

    private Consumer<String> getUserModificationConsumer() {
        Consumer<String> userModificationConsumer = username -> {
            LOG.info("User '{}' is added/modified in external store, a new IDM queue entry will be added", new Object[]{username});
            try {
                this.idmQueueService.push(new IDMQueueEntry(IDMEntityType.USER, (String)username, IDMOperationType.ADD_OR_UPDATE));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to push User '" + username + "' entry to add/modify on queue", e);
            }
        };
        return userModificationConsumer;
    }

    private MembershipType importMembershipType(String membershipTypeName, boolean deleted) throws Exception {
        MembershipType membershipType = this.organizationService.getMembershipTypeHandler().findMembershipType(membershipTypeName);
        if (deleted && membershipType != null) {
            LOG.trace("Remove from internal store deleted membershipType '{}' from external store", new Object[]{membershipTypeName});
            this.organizationService.getMembershipTypeHandler().removeMembershipType(membershipTypeName, true);
            return membershipType;
        }
        if (membershipType == null && (membershipType = this.externalStoreService.getEntity(IDMEntityType.ROLE, membershipTypeName)) != null) {
            LOG.trace("Add in internal store new membershipType '{}' from external store", new Object[]{membershipTypeName});
            this.organizationService.getMembershipTypeHandler().createMembershipType(membershipType, true);
        }
        return membershipType;
    }

    private void importGroupMemberships(String groupId, boolean updateModified, boolean updateDeleted) throws Exception {
        Group group = this.organizationService.getGroupHandler().findGroupById(groupId);
        Collection<Object> internalMemberships = null;
        internalMemberships = group == null ? Collections.emptyList() : this.organizationService.getMembershipHandler().findMembershipsByGroup(group);
        Collection externalMemberships = this.externalStoreService.getEntity(IDMEntityType.GROUP_MEMBERSHIPS, groupId);
        this.importMemberships(IDMEntityType.GROUP_MEMBERSHIPS, externalMemberships, internalMemberships);
    }

    private void importUserMemberships(String username, boolean updateModified, boolean updateDeleted) throws Exception {
        Collection<Membership> internalMemberships = this.organizationService.getMembershipHandler().findMembershipsByUser(username);
        Collection externalMemberships = this.externalStoreService.getEntity(IDMEntityType.USER_MEMBERSHIPS, username);
        this.importMemberships(IDMEntityType.USER_MEMBERSHIPS, externalMemberships, internalMemberships);
    }

    private void importMemberships(IDMEntityType<?> entityType, Collection externalMemberships, Collection internalMemberships) throws Exception {
        if (externalMemberships != null && !externalMemberships.isEmpty()) {
            ArrayList membershipsToAdd = new ArrayList(externalMemberships);
            for (Object object : externalMemberships) {
                if (!internalMemberships.contains(object)) continue;
                membershipsToAdd.remove(object);
            }
            for (Object object : membershipsToAdd) {
                Membership membership = (Membership)object;
                this.importMembership(entityType, membership, false, false);
            }
        }
        for (Object object : internalMemberships) {
            Membership membership = (Membership)object;
            Group group = this.organizationService.getGroupHandler().findGroupById(membership.getGroupId());
            User user = this.organizationService.getUserHandler().findUserByName(membership.getUserName(), UserStatus.ANY);
            if (group != null && user != null && (group.isInternalStore() || user.isInternalStore() || externalMemberships != null && externalMemberships.contains(membership))) continue;
            LOG.trace("Remove deleted membership from external store '{}'", new Object[]{membership});
            this.organizationService.getMembershipHandler().removeMembership(membership.getId(), true);
        }
    }

    private void importMembership(IDMEntityType<?> entityType, Membership membership, boolean updateModified, boolean updateDeleted) throws Exception {
        User user;
        String groupId = membership.getGroupId();
        Group group = this.organizationService.getGroupHandler().findGroupById(groupId);
        if (group == null) {
            if (entityType.equals(IDMEntityType.USER_MEMBERSHIPS)) {
                return;
            }
            group = this.importEntityToInternalStore(IDMEntityType.GROUP, groupId, updateModified, updateDeleted);
            if (group == null) {
                LOG.warn("Can't add membership '{}'. The group '{}' is not found in internal store", new Object[]{membership.toString(), groupId});
                return;
            }
        }
        if ((user = this.organizationService.getUserHandler().findUserByName(membership.getUserName(), UserStatus.ANY)) == null && (user = this.importEntityToInternalStore(IDMEntityType.USER, membership.getUserName(), updateModified, updateDeleted)) == null) {
            Group subGroup = this.organizationService.getGroupHandler().findGroupById(group.getId() + "/" + membership.getUserName());
            if (subGroup == null) {
                LOG.warn("Can't add membership '{}'. The user '{}' is not found in internal store", new Object[]{membership.toString(), membership.getUserName()});
            } else {
                LOG.trace("Membership '{}' seems having retrieved a child group as a user '{}'", new Object[]{membership.toString(), membership.getUserName()});
            }
            return;
        }
        String membershipTypeName = membership.getMembershipType();
        MembershipType membershipType = this.organizationService.getMembershipTypeHandler().findMembershipType(membershipTypeName);
        if (membershipType == null && (membershipType = this.importEntityToInternalStore(IDMEntityType.ROLE, membershipTypeName, updateModified, updateDeleted)) == null) {
            LOG.warn("Can't add membership '{}'. The membershipType '{}' is not found in internal store", new Object[]{membership.toString(), membershipTypeName});
            return;
        }
        LOG.trace("Add new membership from external store '{}'", new Object[]{membership});
        this.organizationService.getMembershipHandler().linkMembership(user, group, membershipType, true);
    }

    private Group importGroup(String groupId, boolean deleted, boolean updateModified, boolean updateDeleted) throws Exception {
        Group eXoGroup = this.organizationService.getGroupHandler().findGroupById(groupId);
        if (deleted && eXoGroup != null) {
            LOG.trace("Remove from internal store deleted group '{}' from external store", new Object[]{groupId});
            this.organizationService.getGroupHandler().removeGroup(eXoGroup, true);
            try {
                this.listenerService.broadcast("exo.idm.externalStore.group.deleted", (Object)this, (Object)eXoGroup);
            }
            catch (Exception e) {
                LOG.warn((Object)("Error while triggering event on group '" + groupId + "' data import (delete) from external store"), (Throwable)e);
            }
            return eXoGroup;
        }
        boolean isNew = eXoGroup == null;
        Group idmGroup = this.externalStoreService.getEntity(IDMEntityType.GROUP, groupId);
        if (idmGroup == null) {
            throw new IllegalStateException("Could not find group from external store with id " + groupId);
        }
        idmGroup.setOriginatingStore("external");
        String parentId = idmGroup.getParentId();
        Group parentGroup = null;
        if (StringUtils.isNotBlank((String)parentId)) {
            parentGroup = this.organizationService.getGroupHandler().findGroupById(parentId);
            if (parentGroup == null) {
                parentGroup = this.importEntityToInternalStore(IDMEntityType.GROUP, parentId, updateModified, updateDeleted);
            }
            if (parentGroup == null) {
                throw new IllegalStateException("Can't find parent group with id " + parentId);
            }
        }
        if (isNew) {
            this.organizationService.getGroupHandler().addChild(parentGroup, idmGroup, true);
            try {
                this.listenerService.broadcast("exo.idm.externalStore.group.new", (Object)this, (Object)idmGroup);
            }
            catch (Exception e) {
                LOG.warn((Object)("Error while triggering event on group '" + groupId + "' data import (creation) from external store"), (Throwable)e);
            }
        } else {
            if (!Objects.equals(eXoGroup.getParentId(), idmGroup.getParentId())) {
                LOG.info("Group {} moved from {} to {}", new Object[]{eXoGroup.getId(), eXoGroup.getParentId(), idmGroup.getParentId()});
                Group originParentGroup = this.organizationService.getGroupHandler().findGroupById(eXoGroup.getParentId());
                this.organizationService.getGroupHandler().moveGroup(originParentGroup, parentGroup, idmGroup);
            }
            this.organizationService.getGroupHandler().saveGroup(idmGroup, true);
            try {
                this.listenerService.broadcast("exo.idm.externalStore.group.modified", (Object)this, (Object)idmGroup);
            }
            catch (Exception e) {
                LOG.warn((Object)("Error while triggering event on group '" + groupId + "' data import (modification) from external store"), (Throwable)e);
            }
        }
        return idmGroup;
    }

    private UserProfile importUserProfile(String username, boolean deleted) throws Exception {
        UserProfile externalUserProfile;
        UserProfile internalUserProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(username);
        if (deleted && internalUserProfile != null) {
            LOG.trace("Remove from internal store deleted user profile '{}' from external store", new Object[]{username});
            this.organizationService.getUserProfileHandler().removeUserProfile(username, true);
        }
        if ((externalUserProfile = this.externalStoreService.getEntity(IDMEntityType.USER_PROFILE, username)) != null && externalUserProfile.getUserInfoMap() != null && !externalUserProfile.getUserInfoMap().isEmpty()) {
            Map<String, String> externalUserInfoMap = externalUserProfile.getUserInfoMap();
            Map<Object, Object> internalUserInfoMap = internalUserProfile == null || internalUserProfile.getUserInfoMap() == null ? new HashMap() : internalUserProfile.getUserInfoMap();
            boolean isModified = internalUserInfoMap.isEmpty();
            if (!isModified) {
                Set<String> externalUserProfileAttributes = externalUserInfoMap.keySet();
                for (String externalUserProfileAttribute : externalUserProfileAttributes) {
                    if (isModified |= !internalUserInfoMap.containsKey(externalUserProfileAttribute) || !Objects.equals(externalUserInfoMap.get(externalUserProfileAttribute), internalUserInfoMap.get(externalUserProfileAttribute))) break;
                }
            }
            if (isModified) {
                internalUserInfoMap.putAll(externalUserInfoMap);
                UserProfile userProfile = this.organizationService.getUserProfileHandler().createUserProfileInstance(username);
                userProfile.setUserInfoMap(internalUserInfoMap);
                this.organizationService.getUserProfileHandler().saveUserProfile(userProfile, true);
                return userProfile;
            }
        }
        return internalUserProfile;
    }

    private User importUser(String username, boolean deleted, boolean updateModified, boolean updateDeleted) throws Exception {
        User internalUser = this.organizationService.getUserHandler().findUserByName(username, UserStatus.ANY);
        if (deleted && internalUser != null) {
            if (this.deleteMissingEntriesFromInternalStore) {
                LOG.trace("Remove from internal store deleted user '{}' from external store", new Object[]{username});
                this.organizationService.getUserHandler().removeUser(username, true);
            } else {
                LOG.trace("Disable user '{}' in internal store as he is not found in external store", new Object[]{username});
                this.organizationService.getUserHandler().setEnabled(username, false, true);
            }
            try {
                this.listenerService.broadcast("exo.idm.externalStore.user.deleted", (Object)this, (Object)internalUser);
            }
            catch (Exception e) {
                LOG.warn((Object)("Error while triggering event on user '" + username + "' data import (delete) from external store"), (Throwable)e);
            }
            return internalUser;
        }
        boolean isNew = internalUser == null;
        boolean isModified = false;
        if (isNew) {
            User externalUser = this.externalStoreService.getEntity(IDMEntityType.USER, username);
            externalUser.setOriginatingStore("external");
            if (externalUser.isEnabled()) {
                this.organizationService.getUserHandler().createUser(externalUser, true);
            } else {
                ((UserImpl)externalUser).setEnabled(true);
                this.organizationService.getUserHandler().createUser(externalUser, true);
                this.organizationService.getUserHandler().setEnabled(externalUser.getUserName(), false, true);
            }
            internalUser = externalUser;
            try {
                this.listenerService.broadcast("exo.idm.externalStore.user.new", (Object)this, (Object)externalUser);
            }
            catch (Exception e) {
                LOG.warn((Object)("Error while triggering event on user '" + username + "' data import (creation) from external store"), (Throwable)e);
            }
            this.importEntityToInternalStore(IDMEntityType.USER_PROFILE, username, updateModified, updateDeleted);
        } else if (updateModified) {
            boolean bl = isModified = updateModified && this.externalStoreService.isEntityModified(IDMEntityType.USER, username);
            if (isModified) {
                User externalUser = this.externalStoreService.getEntity(IDMEntityType.USER, username);
                if (internalUser.isEnabled() != externalUser.isEnabled()) {
                    this.organizationService.getUserHandler().setEnabled(internalUser.getUserName(), externalUser.isEnabled(), true);
                }
                this.mergeExternalToInternalUser(internalUser, externalUser);
                if (!internalUser.isEnabled()) {
                    ((UserImpl)internalUser).setEnabled(true);
                    this.organizationService.getUserHandler().saveUser(internalUser, true);
                    this.organizationService.getUserHandler().setEnabled(internalUser.getUserName(), false, true);
                } else {
                    this.organizationService.getUserHandler().saveUser(internalUser, true);
                }
                try {
                    this.listenerService.broadcast("exo.idm.externalStore.user.modified", (Object)this, (Object)internalUser);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Error while triggering event on user '" + username + "' data import (modification) from external store"), (Throwable)e);
                }
            }
            this.importEntityToInternalStore(IDMEntityType.USER_PROFILE, username, updateModified, updateDeleted);
        }
        if (internalUser != null && internalUser.isInternalStore()) {
            internalUser.setOriginatingStore("external");
            this.organizationService.getUserHandler().saveUser(internalUser, false);
        }
        return internalUser;
    }

    private void mergeExternalToInternalUser(User internalUser, User externalUser) {
        if (StringUtils.isNotEmpty((String)externalUser.getEmail())) {
            internalUser.setEmail(externalUser.getEmail());
        }
        if (StringUtils.isNotEmpty((String)externalUser.getFirstName())) {
            internalUser.setFirstName(externalUser.getFirstName());
        }
        if (StringUtils.isNotEmpty((String)externalUser.getLastName())) {
            internalUser.setLastName(externalUser.getLastName());
        }
        if (StringUtils.isNotEmpty((String)externalUser.getDisplayName())) {
            internalUser.setDisplayName(externalUser.getDisplayName());
        }
        if (StringUtils.isNotEmpty((String)externalUser.getOrganizationId())) {
            internalUser.setOrganizationId(externalUser.getOrganizationId());
        }
        if (externalUser.getCreatedDate() != null) {
            internalUser.setCreatedDate(externalUser.getCreatedDate());
        }
        if (!Objects.equals(externalUser.isEnabled(), internalUser.isEnabled())) {
            ((UserImpl)internalUser).setEnabled(externalUser.isEnabled());
        }
        internalUser.setOriginatingStore("external");
    }

    private List<IDMQueueEntry> processQueueEntries(List<IDMQueueEntry> queueEntries) throws Exception {
        ArrayList<IDMQueueEntry> treatedQueueEntries = new ArrayList<IDMQueueEntry>();
        for (IDMQueueEntry queueEntry : queueEntries) {
            try {
                IDMEntityType<?> entityType = queueEntry.getEntityType();
                if (IDMOperationType.ADD_OR_UPDATE.equals((Object)queueEntry.getOperationType()) && !this.externalStoreService.isEntityPresent(queueEntry.getEntityType(), queueEntry.getEntityId())) {
                    LOG.info("Entity of type '{}' with id '{}' was removed from external store before added/updated on internal store", new Object[]{queueEntry.getEntityType().getName(), queueEntry.getEntityId()});
                    treatedQueueEntries.add(queueEntry);
                    continue;
                }
                this.importEntityToInternalStore(queueEntry.getEntityType(), queueEntry.getEntityId(), true, true);
                if (IDMOperationType.ADD_OR_UPDATE.equals((Object)queueEntry.getOperationType())) {
                    if (entityType.equals(IDMEntityType.USER)) {
                        this.importEntityToInternalStore(IDMEntityType.USER_MEMBERSHIPS, queueEntry.getEntityId(), true, true);
                    } else if (entityType.equals(IDMEntityType.GROUP)) {
                        this.importEntityToInternalStore(IDMEntityType.GROUP_MEMBERSHIPS, queueEntry.getEntityId(), true, true);
                    }
                }
                treatedQueueEntries.add(queueEntry);
            }
            catch (Exception e) {
                this.idmQueueService.incrementRetry(Collections.singletonList(queueEntry));
                String entryId = queueEntry == null ? null : queueEntry.getEntityId();
                String entryType = queueEntry == null ? null : queueEntry.getEntityType().getClassType().getSimpleName();
                String operationType = queueEntry == null ? null : queueEntry.getOperationType().name();
                LOG.warn((Object)("Error while treating entity of type '" + entryType + "' with id '" + entryId + "' for operation type'" + operationType + "'"), (Throwable)e);
            }
        }
        return treatedQueueEntries;
    }

    private void initializeDataImportScheduledJob() throws Exception {
        if (StringUtils.isBlank((String)this.scheduledDataImportJobCronExpression)) {
            LOG.warn((Object)"Can't initialize Cron Job for IDM Data import, the cron expression is empty");
            return;
        }
        InitParams params = new InitParams();
        PropertiesParam properties = new PropertiesParam();
        properties.setName("cronjob.info");
        properties.setProperty("jobName", "IDM.DATA.IMPORT");
        properties.setProperty("groupName", "PORTAL.IDM");
        properties.setProperty("job", IDMEntitiesImportJob.class.getName());
        properties.setProperty("expression", this.scheduledDataImportJobCronExpression);
        params.addParam((Object)properties);
        this.jobSchedulerService.addCronJob((ComponentPlugin)new CronJob(params));
    }

    private void initializeDataDeleteScheduledJob() throws Exception {
        if (StringUtils.isBlank((String)this.scheduledDataDeleteJobCronExpression)) {
            LOG.warn((Object)"Can't initialize Cron Job for IDM Data delete, the cron expression is empty");
            return;
        }
        InitParams params = new InitParams();
        PropertiesParam properties = new PropertiesParam();
        properties.setName("cronjob.info");
        properties.setProperty("jobName", "IDM.DATA.DELETE");
        properties.setProperty("groupName", "PORTAL.IDM");
        properties.setProperty("job", IDMEntitiesDeleteJob.class.getName());
        properties.setProperty("expression", this.scheduledDataDeleteJobCronExpression);
        params.addParam((Object)properties);
        this.jobSchedulerService.addCronJob((ComponentPlugin)new CronJob(params));
    }

    private void initializeQueueProcessingScheduledJob() throws Exception {
        if (StringUtils.isBlank((String)this.scheduledDataImportJobCronExpression)) {
            LOG.warn((Object)"Can't initialize Cron Job for IDM Queue Processing, the cron expression is empty");
            return;
        }
        InitParams params = new InitParams();
        PropertiesParam properties = new PropertiesParam();
        properties.setName("cronjob.info");
        properties.setProperty("jobName", "IDM.QUEUE");
        properties.setProperty("groupName", "PORTAL.IDM");
        properties.setProperty("job", IDMQueueProcessorJob.class.getName());
        properties.setProperty("expression", this.scheduledDataImportJobCronExpression);
        params.addParam((Object)properties);
        this.jobSchedulerService.addCronJob((ComponentPlugin)new CronJob(params));
    }

    private LocalDateTime getLocalDateTime() {
        return ZonedDateTime.now(ZoneId.of("UTC")).toLocalDateTime();
    }

    private int forceCloseTransaction() {
        int i = 0;
        try {
            while (true) {
                RequestLifeCycle.end();
                ++i;
            }
        }
        catch (Exception exception) {
            return i;
        }
    }

    private void openTransactionLevels(int numberOfTransactionLevels) {
        for (int i = 0; i < numberOfTransactionLevels; ++i) {
            RequestLifeCycle.begin((ExoContainer)this.container);
        }
    }

    private <T> void loadModifiedUsers(IDMEntityType<T> entityType, Consumer<String> modificationConsumer, LocalDateTime lastSuccessExecutionTime) throws Exception, InterruptedException {
        String[] usernames;
        ListAccess<String> modifiedOrAddedUsers = this.externalStoreService.getAllOfType(IDMEntityType.USER, lastSuccessExecutionTime);
        if (modifiedOrAddedUsers == null) {
            return;
        }
        for (String username : usernames = (String[])modifiedOrAddedUsers.load(0, Integer.MAX_VALUE)) {
            if (this.interrupted) {
                throw new InterruptedException("Import of modified users check is interrupted, it will be retried next startup");
            }
            modificationConsumer.accept(username);
        }
    }

    public void setDeleteMissingEntriesFromInternalStore(boolean deleteMissingEntriesFromInternalStore) {
        this.deleteMissingEntriesFromInternalStore = deleteMissingEntriesFromInternalStore;
    }
}

