/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.listener.analytics;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.kudos.model.Kudos;
import org.exoplatform.kudos.service.KudosService;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

@Asynchronous
public class KudosSentListener
extends Listener<KudosService, Kudos> {
    private static final Log LOG = ExoLogger.getLogger(KudosSentListener.class);
    private PortalContainer container = PortalContainer.getInstance();
    private ActivityManager activityManager;
    private SpaceService spaceService;

    public void onEvent(Event<KudosService, Kudos> event) throws Exception {
        Kudos kudos = (Kudos)event.getData();
        this.addEventStatistic(kudos);
    }

    private void addEventStatistic(Kudos kudos) {
        long activityId = kudos.getActivityId();
        long streamIdentityId = 0L;
        boolean receiverChanged = false;
        if (activityId <= 0L && (StringUtils.equals((String)"ACTIVITY", (String)kudos.getEntityType()) || StringUtils.equals((String)"COMMENT", (String)kudos.getEntityType()))) {
            activityId = Long.parseLong(kudos.getEntityId());
        }
        StatisticData statisticData = new StatisticData();
        if (activityId > 0L) {
            ExoSocialActivity parentActivity;
            ExoSocialActivity activity = this.getActivityManager().getActivity("comment" + activityId);
            if (activity == null) {
                activity = this.getActivityManager().getActivity(String.valueOf(activityId));
            }
            if (activity != null && (parentActivity = this.getActivityManager().getParentActivity(activity)) != null) {
                activity = parentActivity;
            }
            Identity streamIdentity = null;
            if (activity != null) {
                ActivityStream activityStream;
                if (!activity.getPosterId().equals(kudos.getReceiverIdentityId())) {
                    receiverChanged = true;
                }
                if ((activityStream = activity.getActivityStream()) != null) {
                    ActivityStream.Type type = activityStream.getType();
                    boolean isSpace = type == ActivityStream.Type.SPACE;
                    String streamProviderId = isSpace ? "space" : "organization";
                    String streamRemoteId = activityStream.getPrettyId();
                    try {
                        streamIdentity = AnalyticsUtils.getIdentity((String)streamProviderId, (String)streamRemoteId);
                    }
                    catch (Exception e) {
                        LOG.debug("Can't retrieve identity with providerId {} and remoteId {}. Attempt to retrieve it as Identity technical ID", new Object[]{streamProviderId, streamRemoteId, e});
                        streamIdentity = AnalyticsUtils.getIdentity((String)activityStream.getId());
                    }
                }
            }
            if (streamIdentity != null) {
                streamIdentityId = Long.parseLong(streamIdentity.getId());
                if (StringUtils.equals((String)streamIdentity.getProviderId(), (String)"space")) {
                    Space space = this.getSpaceService().getSpaceByPrettyName(streamIdentity.getRemoteId());
                    AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
                }
            }
        }
        if (kudos.getSpacePrettyName() != null) {
            Space space = this.getSpaceService().getSpaceByPrettyName(kudos.getSpacePrettyName());
            Identity spaceIdentity = AnalyticsUtils.getIdentity((String)"space", (String)kudos.getSpacePrettyName());
            if (spaceIdentity != null) {
                streamIdentityId = Long.parseLong(spaceIdentity.getId());
                AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
            }
        }
        statisticData.setModule("social");
        statisticData.setSubModule("kudos");
        statisticData.setOperation("sendKudos");
        statisticData.setUserId(Long.parseLong(kudos.getSenderIdentityId()));
        statisticData.addParameter("activityId", (Object)activityId);
        statisticData.addParameter("streamIdentityId", (Object)streamIdentityId);
        statisticData.addParameter("kudosId", (Object)kudos.getTechnicalId());
        statisticData.addParameter("senderId", (Object)kudos.getSenderIdentityId());
        statisticData.addParameter("receiverId", (Object)kudos.getReceiverIdentityId());
        statisticData.addParameter("entityId", (Object)kudos.getEntityId());
        statisticData.addParameter("entityType", (Object)kudos.getEntityType());
        statisticData.addParameter("parentEntityId", (Object)kudos.getParentEntityId());
        statisticData.addParameter("receiverType", (Object)kudos.getReceiverType());
        statisticData.addParameter("messageLength", (Object)kudos.getMessage().length());
        statisticData.addParameter("duration", (Object)kudos.getTimeInSeconds());
        statisticData.addParameter("receiverChanged", (Object)receiverChanged);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.container.getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }

    public ActivityManager getActivityManager() {
        if (this.activityManager == null) {
            this.activityManager = (ActivityManager)this.container.getComponentInstanceOfType(ActivityManager.class);
        }
        return this.activityManager;
    }
}

