/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.ConstructorDescriptor;
import org.exoplatform.services.rest.ConstructorParameter;
import org.exoplatform.services.rest.impl.ConstructorParameterImpl;
import org.exoplatform.services.rest.impl.InternalException;
import org.exoplatform.services.rest.impl.method.ParameterHelper;
import org.exoplatform.services.rest.impl.method.ParameterResolver;
import org.exoplatform.services.rest.impl.method.ParameterResolverFactory;
import org.exoplatform.services.rest.resource.ResourceDescriptorVisitor;

public class ConstructorDescriptorImpl
implements ConstructorDescriptor {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.rest.core.ConstructorDescriptorImpl");
    public static final Comparator<ConstructorDescriptor> CONSTRUCTOR_COMPARATOR = new ConstructorComparator();
    private final Constructor<?> constructor;
    private final List<ConstructorParameter> parameters;
    private final Class<?> resourceClass;

    public ConstructorDescriptorImpl(Class<?> resourceClass, Constructor<?> constructor) {
        this.resourceClass = resourceClass;
        this.constructor = constructor;
        Class<?>[] paramTypes = constructor.getParameterTypes();
        if (paramTypes.length == 0) {
            this.parameters = Collections.emptyList();
        } else {
            Type[] getParamTypes = constructor.getGenericParameterTypes();
            Annotation[][] annotations = constructor.getParameterAnnotations();
            ArrayList<ConstructorParameterImpl> params = new ArrayList<ConstructorParameterImpl>(paramTypes.length);
            for (int i = 0; i < paramTypes.length; ++i) {
                String defaultValue = null;
                Annotation annotation = null;
                boolean encoded = false;
                boolean provider = resourceClass.getAnnotation(Provider.class) != null;
                List<String> allowedAnnotation = provider ? ParameterHelper.PROVIDER_CONSTRUCTOR_PARAMETER_ANNOTATIONS : ParameterHelper.RESOURCE_CONSTRUCTOR_PARAMETER_ANNOTATIONS;
                for (Annotation a : annotations[i]) {
                    Class<? extends Annotation> ac = a.annotationType();
                    if (allowedAnnotation.contains(ac.getName())) {
                        if (annotation == null) {
                            annotation = a;
                            continue;
                        }
                        String msg = "JAX-RS annotations on one of constructor parameters are equivocality. Annotations: " + annotation + " and " + a + " can't be applied to one parameter.";
                        throw new RuntimeException(msg);
                    }
                    if (ac == Encoded.class && !provider) {
                        encoded = true;
                        continue;
                    }
                    if (ac == DefaultValue.class && !provider) {
                        defaultValue = ((DefaultValue)a).value();
                        continue;
                    }
                    LOG.warn((Object)("Constructor parameter contains unknown or not valid JAX-RS annotation " + a + ". It will be ignored."));
                }
                encoded = encoded || resourceClass.getAnnotation(Encoded.class) != null;
                ConstructorParameterImpl cp = new ConstructorParameterImpl(annotation, annotations[i], paramTypes[i], getParamTypes[i], defaultValue, encoded);
                params.add(cp);
            }
            this.parameters = Collections.unmodifiableList(params);
        }
    }

    @Override
    public void accept(ResourceDescriptorVisitor visitor) {
        visitor.visitConstructorInjector(this);
    }

    @Override
    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    @Override
    public List<ConstructorParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public Object createInstance(ApplicationContext context) {
        Object[] p = new Object[this.parameters.size()];
        int i = 0;
        for (ConstructorParameter cp : this.parameters) {
            Annotation a = cp.getAnnotation();
            if (a != null) {
                ParameterResolver pr = ParameterResolverFactory.createParameterResolver(a);
                try {
                    p[i] = pr.resolve(cp, context);
                }
                catch (Exception e) {
                    String msg = "Not able resolve constructor parameter " + cp;
                    Class<? extends Annotation> ac = a.annotationType();
                    if (ac == MatrixParam.class || ac == QueryParam.class || ac == PathParam.class) {
                        throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)msg).type("text/plain").build());
                    }
                    throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).type("text/plain").build());
                }
            } else {
                Object tmp = context.getDependencySupplier().getComponent(cp);
                if (tmp == null) {
                    String msg = "Can't instantiate resource " + this.resourceClass + " by using constructor " + this + ". Not found parameter " + cp;
                    LOG.error((Object)msg);
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)msg).type("text/plain").build());
                }
                p[i] = tmp;
            }
            ++i;
        }
        try {
            return this.constructor.newInstance(p);
        }
        catch (IllegalArgumentException argExc) {
            throw new InternalException(argExc);
        }
        catch (InstantiationException instExc) {
            throw new InternalException(instExc);
        }
        catch (IllegalAccessException accessExc) {
            throw new InternalException(accessExc);
        }
        catch (InvocationTargetException invExc) {
            Throwable cause = invExc.getCause();
            if (WebApplicationException.class == cause.getClass()) {
                throw (WebApplicationException)cause;
            }
            throw new InternalException(cause);
        }
        catch (WebApplicationException thr) {
            throw new InternalException(thr);
        }
        catch (InternalException thr) {
            throw new InternalException(thr);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[ ConstructorInjectorImpl: ");
        sb.append("constructor: " + this.getConstructor().getName() + "; ");
        for (ConstructorParameter cp : this.getParameters()) {
            sb.append(cp.toString()).append(" ");
        }
        sb.append(" ]");
        return sb.toString();
    }

    private static class ConstructorComparator
    implements Comparator<ConstructorDescriptor> {
        private ConstructorComparator() {
        }

        @Override
        public int compare(ConstructorDescriptor o1, ConstructorDescriptor o2) {
            int r = o2.getParameters().size() - o1.getParameters().size();
            if (r == 0) {
                LOG.warn((Object)("Two constructors with the same number of parameter found " + o1 + " and " + o2));
            }
            return r;
        }
    }
}

