/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.resolver;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.exoplatform.resolver.ResourceKey;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ServletResourceResolver
extends ResourceResolver {
    protected static Log log = ExoLogger.getLogger((String)"portal:ServletResourceResolver");
    private ServletContext scontext_;
    private String scheme_;

    public ServletResourceResolver(ServletContext context, String scheme) {
        this.scontext_ = context;
        this.scheme_ = scheme;
    }

    @Override
    public URL getResource(String url) throws Exception {
        String path = this.removeScheme(url);
        return this.scontext_.getResource(path);
    }

    @Override
    public InputStream getInputStream(String url) throws Exception {
        String path = this.removeScheme(url);
        return this.scontext_.getResourceAsStream(path);
    }

    @Override
    public List<URL> getResources(String url) throws Exception {
        ArrayList<URL> urlList = new ArrayList<URL>();
        urlList.add(this.getResource(url));
        return urlList;
    }

    @Override
    public List<InputStream> getInputStreams(String url) throws Exception {
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        inputStreams.add(this.getInputStream(url));
        return inputStreams;
    }

    @Override
    public String getRealPath(String url) {
        String path = this.removeScheme(url);
        return this.scontext_.getRealPath(path);
    }

    @Override
    public boolean isModified(String url, long lastAccess) {
        try {
            URL uri = this.getResource(url);
            URLConnection con = uri.openConnection();
            if (log.isDebugEnabled()) {
                log.debug((Object)(url + ": " + con.getLastModified() + " " + lastAccess));
            }
            if (con.getLastModified() > lastAccess) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Override
    public String getWebAccessPath(String url) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("GET WEB ACCESS " + url));
        }
        return "/" + this.scontext_.getServletContextName() + this.removeScheme(url);
    }

    @Override
    public String getResourceScheme() {
        return this.scheme_;
    }

    @Override
    public ResourceKey createResourceKey(String url) {
        return new ResourceKey(this.scontext_.getContextPath().hashCode(), url);
    }
}

