/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import juzu.Handler;
import juzu.Response;
import juzu.impl.bridge.spi.RequestBridge;
import juzu.impl.common.MethodHandle;
import juzu.impl.common.Tools;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.plugin.ServiceContext;
import juzu.impl.plugin.ServiceDescriptor;
import juzu.impl.plugin.application.Application;
import juzu.impl.plugin.application.ApplicationService;
import juzu.impl.plugin.controller.ControllerResolver;
import juzu.impl.plugin.controller.descriptor.ControllersDescriptor;
import juzu.impl.request.ContextualParameter;
import juzu.impl.request.ControllerHandler;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.impl.value.ValueType;
import juzu.io.UndeclaredIOException;
import juzu.request.Phase;
import juzu.request.RequestParameter;

public class ControllerService
extends ApplicationService {
    private ControllersDescriptor descriptor;
    final ArrayList<ValueType<?>> valueTypes = new ArrayList();
    final List<RequestFilter<?>> filters = new ArrayList();
    @Inject
    private Application application;

    public ControllerService() {
        super("controller");
    }

    public Application getApplication() {
        return this.application;
    }

    public ControllersDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ControllerResolver<ControllerHandler> getResolver() {
        return this.descriptor != null ? this.descriptor.getResolver() : null;
    }

    @Override
    public ServiceDescriptor init(ServiceContext context) throws Exception {
        this.valueTypes.addAll(ValueType.DEFAULT);
        for (ValueType valueType : Tools.loadService(ValueType.class, context.getClassLoader())) {
            this.valueTypes.add(valueType);
        }
        this.descriptor = new ControllersDescriptor(context.getClassLoader(), context.getConfig());
        return this.descriptor;
    }

    public InjectionContext<?, ?> getInjectionContext() {
        return this.application.getInjectionContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RequestFilter<?>> getFilters() {
        if (this.filters.isEmpty()) {
            List<RequestFilter<?>> list = this.filters;
            synchronized (list) {
                if (this.filters.isEmpty()) {
                    for (RequestFilter filter : this.getInjectionContext().resolveInstances(RequestFilter.class)) {
                        this.filters.add(filter);
                    }
                }
            }
        }
        return this.filters;
    }

    public <T> ValueType<T> resolveValueType(Class<T> type) {
        for (int i = 0; i < this.valueTypes.size(); ++i) {
            ValueType<?> valueType = this.valueTypes.get(i);
            for (Class<?> tmp : valueType.getTypes()) {
                if (!tmp.equals(type)) continue;
                return valueType;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(RequestBridge bridge) {
        block13: {
            MethodHandle handle = bridge.getTarget();
            ControllerHandler<Phase.View> handler = this.descriptor.getMethodByHandle(handle);
            if (handler == null) {
                StringBuilder sb = new StringBuilder("handle me gracefully : no method could be resolved for phase=").append(bridge.getPhase()).append(" handle=").append(handle).append(" parameters={");
                int index = 0;
                for (RequestParameter parameter : bridge.getRequestArguments().values()) {
                    if (index++ > 0) {
                        sb.append(',');
                    }
                    sb.append(parameter.getName()).append("=[");
                    for (int i = 0; i < parameter.size(); ++i) {
                        if (i > 0) {
                            sb.append(',');
                        }
                        sb.append(parameter.get(i));
                    }
                    sb.append(']');
                }
                sb.append("}");
                throw new UnsupportedOperationException(sb.toString());
            }
            Request request = new Request(this, handler, bridge);
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader classLoader = this.application.getClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader);
                bridge.begin(request);
                Response result = request.invoke();
                if (result instanceof Response.Error && this.descriptor.getErrorController() != null) {
                    Method m;
                    Class<? extends Handler<Response.Error, Response>> a = this.descriptor.getErrorController();
                    try {
                        m = a.getMethod("handle", Response.Error.class);
                    }
                    catch (NoSuchMethodException e) {
                        throw new UndeclaredThrowableException(e);
                    }
                    ContextualParameter argument = new ContextualParameter("argument", Response.Error.class);
                    handler = new ControllerHandler<Phase.View>(null, Phase.VIEW, a, m, Collections.singletonList(argument));
                    request = new Request(this, handler, bridge);
                    request.getContextualArguments().put(argument, result);
                    result = request.invoke();
                }
                if (result == null) break block13;
                try {
                    bridge.setResponse(result);
                }
                catch (IOException e) {
                    throw new UndeclaredIOException(e);
                }
            }
            finally {
                bridge.end();
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
    }
}

