/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.heif;

import com.drew.imaging.heif.HeifHandler;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.heif.HeifDirectory;
import com.drew.metadata.heif.HeifHandlerFactory;
import com.drew.metadata.heif.boxes.Box;
import com.drew.metadata.heif.boxes.FileTypeBox;
import com.drew.metadata.heif.boxes.FullBox;
import com.drew.metadata.heif.boxes.HandlerBox;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class HeifBoxHandler
extends HeifHandler<HeifDirectory> {
    HandlerBox handlerBox;
    private HeifHandlerFactory handlerFactory = new HeifHandlerFactory(this);

    public HeifBoxHandler(Metadata metadata) {
        super(metadata);
    }

    @Override
    protected HeifDirectory getDirectory() {
        return new HeifDirectory();
    }

    @Override
    public boolean shouldAcceptBox(@NotNull Box box) {
        List<String> boxes = Arrays.asList("ftyp", "hdlr", "hvc1");
        return boxes.contains(box.type);
    }

    @Override
    public boolean shouldAcceptContainer(@NotNull Box box) {
        return box.type.equals("meta") || box.type.equals("iprp") || box.type.equals("ipco");
    }

    @Override
    public HeifHandler<?> processBox(@NotNull Box box, @NotNull byte[] payload) throws IOException {
        if (payload != null) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(payload);
            if (box.type.equals("ftyp")) {
                this.processFileType(reader, box);
            } else if (box.type.equals("hdlr")) {
                this.handlerBox = new HandlerBox(reader, box);
                return this.handlerFactory.getHandler(this.handlerBox, this.metadata);
            }
        }
        return this;
    }

    @Override
    public void processContainer(@NotNull Box box, @NotNull SequentialReader reader) throws IOException {
        if (box.type.equals("meta")) {
            new FullBox(reader, box);
        }
    }

    private void processFileType(@NotNull SequentialReader reader, @NotNull Box box) throws IOException {
        FileTypeBox fileTypeBox = new FileTypeBox(reader, box);
        fileTypeBox.addMetadata(this.directory);
        if (!fileTypeBox.getCompatibleBrands().contains("mif1")) {
            this.directory.addError("File Type Box does not contain required brand, mif1");
        }
    }
}

