/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler;

import java.util.List;
import juzu.Response;
import juzu.impl.common.Formatting;
import juzu.impl.compiler.CompilationError;

public class CompilationException
extends Exception {
    private List<CompilationError> errors;

    public CompilationException(List<CompilationError> errors) {
        this.errors = errors;
    }

    public List<CompilationError> getErrors() {
        return this.errors;
    }

    @Override
    public String toString() {
        return "CompilationException[" + this.errors + "]";
    }

    public Response.Error asResponse() {
        return new Response.Error(null){

            @Override
            public String getMessage() {
                StringBuilder buffer = new StringBuilder();
                for (CompilationError error : CompilationException.this.errors) {
                    buffer.append(error).append("\n");
                }
                return buffer.toString();
            }

            @Override
            public String getHtmlMessage() {
                StringBuilder buffer = new StringBuilder();
                Formatting.renderErrors(buffer, (Iterable<CompilationError>)CompilationException.this.errors);
                return buffer.toString();
            }
        };
    }
}

