/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.expression;

import java.util.List;
import java.util.Objects;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.FilterOverImpl;
import liquibase.repackaged.net.sf.jsqlparser.expression.JsonAggregateOnNullType;
import liquibase.repackaged.net.sf.jsqlparser.expression.JsonAggregateUniqueKeysType;
import liquibase.repackaged.net.sf.jsqlparser.expression.JsonFunctionType;
import liquibase.repackaged.net.sf.jsqlparser.expression.OrderByClause;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OrderByElement;

public class JsonAggregateFunction
extends FilterOverImpl
implements Expression {
    private JsonFunctionType functionType;
    private Expression expression = null;
    private final OrderByClause expressionOrderBy = new OrderByClause();
    private boolean usingKeyKeyword = false;
    private String key;
    private boolean usingValueKeyword = false;
    private Object value;
    private boolean usingFormatJson = false;
    private JsonAggregateOnNullType onNullType;
    private JsonAggregateUniqueKeysType uniqueKeysType;

    public JsonAggregateOnNullType getOnNullType() {
        return this.onNullType;
    }

    public void setOnNullType(JsonAggregateOnNullType jsonAggregateOnNullType) {
        this.onNullType = jsonAggregateOnNullType;
    }

    public JsonAggregateFunction withOnNullType(JsonAggregateOnNullType jsonAggregateOnNullType) {
        this.setOnNullType(jsonAggregateOnNullType);
        return this;
    }

    public JsonAggregateUniqueKeysType getUniqueKeysType() {
        return this.uniqueKeysType;
    }

    public void setUniqueKeysType(JsonAggregateUniqueKeysType jsonAggregateUniqueKeysType) {
        this.uniqueKeysType = jsonAggregateUniqueKeysType;
    }

    public JsonAggregateFunction withUniqueKeysType(JsonAggregateUniqueKeysType jsonAggregateUniqueKeysType) {
        this.setUniqueKeysType(jsonAggregateUniqueKeysType);
        return this;
    }

    public JsonFunctionType getType() {
        return this.functionType;
    }

    public void setType(JsonFunctionType jsonFunctionType) {
        this.functionType = Objects.requireNonNull(jsonFunctionType, "The Type of the JSON Aggregate Function must not be null");
    }

    public JsonAggregateFunction withType(JsonFunctionType jsonFunctionType) {
        this.setType(jsonFunctionType);
        return this;
    }

    public void setType(String string) {
        this.functionType = JsonFunctionType.valueOf(Objects.requireNonNull(string, "The Type of the JSON Aggregate Function must not be null").toUpperCase());
    }

    public JsonAggregateFunction withType(String string) {
        this.setType(string);
        return this;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public JsonAggregateFunction withExpression(Expression expression) {
        this.setExpression(expression);
        return this;
    }

    public boolean isUsingKeyKeyword() {
        return this.usingKeyKeyword;
    }

    public void setUsingKeyKeyword(boolean bl2) {
        this.usingKeyKeyword = bl2;
    }

    public JsonAggregateFunction withUsingKeyKeyword(boolean bl2) {
        this.setUsingKeyKeyword(bl2);
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public JsonAggregateFunction withKey(String string) {
        this.setKey(string);
        return this;
    }

    public boolean isUsingValueKeyword() {
        return this.usingValueKeyword;
    }

    public void setUsingValueKeyword(boolean bl2) {
        this.usingValueKeyword = bl2;
    }

    public JsonAggregateFunction withUsingValueKeyword(boolean bl2) {
        this.setUsingValueKeyword(bl2);
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public JsonAggregateFunction withValue(Object object) {
        this.setValue(object);
        return this;
    }

    public boolean isUsingFormatJson() {
        return this.usingFormatJson;
    }

    public void setUsingFormatJson(boolean bl2) {
        this.usingFormatJson = bl2;
    }

    public JsonAggregateFunction withUsingFormatJson(boolean bl2) {
        this.setUsingFormatJson(bl2);
        return this;
    }

    public List<OrderByElement> getExpressionOrderByElements() {
        return this.expressionOrderBy.getOrderByElements();
    }

    public void setExpressionOrderByElements(List<OrderByElement> list) {
        this.expressionOrderBy.setOrderByElements(list);
    }

    public JsonAggregateFunction withExpressionOrderByElements(List<OrderByElement> list) {
        this.setExpressionOrderByElements(list);
        return this;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    @Override
    public StringBuilder append(StringBuilder stringBuilder) {
        switch (this.functionType) {
            case OBJECT: {
                this.appendObject(stringBuilder);
                break;
            }
            case ARRAY: {
                this.appendArray(stringBuilder);
                break;
            }
            default: {
                throw new UnsupportedOperationException("JSON Aggregate Function of the type " + this.functionType.name() + " has not been implemented yet.");
            }
        }
        return stringBuilder;
    }

    public StringBuilder appendObject(StringBuilder stringBuilder) {
        stringBuilder.append("JSON_OBJECTAGG( ");
        if (this.usingValueKeyword) {
            if (this.usingKeyKeyword) {
                stringBuilder.append("KEY ");
            }
            stringBuilder.append(this.key).append(" VALUE ").append(this.value);
        } else {
            stringBuilder.append(this.key).append(":").append(this.value);
        }
        if (this.usingFormatJson) {
            stringBuilder.append(" FORMAT JSON");
        }
        if (this.onNullType != null) {
            switch (this.onNullType) {
                case NULL: {
                    stringBuilder.append(" NULL ON NULL");
                    break;
                }
                case ABSENT: {
                    stringBuilder.append(" ABSENT On NULL");
                }
            }
        }
        if (this.uniqueKeysType != null) {
            switch (this.uniqueKeysType) {
                case WITH: {
                    stringBuilder.append(" WITH UNIQUE KEYS");
                    break;
                }
                case WITHOUT: {
                    stringBuilder.append(" WITHOUT UNIQUE KEYS");
                }
            }
        }
        stringBuilder.append(" ) ");
        super.append(stringBuilder);
        return stringBuilder;
    }

    public StringBuilder appendArray(StringBuilder stringBuilder) {
        stringBuilder.append("JSON_ARRAYAGG( ");
        stringBuilder.append(this.expression).append(" ");
        if (this.usingFormatJson) {
            stringBuilder.append("FORMAT JSON ");
        }
        this.expressionOrderBy.toStringOrderByElements(stringBuilder);
        if (this.onNullType != null) {
            switch (this.onNullType) {
                case NULL: {
                    stringBuilder.append(" NULL ON NULL ");
                    break;
                }
                case ABSENT: {
                    stringBuilder.append(" ABSENT On NULL ");
                }
            }
        }
        stringBuilder.append(") ");
        super.append(stringBuilder);
        return stringBuilder;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        return this.append(stringBuilder).toString();
    }
}

