/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm.externalstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.externalstore.model.IDMEntityType;
import org.exoplatform.services.organization.idm.GroupDAOImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.externalstore.PicketLinkIDMExternalStoreService;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.User;
import org.picketlink.idm.api.query.QueryBuilder;
import org.picketlink.idm.api.query.UserQuery;
import org.picketlink.idm.api.query.UserQueryBuilder;
import org.picketlink.idm.impl.api.IdentitySearchCriteriaImpl;

public class IDMExternalStoreListAccess
implements ListAccess<String> {
    private static final Log LOG = ExoLogger.getLogger(IDMExternalStoreListAccess.class);
    private Class<?> entityTypeClass;
    private QueryBuilder idmQueryBuilder = null;
    private PicketLinkIDMService picketLinkIDMService = null;
    private OrganizationService organizationService = null;
    private PicketLinkIDMExternalStoreService externalStoreService = null;
    private IdentitySearchCriteriaImpl searchCriteria = null;
    private Set<String> externalMappedGroups;

    public IDMExternalStoreListAccess(PicketLinkIDMExternalStoreService externalStoreService, OrganizationService organizationService, PicketLinkIDMService picketLinkIDMService, Class<?> entityType, QueryBuilder idmQueryBuilder, IdentitySearchCriteriaImpl searchCriteria, Set<String> externalMappedGroups) {
        this.organizationService = organizationService;
        this.picketLinkIDMService = picketLinkIDMService;
        this.externalStoreService = externalStoreService;
        this.idmQueryBuilder = idmQueryBuilder;
        this.searchCriteria = searchCriteria;
        this.entityTypeClass = entityType;
        this.externalMappedGroups = externalMappedGroups;
    }

    public String[] load(int index, int length) throws Exception {
        String[] result = (String[])this.externalStoreService.executeOnExternalStore(() -> {
            IdentitySession identitySession = this.picketLinkIDMService.getIdentitySession();
            if (IDMEntityType.USER.getClassType().equals(this.entityTypeClass)) {
                UserQueryBuilder userQueryBuilder = (UserQueryBuilder)this.idmQueryBuilder;
                UserQuery query = userQueryBuilder.createQuery();
                List idmUsers = identitySession.list(query);
                ArrayList<String> users = new ArrayList<String>();
                for (User idmUser : idmUsers) {
                    users.add(idmUser.getId());
                }
                return users.toArray(new String[0]);
            }
            if (IDMEntityType.GROUP.getClassType().equals(this.entityTypeClass)) {
                ArrayList idmGroups = new ArrayList();
                for (String groupType : this.externalMappedGroups) {
                    Collection idmModifiedGroups = identitySession.getPersistenceManager().findGroup(groupType, (IdentitySearchCriteria)this.searchCriteria);
                    if (idmModifiedGroups == null || idmModifiedGroups.isEmpty()) continue;
                    idmGroups.addAll(idmModifiedGroups);
                }
                ArrayList<String> groups = new ArrayList<String>();
                for (Group idmGroup : idmGroups) {
                    GroupHandler groupHandler = this.organizationService.getGroupHandler();
                    if (!(groupHandler instanceof GroupDAOImpl)) {
                        throw new IllegalStateException("groupHandler class is not recognized :" + groupHandler.getClass());
                    }
                    try {
                        String groupId = ((GroupDAOImpl)groupHandler).getGroupId(idmGroup, null);
                        if (!StringUtils.isNotBlank((CharSequence)groupId)) continue;
                        groups.add(groupId);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("An error occurred while converting PLIDM group " + idmGroup + " to Exo Group"), (Throwable)e);
                    }
                }
                return groups.toArray(new String[0]);
            }
            if (IDMEntityType.ROLE.getClassType().equals(this.entityTypeClass)) {
                Collection roleTypes = identitySession.getRoleManager().findRoleTypes();
                HashSet<String> roles = new HashSet<String>();
                for (RoleType rt : roleTypes) {
                    roles.add(rt.getName());
                }
                return roles.toArray(new String[0]);
            }
            return null;
        });
        return result;
    }

    public int getSize() throws Exception {
        throw new UnsupportedOperationException("No LDAP implementation is provided to get size of query");
    }
}

