/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.jaas.AbstractLoginModule;

public class InitSharedStateLoginModule
extends AbstractLoginModule {
    private static final Log log = ExoLogger.getLogger(InitSharedStateLoginModule.class);

    protected Log getLogger() {
        return log;
    }

    public boolean login() throws LoginException {
        try {
            Callback[] callbacks = new Callback[]{new NameCallback("Username"), new PasswordCallback("Password", false)};
            this.callbackHandler.handle(callbacks);
            String username = ((NameCallback)callbacks[0]).getName();
            String password = new String(((PasswordCallback)callbacks[1]).getPassword());
            ((PasswordCallback)callbacks[1]).clearPassword();
            if (username == null || password == null) {
                log.warn((Object)"Username or password not found in callbacks");
                return false;
            }
            this.sharedState.put("javax.security.auth.login.name", username);
            this.sharedState.put("javax.security.auth.login.password", password);
            return true;
        }
        catch (Exception e) {
            LoginException le = new LoginException();
            le.initCause(e);
            throw le;
        }
    }

    public boolean commit() throws LoginException {
        return true;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean logout() throws LoginException {
        return true;
    }
}

