/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import juzu.impl.common.Tools;

public class Spliterator
implements Iterator<String> {
    private final CharSequence s;
    private final char separator;
    private int from;
    private int current;
    private int to;

    public static Iterable<String> split(final String s, final char separator) throws NullPointerException {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Spliterator(s, separator);
            }
        };
    }

    public static Iterable<String> split(final String s, final int from, final int to, final char separator) throws NullPointerException, IndexOutOfBoundsException {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Spliterator(s, from, to, separator);
            }
        };
    }

    public static <C extends Collection<String>> C split(String s, char separator, C collection) throws NullPointerException {
        Spliterator i = new Spliterator(s, separator);
        while (i.hasNext()) {
            collection.add((String)i.next());
        }
        return collection;
    }

    public static <C extends Collection<String>> C split(String s, int from, int to, char separator, C collection) throws NullPointerException {
        Spliterator i = new Spliterator(s, from, to, separator);
        while (i.hasNext()) {
            collection.add((String)i.next());
        }
        return collection;
    }

    public Spliterator(String s, char separator) throws NullPointerException {
        this(s, 0, s.length(), separator);
    }

    public Spliterator(CharSequence s, int from, int to, char separator) throws NullPointerException, IndexOutOfBoundsException {
        if (s == null) {
            throw new NullPointerException();
        }
        if (from < 0) {
            throw new IndexOutOfBoundsException("Lower bound cannot be negative");
        }
        if (to > s.length()) {
            throw new IndexOutOfBoundsException("Upper bound cannot be greater than sequence length");
        }
        if (from > to) {
            throw new IndexOutOfBoundsException("Upper bound cannot be greater than lower bound");
        }
        int pos = Tools.indexOf(s, separator, from);
        this.s = s;
        this.separator = separator;
        this.from = from;
        this.current = pos == -1 ? to : pos;
        this.to = to;
    }

    @Override
    public boolean hasNext() {
        return this.current != -1;
    }

    @Override
    public String next() {
        if (this.hasNext()) {
            String next = this.s.subSequence(this.from, this.current).toString();
            if (this.current < this.to) {
                this.from = this.current + 1;
                int pos = Tools.indexOf(this.s, this.separator, this.current + 1);
                this.current = pos == -1 ? this.to : pos;
            } else {
                this.current = -1;
            }
            return next;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

