/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Calendar;
import java.util.Properties;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchemaBasic;
import org.apache.jempbox.xmp.XMPSchemaDublinCore;
import org.apache.jempbox.xmp.XMPSchemaPDF;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.util.XMLUtil;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.document.DCMetaData;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PDFDocumentReader
extends BaseDocumentReader {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.document.PDFDocumentReader");

    @Override
    public String[] getMimeTypes() {
        return new String[]{"application/pdf"};
    }

    @Override
    public String getContentAsText(final InputStream is) throws IOException, DocumentReadException {
        try {
            return (String)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String run() throws Exception {
                    if (is == null) {
                        throw new IllegalArgumentException("InputStream is null.");
                    }
                    PDDocument pdDocument = null;
                    StringWriter sw = new StringWriter();
                    try {
                        if (is.available() == 0) {
                            String string = "";
                            return string;
                        }
                        try {
                            pdDocument = PDDocument.load((InputStream)is);
                        }
                        catch (IOException e) {
                            throw new DocumentReadException("Can not load PDF document.", e);
                        }
                        PDFTextStripper stripper = new PDFTextStripper();
                        stripper.setStartPage(1);
                        stripper.setEndPage(Integer.MAX_VALUE);
                        stripper.writeText(pdDocument, (Writer)sw);
                    }
                    finally {
                        block24: {
                            block23: {
                                if (pdDocument != null) {
                                    try {
                                        pdDocument.close();
                                    }
                                    catch (IOException e) {
                                        if (!LOG.isTraceEnabled()) break block23;
                                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                                    }
                                }
                            }
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {
                                    if (!LOG.isTraceEnabled()) break block24;
                                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                                }
                            }
                        }
                    }
                    return sw.toString();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    @Override
    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    @Override
    public Properties getProperties(final InputStream is) throws IOException, DocumentReadException {
        try {
            return (Properties)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Properties>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Properties run() throws Exception {
                    Properties props;
                    block64: {
                        if (is == null) {
                            throw new IllegalArgumentException("InputStream is null.");
                        }
                        PDDocument pdDocument = PDDocument.load((InputStream)is);
                        props = new Properties();
                        try {
                            PDDocumentInformation docInfo;
                            PDDocumentCatalog catalog = pdDocument.getDocumentCatalog();
                            PDMetadata meta = catalog.getMetadata();
                            if (meta != null) {
                                XMPSchemaBasic basic;
                                XMPSchemaPDF pdf;
                                XMPMetadata metadata = new XMPMetadata(XMLUtil.parse((InputStream)meta.createInputStream()));
                                XMPSchemaDublinCore dc = metadata.getDublinCoreSchema();
                                if (dc != null) {
                                    try {
                                        if (dc.getTitle() != null) {
                                            props.put(DCMetaData.TITLE, PDFDocumentReader.this.fixEncoding(dc.getTitle()));
                                        }
                                    }
                                    catch (Exception e) {
                                        LOG.warn((Object)("getTitle failed: " + e.getMessage()));
                                    }
                                    try {
                                        if (dc.getDescription() != null) {
                                            props.put(DCMetaData.DESCRIPTION, PDFDocumentReader.this.fixEncoding(dc.getDescription()));
                                        }
                                    }
                                    catch (Exception e) {
                                        LOG.warn((Object)("getSubject failed: " + e.getMessage()));
                                    }
                                    try {
                                        if (dc.getCreators() != null) {
                                            for (String creator : dc.getCreators()) {
                                                props.put(DCMetaData.CREATOR, PDFDocumentReader.this.fixEncoding(creator));
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        LOG.warn((Object)("getCreator failed: " + e.getMessage()));
                                    }
                                    try {
                                        if (dc.getDates() != null) {
                                            for (Calendar date : dc.getDates()) {
                                                props.put(DCMetaData.DATE, date);
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        LOG.warn((Object)("getDate failed: " + e.getMessage()));
                                    }
                                }
                                if ((pdf = metadata.getPDFSchema()) != null) {
                                    try {
                                        if (pdf.getKeywords() != null) {
                                            props.put(DCMetaData.SUBJECT, PDFDocumentReader.this.fixEncoding(pdf.getKeywords()));
                                        }
                                    }
                                    catch (Exception e) {
                                        LOG.warn((Object)("getKeywords failed: " + e.getMessage()));
                                    }
                                    try {
                                        if (pdf.getProducer() != null) {
                                            props.put(DCMetaData.PUBLISHER, PDFDocumentReader.this.fixEncoding(pdf.getProducer()));
                                        }
                                    }
                                    catch (Exception e) {
                                        LOG.warn((Object)("getProducer failed: " + e.getMessage()));
                                    }
                                }
                                if ((basic = metadata.getBasicSchema()) != null) {
                                    try {
                                        if (basic.getCreateDate() != null) {
                                            props.put(DCMetaData.DATE, basic.getCreateDate());
                                        }
                                    }
                                    catch (Exception e) {
                                        LOG.warn((Object)("getCreationDate failed: " + e.getMessage()));
                                    }
                                    try {
                                        if (basic.getModifyDate() != null) {
                                            props.put(DCMetaData.DATE, basic.getModifyDate());
                                        }
                                    }
                                    catch (Exception e) {
                                        LOG.warn((Object)("getModificationDate failed: " + e.getMessage()));
                                    }
                                }
                            }
                            if (!props.isEmpty() || (docInfo = pdDocument.getDocumentInformation()) == null) break block64;
                            try {
                                if (docInfo.getAuthor() != null) {
                                    props.put(DCMetaData.CONTRIBUTOR, docInfo.getAuthor());
                                }
                            }
                            catch (Exception e) {
                                LOG.warn((Object)("getAuthor failed: " + e.getMessage()));
                            }
                            try {
                                if (docInfo.getCreationDate() != null) {
                                    props.put(DCMetaData.DATE, docInfo.getCreationDate());
                                }
                            }
                            catch (Exception e) {
                                LOG.warn((Object)("getCreationDate failed: " + e.getMessage()));
                            }
                            try {
                                if (docInfo.getCreator() != null) {
                                    props.put(DCMetaData.CREATOR, docInfo.getCreator());
                                }
                            }
                            catch (Exception e) {
                                LOG.warn((Object)("getCreator failed: " + e.getMessage()));
                            }
                            try {
                                if (docInfo.getKeywords() != null) {
                                    props.put(DCMetaData.SUBJECT, docInfo.getKeywords());
                                }
                            }
                            catch (Exception e) {
                                LOG.warn((Object)("getKeywords failed: " + e.getMessage()));
                            }
                            try {
                                if (docInfo.getModificationDate() != null) {
                                    props.put(DCMetaData.DATE, docInfo.getModificationDate());
                                }
                            }
                            catch (Exception e) {
                                LOG.warn((Object)("getModificationDate failed: " + e.getMessage()));
                            }
                            try {
                                if (docInfo.getProducer() != null) {
                                    props.put(DCMetaData.PUBLISHER, docInfo.getProducer());
                                }
                            }
                            catch (Exception e) {
                                LOG.warn((Object)("getProducer failed: " + e.getMessage()));
                            }
                            try {
                                if (docInfo.getSubject() != null) {
                                    props.put(DCMetaData.DESCRIPTION, docInfo.getSubject());
                                }
                            }
                            catch (Exception e) {
                                LOG.warn((Object)("getSubject failed: " + e.getMessage()));
                            }
                            try {
                                if (docInfo.getTitle() != null) {
                                    props.put(DCMetaData.TITLE, docInfo.getTitle());
                                }
                            }
                            catch (Exception e) {
                                LOG.warn((Object)("getTitle failed: " + e.getMessage()));
                            }
                        }
                        finally {
                            block65: {
                                if (pdDocument != null) {
                                    pdDocument.close();
                                }
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (IOException e) {
                                        if (!LOG.isTraceEnabled()) break block65;
                                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                                    }
                                }
                            }
                        }
                    }
                    return props;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private String fixEncoding(String str) {
        try {
            String encoding = null;
            int orderMaskOffset = 0;
            if (str.startsWith("\\000\\000\\376\\377")) {
                encoding = "UTF-32BE";
                orderMaskOffset = 16;
            } else if (str.startsWith("\\377\\376\\000\\000")) {
                encoding = "UTF-32LE";
                orderMaskOffset = 16;
            } else if (str.startsWith("\\376\\377")) {
                encoding = "UTF-16BE";
                orderMaskOffset = 8;
            } else if (str.startsWith("\\377\\376")) {
                encoding = "UTF-16LE";
                orderMaskOffset = 8;
            }
            if (encoding == null) {
                return str;
            }
            int i = orderMaskOffset;
            int len = str.length();
            StringBuilder sb = new StringBuilder(len);
            while (i < len) {
                char c;
                if ((c = str.charAt(i++)) == '\\') {
                    if (i + 3 <= len) {
                        try {
                            c = (char)Integer.parseInt(str.substring(i, i + 3), 8);
                            i += 3;
                        }
                        catch (NumberFormatException e) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("PDF metadata exctraction warning: can not decode octal code - " + str.substring(i - 1, i + 3) + "."), (Throwable)e);
                            }
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("PDF metadata exctraction warning: octal code is not complete - " + str.substring(i - 1, len)));
                    }
                }
                sb.append(c);
            }
            byte[] bytes = sb.toString().getBytes();
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("PDF metadata exctraction warning: can not convert metadata string " + str), (Throwable)e);
            return "";
        }
    }
}

