/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.module;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.module.Module;
import org.exoplatform.portal.module.ModulePlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.picocontainer.Startable;

public class ModuleRegistry
implements Startable {
    private static final Log LOG = ExoLogger.getExoLogger(ModuleRegistry.class);
    private Map<String, Boolean> isPortletActiveCache = new ConcurrentHashMap<String, Boolean>();
    private boolean isPortletDisplayNamesImported = false;
    private Map<String, Module> modulesByName = new HashMap<String, Module>();
    private Map<String, Set<Module>> modulesByWebapp = new HashMap<String, Set<Module>>();
    private Map<String, Set<Module>> modulesByPortlet = new HashMap<String, Set<Module>>();
    private Map<String, LocalizedString> portletDisplayNames = new HashMap<String, LocalizedString>();

    public ModuleRegistry(InitParams initParams) {
        if (initParams != null) {
            for (Module module : initParams.getObjectParamValues(Module.class)) {
                this.modulesByName.put(module.getName(), module);
            }
        }
    }

    public void addModule(ModulePlugin modulePlugin) {
        if (modulePlugin != null && !modulePlugin.getModulesByName().isEmpty()) {
            this.modulesByName.putAll(modulePlugin.getModulesByName());
        }
    }

    public void start() {
        Collection<Module> modules = this.getAvailableModules();
        for (Module module : modules) {
            for (String webappName : module.getWebapps()) {
                Set<Module> webappModules = this.modulesByWebapp.get(webappName);
                if (webappModules == null) {
                    webappModules = new HashSet<Module>();
                    this.modulesByWebapp.put(webappName, webappModules);
                }
                webappModules.add(module);
            }
        }
        for (Module module : modules) {
            if (module.getPortlets() == null || module.getPortlets().isEmpty()) continue;
            for (String portletId : module.getPortlets()) {
                if (!portletId.contains("/")) {
                    LOG.warn((Object)(portletId + " isn't a valid portlet ID, it have to be something like: {webappName}/{portletName}."));
                    continue;
                }
                Set<Module> portletModules = this.modulesByPortlet.get(portletId);
                if (portletModules == null) {
                    portletModules = new HashSet<Module>();
                    this.modulesByPortlet.put(portletId, portletModules);
                    String[] portletIdSplitted = portletId.split("/");
                    String webappName = portletIdSplitted[0];
                    Set<Module> webappModules = this.modulesByWebapp.get(webappName);
                    if (webappModules != null && !webappModules.isEmpty()) {
                        portletModules.addAll(webappModules);
                    }
                }
                portletModules.add(module);
            }
        }
    }

    public String getDisplayName(String portletName, Locale locale) {
        String portletDisplayName = portletName;
        if (this.portletDisplayNames.get(portletName) != null) {
            portletDisplayName = this.portletDisplayNames.get(portletName).getValue(locale, true).getString();
        } else if (!this.isPortletDisplayNamesImported) {
            PortletInvoker portletInvoker = (PortletInvoker)PortalContainer.getComponent(PortletInvoker.class);
            try {
                Set portlets = portletInvoker.getPortlets();
                for (Portlet portlet : portlets) {
                    this.portletDisplayNames.put(portlet.getInfo().getName(), portlet.getInfo().getMeta().getMetaValue("display-name"));
                }
                this.isPortletDisplayNamesImported = true;
            }
            catch (PortletInvokerException exception) {
                LOG.error((Object)"Error occurred when trying to import portlets", (Throwable)exception);
            }
            if (this.portletDisplayNames.get(portletName) != null) {
                portletDisplayName = this.portletDisplayNames.get(portletName).getValue(locale, true).getString();
            }
        }
        return portletDisplayName;
    }

    public Set<String> getModulesForWebapp(String webappName) {
        HashSet<String> profileNames = new HashSet<String>();
        Set<Module> webappModules = this.modulesByWebapp.get(webappName);
        if (webappModules != null && !webappModules.isEmpty()) {
            for (Module module : webappModules) {
                profileNames.add(module.getName());
            }
        }
        return profileNames;
    }

    public Set<String> getModulesForPortlet(String portletId) {
        Set<String> profileNames = new HashSet<String>();
        Set<Module> portletModules = this.modulesByPortlet.get(portletId);
        if (portletModules == null || portletModules.isEmpty()) {
            String[] portletIdSplitted = portletId.split("/");
            String webappName = portletIdSplitted[0];
            profileNames = this.getModulesForWebapp(webappName);
        } else {
            for (Module module : portletModules) {
                profileNames.add(module.getName());
            }
        }
        return profileNames;
    }

    public boolean isPortletActive(String portletId) {
        Boolean isPortletActive = this.isPortletActiveCache.get(portletId);
        if (isPortletActive != null) {
            return isPortletActive;
        }
        Set<String> portletActiveProfiles = this.getModulesForPortlet(portletId);
        if (portletActiveProfiles == null || portletActiveProfiles.isEmpty()) {
            isPortletActive = true;
        } else {
            Set currentActiveProfiles = ExoContainer.getProfiles();
            portletActiveProfiles.retainAll(currentActiveProfiles);
            isPortletActive = !portletActiveProfiles.isEmpty();
        }
        this.isPortletActiveCache.put(portletId, isPortletActive);
        return isPortletActive;
    }

    public void stop() {
    }

    private Collection<Module> getAvailableModules() {
        return this.modulesByName.values();
    }
}

