/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.jdbc.service;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.portal.jdbc.entity.DescriptionEntity;
import org.exoplatform.portal.jdbc.entity.DescriptionState;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.jdbc.dao.DescriptionDAO;

public class DescriptionServiceImpl
implements DescriptionService {
    private DescriptionDAO descDAO;

    public DescriptionServiceImpl(DescriptionDAO descDAO) {
        this.descDAO = descDAO;
    }

    @Override
    public State resolveDescription(String id, Locale locale) throws NullPointerException {
        if (id == null) {
            throw new NullPointerException("No null id accepted");
        }
        if (locale == null) {
            throw new NullPointerException("No null locale accepted");
        }
        DescriptionEntity desc = this.descDAO.getByRefId(id);
        if (desc != null) {
            Locale current = locale;
            while (current != null) {
                DescriptionState state = desc.getLocalized().get(I18N.toTagIdentifier((Locale)current));
                if (state != null) {
                    State result = new State(state.getName(), state.getDescription());
                    return result;
                }
                current = DescriptionServiceImpl.parent(current);
            }
        }
        return null;
    }

    @Override
    public State resolveDescription(String id, Locale locale2, Locale locale1) throws NullPointerException {
        State state = this.resolveDescription(id, locale1);
        if (state == null && locale2 != null) {
            state = this.resolveDescription(id, locale2);
        }
        return state;
    }

    @Override
    public State getDescription(String id, Locale locale) {
        DescriptionState state;
        if (id == null) {
            throw new NullPointerException("No null id accepted");
        }
        if (locale == null) {
            throw new NullPointerException("No null locale accepted");
        }
        DescriptionEntity desc = this.descDAO.getByRefId(id);
        if (desc != null && (state = desc.getLocalized().get(I18N.toTagIdentifier((Locale)locale))) != null) {
            State result = new State(state.getName(), state.getDescription());
            return result;
        }
        return null;
    }

    @Override
    public void setDescription(String id, Locale locale, State description) {
        if (id == null) {
            throw new NullPointerException("No null id accepted");
        }
        if (locale == null) {
            throw new NullPointerException("No null locale accepted");
        }
        if (locale.getLanguage().length() == 0) {
            throw new IllegalArgumentException("No language set on locale");
        }
        if (locale.getVariant().length() > 0) {
            throw new IllegalArgumentException("No variant cab be set on locale");
        }
        HashMap<String, DescriptionState> state = new HashMap<String, DescriptionState>();
        DescriptionEntity entity = this.descDAO.getByRefId(id);
        if (entity != null) {
            state.putAll(entity.getLocalized());
        }
        if (description != null) {
            state.put(I18N.toTagIdentifier((Locale)locale), new DescriptionState(description.getName(), description.getDescription()));
        } else {
            state.remove(I18N.toTagIdentifier((Locale)locale));
        }
        this.descDAO.saveDescriptions(id, state);
    }

    @Override
    public State getDescription(String id) {
        DescriptionState state;
        if (id == null) {
            throw new NullPointerException("No null id accepted");
        }
        DescriptionEntity desc = this.descDAO.getByRefId(id);
        if (desc != null && (state = desc.getState()) != null) {
            State result = new State(state.getName(), state.getDescription());
            return result;
        }
        return null;
    }

    @Override
    public void setDescription(String id, State description) {
        if (id == null) {
            throw new NullPointerException("No null id accepted");
        }
        if (description != null) {
            this.descDAO.saveDescription(id, new DescriptionState(description.getName(), description.getDescription()));
        } else {
            this.descDAO.deleteByRefId(id);
        }
    }

    @Override
    public Map<Locale, State> getDescriptions(String id) {
        Map<String, DescriptionState> localized;
        if (id == null) {
            throw new NullPointerException("No null id accepted");
        }
        HashMap<Locale, State> names = null;
        DescriptionEntity desc = this.descDAO.getByRefId(id);
        if (desc != null && (localized = desc.getLocalized()) != null) {
            names = new HashMap<Locale, State>(localized.size());
            for (String locale : localized.keySet()) {
                DescriptionState state = localized.get(locale);
                names.put(I18N.parseTagIdentifier((String)locale), new State(state.getName(), state.getDescription()));
            }
        }
        return names;
    }

    @Override
    public void setDescriptions(String id, Map<Locale, State> descriptions) {
        if (id == null) {
            throw new NullPointerException("No null id accepted");
        }
        if (descriptions != null) {
            HashMap<String, DescriptionState> localized = new HashMap<String, DescriptionState>(descriptions.size());
            for (Locale locale : descriptions.keySet()) {
                if (locale.getLanguage().length() == 0) {
                    throw new IllegalArgumentException("No language set on locale");
                }
                if (locale.getVariant().length() > 0) {
                    throw new IllegalArgumentException("No variant cab be set on locale");
                }
                State state = descriptions.get(locale);
                localized.put(I18N.toTagIdentifier((Locale)locale), new DescriptionState(state.getName(), state.getDescription()));
            }
            this.descDAO.saveDescriptions(id, localized);
        } else {
            this.descDAO.deleteByRefId(id);
        }
    }

    private static Locale parent(Locale locale) {
        if (locale.getVariant() != null && !locale.getVariant().isEmpty()) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (locale.getCountry() != null && !locale.getCountry().isEmpty()) {
            return new Locale(locale.getLanguage());
        }
        return null;
    }
}

