/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.register;

import javax.servlet.http.HttpServletRequest;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.webui.register.UIRegisterForm;
import org.exoplatform.portal.webui.register.UIRegisterInputSet;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.impl.UserImpl;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.gatein.security.oauth.exception.OAuthException;
import org.gatein.security.oauth.exception.OAuthExceptionCode;
import org.gatein.security.oauth.spi.OAuthPrincipal;

@ComponentConfig(template="system:/groovy/portal/webui/portal/UIRegisterOAuthForm.gtmpl")
public class UIRegisterOAuth
extends UIContainer {
    private static Log log = ExoLogger.getLogger(UIRegisterOAuth.class);
    private static final String[] ACTIONS = new String[]{"SubscribeOAuth", "Reset", "Cancel"};
    static final String REGISTER_FORM_CONFIG_ID = "UIRegisterFormOAuth";
    private final User portalUser;

    public UIRegisterOAuth() throws Exception {
        this.addChild(UIRegisterForm.class, REGISTER_FORM_CONFIG_ID, REGISTER_FORM_CONFIG_ID);
        UIRegisterForm uiRegisterForm = (UIRegisterForm)this.getChild(UIRegisterForm.class);
        uiRegisterForm.setActions(ACTIONS);
        AuthenticationRegistry authRegistry = (AuthenticationRegistry)this.getApplicationComponent(AuthenticationRegistry.class);
        User portalUser = (User)authRegistry.getAttributeOfClient(Util.getPortalRequestContext().getRequest(), "_authenticatedPortalUser");
        if (portalUser == null) {
            log.warn((Object)"portalUser from OAuth login is not available!");
            this.portalUser = new UserImpl();
        } else {
            this.portalUser = portalUser;
        }
        this.setupUserToRegisterForm();
    }

    private void setupUserToRegisterForm() {
        UIRegisterForm uiRegisterForm = (UIRegisterForm)this.getChild(UIRegisterForm.class);
        UIRegisterInputSet uiRegisterInputSet = (UIRegisterInputSet)uiRegisterForm.getChild(UIRegisterInputSet.class);
        uiRegisterInputSet.getUIStringInput(UIRegisterInputSet.USER_NAME).setValue((Object)this.portalUser.getUserName());
        uiRegisterInputSet.getUIStringInput(UIRegisterInputSet.FIRST_NAME).setValue((Object)this.portalUser.getFirstName());
        uiRegisterInputSet.getUIStringInput(UIRegisterInputSet.LAST_NAME).setValue((Object)this.portalUser.getLastName());
        uiRegisterInputSet.getUIStringInput(UIRegisterInputSet.EMAIL_ADDRESS).setValue((Object)this.portalUser.getEmail());
        uiRegisterInputSet.getUIStringInput(UIRegisterInputSet.PASSWORD).setValue(null);
        uiRegisterInputSet.getUIStringInput(UIRegisterInputSet.CONFIRM_PASSWORD).setValue(null);
        uiRegisterInputSet.getUIStringInput(UIRegisterInputSet.DISPLAY_NAME).setValue((Object)this.portalUser.getDisplayName());
    }

    public static class SubscribeOAuthActionListener
    extends UIRegisterForm.SubscribeActionListener {
        @Override
        public void execute(Event<UIRegisterForm> event) throws Exception {
            super.execute(event);
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            User newUser = (User)context.getAttribute("UIRegisterForm$User");
            if (newUser != null) {
                UIApplication uiApp = context.getUIApplication();
                UIRegisterForm uiRegisterForm = (UIRegisterForm)((Object)event.getSource());
                PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
                OrganizationService orgService = (OrganizationService)uiRegisterForm.getApplicationComponent(OrganizationService.class);
                UserProfileHandler profileHandler = orgService.getUserProfileHandler();
                UserProfile newUserProfile = profileHandler.findUserProfileByName(newUser.getUserName());
                AuthenticationRegistry authRegistry = (AuthenticationRegistry)uiRegisterForm.getApplicationComponent(AuthenticationRegistry.class);
                HttpServletRequest httpRequest = portalRequestContext.getRequest();
                OAuthPrincipal oauthPrincipal = (OAuthPrincipal)authRegistry.getAttributeOfClient(httpRequest, "_authenticatedOAuthPrincipal");
                if (newUserProfile == null) {
                    newUserProfile = orgService.getUserProfileHandler().createUserProfileInstance(newUser.getUserName());
                }
                newUserProfile.setAttribute(oauthPrincipal.getOauthProviderType().getUserNameAttrName(), oauthPrincipal.getUserName());
                try {
                    profileHandler.saveUserProfile(newUserProfile, true);
                }
                catch (OAuthException gtnOAuthException) {
                    if (gtnOAuthException.getExceptionCode() == OAuthExceptionCode.DUPLICATE_OAUTH_PROVIDER_USERNAME) {
                        orgService.getUserHandler().removeUser(newUser.getUserName(), true);
                        Object[] args = new Object[]{gtnOAuthException.getExceptionAttribute("OAuthProviderUsername"), gtnOAuthException.getExceptionAttribute("OAuthProviderName")};
                        ApplicationMessage appMessage = new ApplicationMessage("UIAccountSocial.msg.failed-registration", args, 1);
                        uiApp.addMessage(appMessage);
                        return;
                    }
                    throw gtnOAuthException;
                }
                authRegistry.removeAttributeOfClient(httpRequest, "_authenticatedPortalUser");
                uiApp.clearMessages();
                UIMaskWorkspace.CloseActionListener closePopupListener = new UIMaskWorkspace.CloseActionListener();
                closePopupListener.execute(event);
                SiteKey siteKey = portalRequestContext.getSiteKey();
                NodeURL urlToRedirect = (NodeURL)portalRequestContext.createURL(NodeURL.TYPE);
                urlToRedirect.setResource(new NavigationResource(siteKey, portalRequestContext.getNodePath()));
                portalRequestContext.getJavascriptManager().addJavascript((CharSequence)("window.location = '" + urlToRedirect.toString() + "';"));
            }
        }
    }

    public static class CancelActionListener
    extends UIMaskWorkspace.CloseActionListener {
        @Override
        public void execute(Event<UIComponent> event) throws Exception {
            super.execute(event);
            AuthenticationRegistry authRegistry = (AuthenticationRegistry)((UIComponent)event.getSource()).getApplicationComponent(AuthenticationRegistry.class);
            HttpServletRequest httpRequest = Util.getPortalRequestContext().getRequest();
            authRegistry.removeAttributeOfClient(httpRequest, "_authenticatedOAuthPrincipal");
            authRegistry.removeAttributeOfClient(httpRequest, "_authenticatedPortalUser");
            if (log.isTraceEnabled()) {
                log.trace((Object)"Registration with OAuth properties terminated. Clearing authentication context");
            }
        }
    }

    public static class ResetActionListener
    extends EventListener<UIRegisterForm> {
        public void execute(Event<UIRegisterForm> event) throws Exception {
            UIRegisterForm registerForm = (UIRegisterForm)((Object)event.getSource());
            UIRegisterOAuth uiRegisterOAuth = (UIRegisterOAuth)registerForm.getAncestorOfType(UIRegisterOAuth.class);
            uiRegisterOAuth.setupUserToRegisterForm();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)registerForm);
        }
    }
}

